/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.RelativeTimeDateFormat;
import org.apache.log4j.spi.LoggingEvent;

public abstract class DateLayout
extends Layout {
    public static final String NULL_DATE_FORMAT = "NULL";
    public static final String RELATIVE_TIME_DATE_FORMAT = "RELATIVE";
    protected FieldPosition pos = new FieldPosition(0);
    public static final String DATE_FORMAT_OPTION = "DateFormat";
    public static final String TIMEZONE_OPTION = "TimeZone";
    private String timeZoneID;
    private String dateFormatOption;
    protected DateFormat dateFormat;
    protected Date date = new Date();

    public DateLayout() {
    }

    public DateLayout(String dateFormatType) {
        this.setDateFormat(dateFormatType);
    }

    public String[] getOptionStrings() {
        return new String[]{DATE_FORMAT_OPTION, TIMEZONE_OPTION};
    }

    public void setOption(String option, String value) {
        if (option.equalsIgnoreCase(DATE_FORMAT_OPTION)) {
            this.dateFormatOption = value.toUpperCase();
        } else if (option.equalsIgnoreCase(TIMEZONE_OPTION)) {
            this.timeZoneID = value;
        }
    }

    public void setDateFormat(String dateFormat) {
        if (dateFormat != null) {
            this.dateFormatOption = dateFormat;
        }
        this.setDateFormat(this.dateFormatOption, TimeZone.getDefault());
    }

    public String getDateFormat() {
        return this.dateFormatOption;
    }

    public void setTimeZone(String timeZone) {
        this.timeZoneID = timeZone;
    }

    public String getTimeZone() {
        return this.timeZoneID;
    }

    public void activateOptions() {
    }

    public void setDateFormat(DateFormat dateFormat, TimeZone timeZone) {
        this.dateFormat = dateFormat;
        this.dateFormat.setTimeZone(timeZone);
    }

    public void setDateFormat(String dateFormatStr, TimeZone timeZone) {
        if (dateFormatStr == null) {
            this.dateFormat = null;
            return;
        }
        if (!dateFormatStr.equalsIgnoreCase(NULL_DATE_FORMAT)) {
            if (dateFormatStr.equalsIgnoreCase(RELATIVE_TIME_DATE_FORMAT)) {
                this.dateFormat = new RelativeTimeDateFormat();
            } else {
                this.dateFormat = dateFormatStr.equalsIgnoreCase("ABSOLUTE") ? new SimpleDateFormat("HH:mm:ss,SSS") : (dateFormatStr.equalsIgnoreCase("DATE") ? new SimpleDateFormat("dd MMM yyyy HH:mm:ss,SSS") : (dateFormatStr.equalsIgnoreCase("ISO8601") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS") : new SimpleDateFormat(dateFormatStr)));
                if (timeZone != null) {
                    this.dateFormat.setTimeZone(timeZone);
                }
            }
        }
    }

    public void dateFormat(StringBuffer buf, LoggingEvent event) {
        if (this.dateFormat != null) {
            this.date.setTime(event.timeStamp);
            this.dateFormat.format(this.date, buf, this.pos);
            buf.append(' ');
        }
    }
}

