/**
 * Unit-API - Units of Measurement API for Java
 * Copyright (c) 2014 Jean-Marie Dautelle, Werner Keil, V2COM
 * All rights reserved.
 *
 * See LICENSE.txt for details.
 */
package si.uom.quantity;

import javax.measure.Quantity;


/**
 * Force that produces magnetic flux.
 * The metric system unit for this quantity is "At" (ampere-turn).
 *
 * @author <a href="mailto:jean-marie@dautelle.com">Jean-Marie Dautelle</a>
 * @author <a href="mailto:units@catmedia.us">Werner Keil</a>
 * @version 1.1
 *
 * @see <a href="http://en.wikipedia.org/wiki/Magnetomotive_force">Wikipedia: Magnetomotive Force</a>
 */
public interface MagnetomotiveForce extends Quantity<MagnetomotiveForce> {
}
