/*
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE ECLIPSE PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Eclipse Public License from
 * http://www.opensource.org/licenses/eclipse-1.0.php
 *
 * Author:       Roman Rakus <rrakus@redhat.com>
 * Contributors:
 *
 * Interface Type : Common Manageability Programming Interface ( CMPI )
 *
 * Description: Provider for the SBLIM Gatherer Metric Plugin
 *
 * Heavily inspired by OSBase_MetricServiceCapabilitiesProvider
 *
 */

#include "file_handler.h"
#include <cmpidt.h>
#include <cmpift.h>
#include <cmpimacs.h>

#include <stdio.h>
#include <errno.h>

const CMPIBroker * _broker;

static CMPIStatus Cleanup(CMPIInstanceMI * mi,
                          const CMPIContext * ctx,
                          CMPIBoolean terminating)
{
    CMReturn(CMPI_RC_OK);
}

static CMPIStatus EnumInstanceNames(CMPIInstanceMI * mi,
                                    const CMPIContext * ctx,
                                    const CMPIResult * rslt,
                                    const CMPIObjectPath * op)
{
    CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

static CMPIStatus EnumInstances(CMPIInstanceMI * mi,
                                const CMPIContext * ctx,
                                const CMPIResult * rslt,
                                const CMPIObjectPath * op,
                                const char **props)
{
    linked_list* ll = load_list(METRIC_PLUGIN);
    mp_list* ml = ll->value_list.metric_plugin;
    CMPIInstance* ci = NULL;
    const char* ns = CMGetCharPtr(CMGetNameSpace(op,NULL));
    CMPIObjectPath* co = NULL;
    CMPIValue val;
    while(ml)
    {
      co = CMNewObjectPath(_broker, ns, "Linux_MetricPlugin", NULL);
      ci = CMNewInstance(_broker, co, NULL);
      val.string = CMNewString(_broker, ml->metric_definition_class_name, NULL);
      CMSetProperty(ci, "MetricDefinitionClassName", &val, CMPI_string);
      val.string = CMNewString(_broker, ml->metric_plugin_name, NULL);
      CMSetProperty(ci, "MetricPluginName", &val, CMPI_string);
      CMReturnInstance(rslt, ci);
      ml = ml->next;
    }
    clear_list(ll);
    CMReturnDone(rslt);
    CMReturn(CMPI_RC_OK);
}

static CMPIStatus GetInstance(CMPIInstanceMI * mi,
                              const CMPIContext * ctx,
                              const CMPIResult * rslt,
                              const CMPIObjectPath * op,
                              const char **props)
{
    CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

static CMPIStatus CreateInstance(CMPIInstanceMI * mi,
                                 const CMPIContext * ctx,
                                 const CMPIResult * rslt,
                                 const CMPIObjectPath * op,
                                 const CMPIInstance * inst)
{
    linked_list* ll = load_list(METRIC_PLUGIN);
    add_metric_plugin(ll,
      CMGetCharsPtr(CMGetProperty(inst, "MetricDefinitionClassName",
        NULL).value.string, NULL),
      CMGetCharsPtr(CMGetProperty(inst, "MetricPluginName",
        NULL).value.string, NULL));
    save_list(ll);
    clear_list(ll);
    CMReturnObjectPath(rslt, op);
    CMReturn(CMPI_RC_OK);
}

static CMPIStatus ModifyInstance(CMPIInstanceMI * mi,
                                 const CMPIContext * ctx,
                                 const CMPIResult * rslt,
                                 const CMPIObjectPath * op,
                                 const CMPIInstance * inst,
                                 const char **props)
{
    CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

static CMPIStatus DeleteInstance(CMPIInstanceMI * mi,
                                 const CMPIContext * ctx,
                                 const CMPIResult * rslt,
                                 const CMPIObjectPath * op)
{
    CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

static CMPIStatus ExecQuery(CMPIInstanceMI * mi,
                            const CMPIContext * ctx,
                            const CMPIResult * rslt,
                            const CMPIObjectPath * op,
                            const char *query,
                            const char *lang)
{
    CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

CMInstanceMIStub(, OSBase_MetricPluginProvider, _broker, CMNoHook);

