#ifndef _VARFILE_H
#define _VARFILE_H

enum value_type { METRIC_PLUGIN, REPOSITORY_PLUGIN, METRIC_VALUE_DEFINITION };

typedef struct _mp_list
{
  struct _mp_list* next;
  char* metric_definition_class_name;
  char* metric_plugin_name;
} mp_list;

typedef struct _rp_list
{
  struct _rp_list* next;
  char* metric_definition_class_name;
  char* repository_plugin_name;
  char* cim_translation_plugin_name;
} rp_list;

typedef struct _mvd_list
{
  struct _mvd_list* next;
  char* metric_definition_class_name;
  char* metric_value_class_name;
} mvd_list;

typedef struct _linked_list
{
  enum value_type type;
  union
  {
    mp_list* metric_plugin;
    rp_list* repository_plugin;
    mvd_list* metric_value_definition;
  } value_list;
} linked_list;

int add_metric_plugin(
    linked_list*,
    char* metric_definition_class_name,
    char* metric_plugin_name);

int add_repository_plugin(
    linked_list*,
    char* metric_definition_class_name,
    char* repository_plugin_name,
    char* cim_translation_plugin_name);

int add_metric_value_definition(
    linked_list*,
    char* metric_definition_class_name,
    char* metric_value_class_name);

linked_list* load_list(enum value_type);
int save_list(linked_list*);
int clear_list(linked_list*);
#endif
