{% include target ~ "-header.spec.inc" ignore missing %}
# Generated by rust2rpm {{ generator_version }}
%bcond_without check
{% set only_main = False %}
{% if not include_main %}
%global debug_package %{nil}
{% elif not include_devel %}
  {% set only_main = True %}
%global __cargo_skip_build 0
{% endif %}

%global crate {{ md.name }}
{% if md.name != crate %}
%global real_crate {{ crate }}
{% endif %}

Name:           rust-%{crate}{{ pkg_suffix }}
Version:        {{ md.version }}
Release:        {{ pkg_release }}
{% if md.description is none %}
Summary:        # FIXME
{% else %}
Summary:        {{ md.summary }}
{% endif %}
{% if rust_group is defined %}
Group:          {{ rust_group }}
{% endif %}

# Upstream license specification: {{ md.license|default("(missing)") }}
License:        {{ license|default("# FIXME") }}
{% if license_comments is not none %}
{{ license_comments }}
{% endif %}
URL:            https://crates.io/crates/{{ crate }}
Source:         %{crates_source}
{% if patch_file is not none %}
{% if target == "opensuse" %}
# PATCH-FIX-OPENSUSE {{ patch_file }} -- Initial patched metadata
{% else %}
# Initial patched metadata
{% endif %}
Patch0:         {{ patch_file }}
{% endif %}

ExclusiveArch:  %{rust_arches}
{% if not only_main %}
%if %{__cargo_skip_build}
BuildArch:      noarch
%endif
{% endif %}

BuildRequires:  rust-packaging
{% if all_features %}
  {% set cargo_args = " -a" %}
{% endif %}
{% if not generate_buildrequires %}
  {% if not all_features %}
    {% set buildrequires = normalize_deps(md.requires("default", resolve=True))|sort %}
  {% else %}
    {% set buildrequires = normalize_deps(md.all_dependencies)|sort %}
  {% endif %}
  {% set testrequires = normalize_deps(md.dev_dependencies)|sort %}
  {% set has_buildrequires = (buildrequires + testrequires)|length > 0 %}
  {% if has_buildrequires and not only_main %}
%if ! %{__cargo_skip_build}
  {% endif %}
  {% for req in buildrequires %}
BuildRequires:  {{ req }}
  {% endfor %}
  {% if testrequires|length > 0 %}
%if %{with check}
    {% for req in testrequires %}
BuildRequires:  {{ req }}
    {% endfor %}
%endif
  {% endif %}
  {% for req in to_list(distconf.get("buildrequires"))|sort %}
BuildRequires:  {{ req }}
  {% endfor %}
  {% if has_buildrequires and not only_main %}
%endif
  {% endif %}
{% endif %}

%global _description %{expand:
{% if md.description is none %}
%{summary}.
{%- else %}
{{ md.description|wordwrap }}
{%- endif %}
}

%description %{_description}

{% if include_main %}
  {% if not only_main %}
%if ! %{__cargo_skip_build}
  {% endif %}
%package     -n %{crate}
Summary:        %{summary}
  {% if rust_group is defined %}
Group:          # FIXME
  {% endif %}
  {% for req in to_list(distconf.get("bin.requires"))|sort %}
Requires:       {{ req }}
  {% endfor %}

%description -n %{crate} %{_description}

%files       -n %{crate}
  {% if md.license_file is not none %}
%license {{ md.license_file }}
  {% endif %}
  {% if md.readme is not none %}
%doc {{ md.readme }}
  {% endif %}
  {% for bin in bins %}
%{_bindir}/{{ bin.name }}
  {% endfor %}
  {% if not only_main %}
%endif
  {% endif %}

{% endif -%}

{% if include_devel %}
  {% set features = md.dependencies.keys()|list %}
  {% do features.remove(None) %}
  {% do features.remove("default") %}
  {% set features = features|sort %}
  {% do features.insert(0, None) %}
  {% do features.insert(1, "default") %}
  {% for unwanted in to_list(distconf.get("unwanted-features")) %}
    {% do features.remove(unwanted) %}
  {% endfor %}
  {% for feature in features %}
    {% if feature is none %}
      {% set pkg = "   devel" %}
      {% set conf_prefix = "lib" %}
    {% else %}
      {% set pkg = "-n %%{name}+%s-devel"|format(feature) %}
      {% set conf_prefix = "lib+%s"|format(feature) %}
    {% endif %}
%package     {{ pkg }}
Summary:        %{summary}
    {% if rust_group is defined %}
Group:          {{ rust_group }}
    {% endif %}
BuildArch:      noarch
    {% if include_provides %}
Provides:       {{ md.provides(feature) }}
    {% endif %}
    {% if include_requires %}
Requires:       cargo
      {% for req in md.requires(feature)|map("string")|sort %}
Requires:       {{ req }}
      {% endfor %}
    {% endif %}
    {% for req in to_list(distconf.get("%s.requires"|format(conf_prefix)))|sort %}
Requires:       {{ req }}
    {% endfor %}

%description {{ pkg }} %{_description}

This package contains library source intended for building other packages
which use {% if feature is not none %}"{{ feature }}" feature of {% endif %}"%{crate}" crate.

%files       {{ pkg }}
    {% if feature is none %}
      {% if md.license_file is not none %}
%license {{ md.license_file }}
      {% endif %}
      {% if md.readme is not none %}
%doc {{ md.readme }}
      {% endif %}
%{cargo_registry}/%{crate}-%{version_no_tilde}/
    {% else %}
%ghost %{cargo_registry}/%{crate}-%{version_no_tilde}/Cargo.toml
    {% endif %}

  {% endfor %}
{% endif -%}

%prep
{% if md.name != crate %}
%autosetup -n %{real_crate}-%{version_no_tilde} -p1
{% else %}
%autosetup -n %{crate}-%{version_no_tilde} -p1
{% endif %}
%cargo_prep

{% if generate_buildrequires %}
%generate_buildrequires
%cargo_generate_buildrequires{{ cargo_args }}
  {% for req in to_list(distconf.get("buildrequires"))|sort %}
echo {{ "%r" | format(req) }}
  {% endfor %}

{% endif -%}

%build
%cargo_build{{ cargo_args }}

%install
%cargo_install{{ cargo_args }}

%if %{with check}
%check
%cargo_test{{ cargo_args }}
%endif

%changelog
{%- if auto_changelog_entry %}

  {% include target ~ "-changelog.spec.inc" %}
{% endif %}
