extern crate xz2;

use std::io::prelude::*;
use xz2::write::XzDecoder;

// This is a XZ file generated by head -c10 /dev/urandom | xz -c
const DATA: &'static [u8] =
    &[253, 55, 122, 88, 90, 0, 0, 4, 230, 214, 180, 70, 2, 0, 33, 1, 22, 0, 0, 0, 116, 47, 229,
      163, 1, 0, 9, 7, 122, 65, 14, 253, 214, 121, 128, 230, 115, 0, 0, 0, 158, 47, 174, 196, 175,
      10, 34, 254, 0, 1, 34, 10, 21, 26, 225, 103, 31, 182, 243, 125, 1, 0, 0, 0, 0, 4, 89, 90];


/// In this test, we drop a write::XzDecoder after supplying it a truncated input stream.
///
/// The decoder should detect that it is impossible to decode more data and not
/// go into an infinite loop waiting for more data.
#[test]
fn drop_writer_incomplete_input_no_loop() {
    let mut decoder = XzDecoder::new(Vec::new());
    const PREFIX_LEN: usize = 50;
    decoder.write_all(&DATA[..PREFIX_LEN]).unwrap();
}

/// Same as above, but verifying that we get an error if we manually call `finish`;
#[test]
fn finish_writer_incomplete_input_error() {
    let mut decoder = XzDecoder::new(Vec::new());
    const PREFIX_LEN: usize = 50;
    decoder.write_all(&DATA[..PREFIX_LEN]).unwrap();
    decoder.finish().err().expect("finish should error because of incomplete input");
}
