#![allow(unused_imports)]
use super::*;
use wasm_bindgen::prelude::*;
#[cfg(web_sys_unstable_apis)]
#[wasm_bindgen]
extern "C" {
    # [wasm_bindgen (extends = :: js_sys :: Object , js_name = XRView , typescript_type = "XRView")]
    #[derive(Debug, Clone, PartialEq, Eq)]
    #[doc = "The `XrView` class."]
    #[doc = ""]
    #[doc = "[MDN Documentation](https://developer.mozilla.org/en-US/docs/Web/API/XRView)"]
    #[doc = ""]
    #[doc = "*This API requires the following crate features to be activated: `XrView`*"]
    #[doc = ""]
    #[doc = "*This API is unstable and requires `--cfg=web_sys_unstable_apis` to be activated, as"]
    #[doc = "[described in the `wasm-bindgen` guide](https://rustwasm.github.io/docs/wasm-bindgen/web-sys/unstable-apis.html)*"]
    pub type XrView;
    #[cfg(web_sys_unstable_apis)]
    #[cfg(feature = "XrEye")]
    # [wasm_bindgen (structural , method , getter , js_class = "XRView" , js_name = eye)]
    #[doc = "Getter for the `eye` field of this object."]
    #[doc = ""]
    #[doc = "[MDN Documentation](https://developer.mozilla.org/en-US/docs/Web/API/XRView/eye)"]
    #[doc = ""]
    #[doc = "*This API requires the following crate features to be activated: `XrEye`, `XrView`*"]
    #[doc = ""]
    #[doc = "*This API is unstable and requires `--cfg=web_sys_unstable_apis` to be activated, as"]
    #[doc = "[described in the `wasm-bindgen` guide](https://rustwasm.github.io/docs/wasm-bindgen/web-sys/unstable-apis.html)*"]
    pub fn eye(this: &XrView) -> XrEye;
    #[cfg(web_sys_unstable_apis)]
    # [wasm_bindgen (structural , method , getter , js_class = "XRView" , js_name = projectionMatrix)]
    #[doc = "Getter for the `projectionMatrix` field of this object."]
    #[doc = ""]
    #[doc = "[MDN Documentation](https://developer.mozilla.org/en-US/docs/Web/API/XRView/projectionMatrix)"]
    #[doc = ""]
    #[doc = "*This API requires the following crate features to be activated: `XrView`*"]
    #[doc = ""]
    #[doc = "*This API is unstable and requires `--cfg=web_sys_unstable_apis` to be activated, as"]
    #[doc = "[described in the `wasm-bindgen` guide](https://rustwasm.github.io/docs/wasm-bindgen/web-sys/unstable-apis.html)*"]
    pub fn projection_matrix(this: &XrView) -> Vec<f32>;
    #[cfg(web_sys_unstable_apis)]
    #[cfg(feature = "XrRigidTransform")]
    # [wasm_bindgen (structural , method , getter , js_class = "XRView" , js_name = transform)]
    #[doc = "Getter for the `transform` field of this object."]
    #[doc = ""]
    #[doc = "[MDN Documentation](https://developer.mozilla.org/en-US/docs/Web/API/XRView/transform)"]
    #[doc = ""]
    #[doc = "*This API requires the following crate features to be activated: `XrRigidTransform`, `XrView`*"]
    #[doc = ""]
    #[doc = "*This API is unstable and requires `--cfg=web_sys_unstable_apis` to be activated, as"]
    #[doc = "[described in the `wasm-bindgen` guide](https://rustwasm.github.io/docs/wasm-bindgen/web-sys/unstable-apis.html)*"]
    pub fn transform(this: &XrView) -> XrRigidTransform;
}
