# -*- coding: euc-jp -*-
#
# menus widget demo (called by 'widget')
#

# toplevel widget ¸ߤк
if defined?($menu8x_demo) && $menu8x_demo
  $menu8x_demo.destroy
  $menu8x_demo = nil
end

# demo Ѥ toplevel widget 
$menu8x_demo = TkToplevel.new {|w|
  title("Menu Demonstration (Tk8.x)")
  iconname("menu")
  positionWindow(w)
}

base_frame = TkFrame.new($menu8x_demo).pack(:fill=>:both, :expand=>true)

# version check
if $tk_version.to_f < 8.0

# label 
TkLabel.new(base_frame,'font'=>$font,'wraplength'=>'4i','justify'=>'left') {
    text("¹Ԥ褦ȤץȤ Tk8.0 ʾѤǤ뵡ǽѤƤ뤿ᡢʤ Ruby#{VERSION}/Tk#{$tk_version}#{(Tk::JAPANIZED_TK)? 'jp': ''} Ǥ˼¹ԤǤޤ󡣤äƥǥμ¹ԤߤޤΥɻȥܥ򲡤Ȥǡ¹Ԥߤ줿ץȤΥ򻲾Ȥ뤳ȤϲǽǤ")
}.pack('side'=>'top')

# frame 
TkFrame.new(base_frame) {|frame|
  TkButton.new(frame) {
    #text 'λ'
    text 'Ĥ'
    command proc{
      tmppath = $menu8x_demo
      $menu8x_demo = nil
      tmppath.destroy
    }
  }.pack('side'=>'left', 'expand'=>'yes')

  TkButton.new(frame) {
    text 'ɻ'
    command proc{showCode 'menu8x'}
  }.pack('side'=>'left', 'expand'=>'yes')
}.pack('side'=>'bottom', 'fill'=>'x', 'pady'=>'2m')

else ; # Tk8.x

begin
  windowingsystem = Tk.windowingsystem()
rescue
  windowingsystem = ""
end

# label 
TkLabel.new(base_frame,'font'=>$font,'wraplength'=>'4i','justify'=>'left') {
  if $tk_platform['platform'] == 'macintosh' ||
      windowingsystem == "classic" || windowingsystem == "aqua"
    text("Υɥ͡ʥ˥塼ȥɥ˥塼鹽ƤޤCommand-X ϤȡXޥɥ³ɽƤʸʤС졼ȤäܵưԤȤǤޤ˥塼桢ǸΤΤϡΥ˥塼κǽιܤ򤹤뤳ȤΩ뤳ȤǤޤ")
  else
    text("Υɥ͡ʥ˥塼ȥɥ˥塼鹽ƤޤAlt-X ϤȡX˥塼˥饤դɽƤʸʤСܡɤλ꤬Ǥޤǥ˥塼ΥȥСǽǤ˥塼ꤵ줿ݤˤϡڡǼ¹Ԥ뤳ȤǤޤ뤤ϡ饤դʸϤ뤳ȤǤ¹ԤǤޤ˥塼Υȥ꤬졼äƤϡΥ졼Ϥ뤳Ȥǥ˥塼ꤹ뤳Ȥʤ˼¹Ԥ뤳ȤǤޤ˥塼桢ǸΤΤϡΥ˥塼κǽιܤ򤹤뤳ȤΩ뤳ȤǤޤ")
  end
}.pack('side'=>'top')

# ɽ
$menu8xstatus = TkVariable.new("    ")
TkFrame.new(base_frame) {|frame|
  TkLabel.new(frame, 'textvariable'=>$menu8xstatus, 'relief'=>'sunken',
              'bd'=>1, 'font'=>['Helvetica', '10'], 'anchor'=>'w')\
  .pack('side'=>'left', 'padx'=>2, 'expand'=>'yes', 'fill'=>'both')
}.pack('side'=>'bottom', 'fill'=>'x', 'pady'=>2)

# frame 
TkFrame.new(base_frame) {|frame|
  TkButton.new(frame) {
    #text 'λ'
    text 'Ĥ'
    command proc{
      tmppath = $menu8x_demo
      $menu8x_demo = nil
      tmppath.destroy
    }
  }.pack('side'=>'left', 'expand'=>'yes')

  TkButton.new(frame) {
    text 'ɻ'
    command proc{showCode 'menu8x'}
  }.pack('side'=>'left', 'expand'=>'yes')
}.pack('side'=>'bottom', 'fill'=>'x', 'pady'=>'2m')

# menu 
TkMenu.new($menu8x_demo, 'tearoff'=>false) {|m|
  TkMenu.new(m, 'tearoff'=>false) {|file_menu|
    m.add('cascade', 'label'=>'File', 'menu'=>file_menu, 'underline'=>0)
    add('command', 'label'=>' ...', 'command'=>proc{fail 'ϡǥǤΤ" ..."Ф륢Ƥޤ'})
    add('command', 'label'=>'', 'command'=>proc{fail 'ϡǥǤΤ""Ф륢Ƥޤ'})
    add('command', 'label'=>'¸', 'command'=>proc{fail 'ϡǥǤΤ"¸"Ф륢Ƥޤ'})
    add('command', 'label'=>'¸() ...', 'command'=>proc{fail 'ϡǥǤΤ"¸() ..."Ф륢Ƥޤ'})
    add('separator')
    add('command', 'label'=>'ץ ...', 'command'=>proc{fail 'ϡǥǤΤ"ץ ..."Ф륢Ƥޤ'})
    add('command', 'label'=>'ץ ...', 'command'=>proc{fail 'ϡǥǤΤ"ץ ..."Ф륢Ƥޤ'})
    add('separator')
    add('command', 'label'=>'λ', 'command'=>proc{$menu8x_demo.destroy})
  }

  if $tk_platform['platform'] == 'macintosh' ||
      windowingsystem == "classic" || windowingsystem == "aqua"
    modifier = 'Command'
  elsif $tk_platform['platform'] == 'windows'
    modifier = 'Control'
  else
    modifier = 'Meta'
  end

  TkMenu.new(m, 'tearoff'=>false) {|basic_menu|
    m.add('cascade', 'label'=>'Basic', 'menu'=>basic_menu, 'underline'=>0)
    add('command', 'label'=>'⤷ʤĹȥ')
    ['A','B','C','D','E','F','G'].each{|c|
      # add('command', 'label'=>"ʸ \"#{c}\" ", 'underline'=>4,
      add('command', 'label'=>"Print letter \"#{c}\" (ʸ \"#{c}\" )",
          'underline'=>14, 'accelerator'=>"Meta+#{c}",
          'command'=>proc{print c,"\n"}, 'accelerator'=>"#{modifier}+#{c}")
      $menu8x_demo.bind("#{modifier}-#{c.downcase}", proc{print c,"\n"})
    }
  }

  TkMenu.new(m, 'tearoff'=>false) {|cascade_menu|
    m.add('cascade', 'label'=>'Cascades', 'menu'=>cascade_menu, 'underline'=>0)
    add('command', 'label'=>'Print hello(ˤ)',
        'command'=>proc{print "Hello(ˤ)\n"},
        'accelerator'=>"#{modifier}+H", 'underline'=>6)
    $menu8x_demo.bind("#{modifier}-h", proc{print "Hello(ˤ)\n"})
    add('command', 'label'=>'Print goodbye(褦ʤ)',
        'command'=>proc{print "Goodbye(褦ʤ)\n"},
        'accelerator'=>"#{modifier}+G", 'underline'=>6)
    $menu8x_demo.bind("#{modifier}-g", proc{print "Goodbye(褦ʤ)\n"})

    TkMenu.new(m, 'tearoff'=>false) {|cascade_check|
      cascade_menu.add('cascade', 'label'=>'Check buttons(åܥ)',
                       'menu'=>cascade_check, 'underline'=>0)
      oil = TkVariable.new(0)
      add('check', 'label'=>'', 'variable'=>oil)
      trans = TkVariable.new(0)
      add('check', 'label'=>'ȥ󥹥ߥå', 'variable'=>trans)
      brakes = TkVariable.new(0)
      add('check', 'label'=>'֥졼', 'variable'=>brakes)
      lights = TkVariable.new(0)
      add('check', 'label'=>'饤', 'variable'=>lights)
      add('separator')
      add('command', 'label'=>'ߤͤɽ',
          'command'=>proc{showVars($menu8x_demo,
                                   ['', oil],
                                   ['ȥ󥹥ߥå', trans],
                                   ['֥졼', brakes],
                                   ['饤', lights])} )
      invoke 1
      invoke 3
    }

    TkMenu.new(m, 'tearoff'=>false) {|cascade_radio|
      cascade_menu.add('cascade', 'label'=>'Radio buttons(饸ܥ)',
                       'menu'=>cascade_radio, 'underline'=>0)
      pointSize = TkVariable.new
      add('radio', 'label'=>'10 ݥ', 'variable'=>pointSize, 'value'=>10)
      add('radio', 'label'=>'14 ݥ', 'variable'=>pointSize, 'value'=>14)
      add('radio', 'label'=>'18 ݥ', 'variable'=>pointSize, 'value'=>18)
      add('radio', 'label'=>'24 ݥ', 'variable'=>pointSize, 'value'=>24)
      add('radio', 'label'=>'32 ݥ', 'variable'=>pointSize, 'value'=>32)
      add('separator')
      style = TkVariable.new
      add('radio', 'label'=>'ޥ', 'variable'=>style, 'value'=>'roman')
      add('radio', 'label'=>'ܡ', 'variable'=>style, 'value'=>'bold')
      add('radio', 'label'=>'å', 'variable'=>style, 'value'=>'italic')
      add('separator')
      add('command', 'label'=>'ߤͤɽ',
          'command'=>proc{showVars($menu8x_demo,
                                   ['ݥȥ', pointSize],
                                   ['', style])} )
      invoke 1
      invoke 7
    }
  }

  TkMenu.new(m, 'tearoff'=>false) {|icon_menu|
    m.add('cascade', 'label'=>'Icons', 'menu'=>icon_menu, 'underline'=>0)
    add('command',
        'bitmap'=>'@'+[$demo_dir,'..',
                        'images','pattern.xbm'].join(File::Separator),
        'hidemargin'=>1,
        'command'=>proc{TkDialog.new('title'=>'Bitmap Menu Entry',
                                     'text'=>'ʤ򤷤˥塼ιܤϥƥȤǤϤʤӥåȥޥåפɽƤޤʳǤ¾Υ˥塼ܤѤޤ',
                                     'bitmap'=>'', 'default'=>0,
                                     'buttons'=>'λ')} )
    ['info', 'questhead', 'error'].each{|icon|
      add('command', 'bitmap'=>icon, 'hidemargin'=>1,
          'command'=>proc{print "You invoked the #{icon} bitmap\n"})
    }

    entryconfigure(2, 'columnbreak'=>1)
  }

  TkMenu.new(m, 'tearoff'=>false) {|more_menu|
    m.add('cascade', 'label'=>'More', 'menu'=>more_menu, 'underline'=>0)
    [ 'ȥ','̤Υȥ','⤷ʤ','ۤȤɲ⤷ʤ',
      'յΤ' ].each{|i|
      add('command', 'label'=>i,
          'command'=>proc{print "You invoked \"#{i}\"\n"})
    }
  }

  TkMenu.new(m) {|colors_menu|
    m.add('cascade', 'label'=>'Colors', 'menu'=>colors_menu, 'underline'=>1)
    ['red', 'orange', 'yellow', 'green', 'blue'].each{|c|
      add('command', 'label'=>c, 'background'=>c,
          'command'=>proc{print "You invoked \"#{c}\"\n"})
    }
  }

  $menu8x_demo.configure('menu'=>m)
}

TkMenu.bind('<MenuSelect>',
            proc{|w|
              begin
                label = w.entrycget('active', 'label')
              rescue
                label = '    '
              end
              $menu8xstatus.value = label
              Tk.update('idletasks')
            }, '%W')

end ; # Tk 8.x
