/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.demo;

import java.awt.Color;
import java.awt.Paint;
import javax.swing.JPanel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;

public class SWTMultipleAxisDemo1 {
    private static JFreeChart createChart() {
        XYDataset dataset1 = SWTMultipleAxisDemo1.createDataset("Series 1", 100.0, (RegularTimePeriod)new Minute(), 200);
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Multiple Axis Demo 3", (String)"Time of Day", (String)"Primary Range Axis", (XYDataset)dataset1, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)Color.BLACK);
        TextTitle subtitle = new TextTitle("Four datasets and four range axes.");
        chart.addSubtitle((Title)subtitle);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.getRangeAxis().setFixedDimension(15.0);
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.black);
        NumberAxis axis2 = new NumberAxis("Range Axis 2");
        axis2.setFixedDimension(10.0);
        axis2.setAutoRangeIncludesZero(false);
        axis2.setLabelPaint((Paint)Color.red);
        axis2.setTickLabelPaint((Paint)Color.red);
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        XYDataset dataset2 = SWTMultipleAxisDemo1.createDataset("Series 2", 1000.0, (RegularTimePeriod)new Minute(), 170);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        renderer2.setSeriesPaint(0, (Paint)Color.red);
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        NumberAxis axis3 = new NumberAxis("Range Axis 3");
        axis3.setLabelPaint((Paint)Color.blue);
        axis3.setTickLabelPaint((Paint)Color.blue);
        plot.setRangeAxis(2, (ValueAxis)axis3);
        XYDataset dataset3 = SWTMultipleAxisDemo1.createDataset("Series 3", 10000.0, (RegularTimePeriod)new Minute(), 170);
        plot.setDataset(2, dataset3);
        plot.mapDatasetToRangeAxis(2, 2);
        StandardXYItemRenderer renderer3 = new StandardXYItemRenderer();
        renderer3.setSeriesPaint(0, (Paint)Color.blue);
        plot.setRenderer(2, (XYItemRenderer)renderer3);
        NumberAxis axis4 = new NumberAxis("Range Axis 4");
        axis4.setLabelPaint((Paint)Color.green);
        axis4.setTickLabelPaint((Paint)Color.green);
        plot.setRangeAxis(3, (ValueAxis)axis4);
        XYDataset dataset4 = SWTMultipleAxisDemo1.createDataset("Series 4", 25.0, (RegularTimePeriod)new Minute(), 200);
        plot.setDataset(3, dataset4);
        plot.mapDatasetToRangeAxis(3, 3);
        StandardXYItemRenderer renderer4 = new StandardXYItemRenderer();
        renderer4.setSeriesPaint(0, (Paint)Color.green);
        plot.setRenderer(3, (XYItemRenderer)renderer4);
        return chart;
    }

    private static XYDataset createDataset(String name, double base, RegularTimePeriod start, int count) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        RegularTimePeriod period = start;
        double value = base;
        for (int i = 0; i < count; ++i) {
            series.add(period, value);
            period = period.next();
            value *= 1.0 + (Math.random() - 0.495) / 10.0;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public static JPanel createDemoPanel() {
        JFreeChart chart = SWTMultipleAxisDemo1.createChart();
        return new ChartPanel(chart);
    }

    public static void main(String[] args) {
        JFreeChart chart = SWTMultipleAxisDemo1.createChart();
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(600, 300);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Test for jfreechart running with SWT");
        ChartComposite frame = new ChartComposite((Composite)shell, 0, chart, true);
        frame.setDisplayToolTips(false);
        frame.setHorizontalAxisTrace(true);
        frame.setVerticalAxisTrace(true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

