/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.JFreeChart;

public class PDFChartTransferable
implements Transferable {
    final DataFlavor pdfFlavor = new DataFlavor("application/pdf", "PDF");
    private JFreeChart chart;
    private int width;
    private int height;

    public PDFChartTransferable(JFreeChart jFreeChart, int n, int n2) {
        this(jFreeChart, n, n2, true);
    }

    public PDFChartTransferable(JFreeChart jFreeChart, int n, int n2, boolean bl) {
        try {
            this.chart = (JFreeChart)jFreeChart.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.chart = jFreeChart;
        }
        this.width = n;
        this.height = n2;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.pdfFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.pdfFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.pdfFlavor.equals(dataFlavor)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PDFChartTransferable.writeChartAsPDF(byteArrayOutputStream, this.chart, this.width, this.height, (FontMapper)new DefaultFontMapper());
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static void writeChartAsPDF(ByteArrayOutputStream byteArrayOutputStream, JFreeChart jFreeChart, int n, int n2, FontMapper fontMapper) throws IOException {
        Rectangle rectangle = new Rectangle((float)n, (float)n2);
        Document document = new Document(rectangle, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            document.addAuthor("JFreeChart");
            document.addSubject("Demonstration");
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)n, (float)n2);
            Graphics2D graphics2D = pdfTemplate.createGraphics((float)n, (float)n2, fontMapper);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            jFreeChart.draw(graphics2D, double_);
            graphics2D.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        }
        catch (DocumentException documentException) {
            System.err.println(documentException.getMessage());
        }
        document.close();
    }
}

