/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Window;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class BarChartDemo11
extends ApplicationFrame {
    public BarChartDemo11(String string) {
        super(string);
        JPanel jPanel = BarChartDemo11.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(23192.0, (Comparable)((Object)"S1"), (Comparable)((Object)"GNU General Public Licence"));
        defaultCategoryDataset.addValue(3157.0, (Comparable)((Object)"S1"), (Comparable)((Object)"GNU Lesser General Public Licence"));
        defaultCategoryDataset.addValue(1506.0, (Comparable)((Object)"S1"), (Comparable)((Object)"BSD Licence (Original)"));
        defaultCategoryDataset.addValue(1283.0, (Comparable)((Object)"S1"), (Comparable)((Object)"BSD Licence (Revised)"));
        defaultCategoryDataset.addValue(738.0, (Comparable)((Object)"S1"), (Comparable)((Object)"MIT/X Consortium Licence"));
        defaultCategoryDataset.addValue(630.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Artistic Licence"));
        defaultCategoryDataset.addValue(585.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Public Domain"));
        defaultCategoryDataset.addValue(349.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Apache Licence 2.0"));
        defaultCategoryDataset.addValue(317.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Apache Licence"));
        defaultCategoryDataset.addValue(309.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Mozilla Public Licence"));
        defaultCategoryDataset.addValue(918.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Other"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Open Source Projects By Licence", "Licence", "Project Count", categoryDataset, PlotOrientation.HORIZONTAL, false, true, false);
        TextTitle textTitle = new TextTitle("Source: Freshmeat (http://www.freshmeat.net/)", new Font("Dialog", 0, 10));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        jFreeChart.addSubtitle(textTitle);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(0.8f);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator("{1}: {2} projects", new DecimalFormat("0"));
        barRenderer.setBaseToolTipGenerator(standardCategoryToolTipGenerator);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, new Color(0, 0, 64));
        barRenderer.setSeriesPaint(0, gradientPaint);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = BarChartDemo11.createChart(BarChartDemo11.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        BarChartDemo11 barChartDemo11 = new BarChartDemo11("JFreeChart: BarChartDemo11.java");
        barChartDemo11.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barChartDemo11));
        barChartDemo11.setVisible(true);
    }
}

