/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.util;

import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.util.Deadline;
import scala.concurrent.util.Deadline$;
import scala.concurrent.util.Duration;
import scala.concurrent.util.Duration$;
import scala.concurrent.util.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\tur!B\u0001\u0003\u0011\u0003I\u0011A\u0004$j]&$X\rR;sCRLwN\u001c\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\u000bG>t7-\u001e:sK:$(\"A\u0004\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\tqa)\u001b8ji\u0016$UO]1uS>t7cA\u0006\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\ta!\u0003\u0002\u001a\r\ta1+\u001a:jC2L'0\u00192mK\")1d\u0003C\u00019\u00051A(\u001b8jiz\"\u0012!C\u0004\u0006=-A\u0019aH\u0001\u0018\r&t\u0017\u000e^3EkJ\fG/[8o\u0013N|%\u000fZ3sK\u0012\u0004\"\u0001I\u0011\u000e\u0003-1QAI\u0006\t\u0002\r\u0012qCR5oSR,G)\u001e:bi&|g.S:Pe\u0012,'/\u001a3\u0014\u0007\u0005rA\u0005E\u0002&[Ar!AJ\u0016\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0005%B\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\tac!A\u0004qC\u000e\\\u0017mZ3\n\u00059z#\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u000512\u0001C\u0001\u00062\r\u0011a!A\u0001\u001a\u0014\u0005E\u001a\u0004C\u0001\u00065\u0013\t)$A\u0001\u0005EkJ\fG/[8o\u0011!9\u0014G!b\u0001\n\u0003A\u0014A\u00027f]\u001e$\b.F\u0001:!\t9\"(\u0003\u0002<\r\t!Aj\u001c8h\u0011!i\u0014G!A!\u0002\u0013I\u0014a\u00027f]\u001e$\b\u000e\t\u0005\t\u007fE\u0012)\u0019!C\u0001\u0001\u0006!QO\\5u+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%BA\u0003E\u0015\t\u0019!#\u0003\u0002G\u0007\nAA+[7f+:LG\u000f\u0003\u0005Ic\t\u0005\t\u0015!\u0003B\u0003\u0015)h.\u001b;!\u0011\u0015Y\u0012\u0007\"\u0001K)\r\u00014\n\u0014\u0005\u0006o%\u0003\r!\u000f\u0005\u0006\u007f%\u0003\r!\u0011\u0005\u0007\u001dF\u0002K\u0011B(\u0002\u000f\t|WO\u001c3fIR\u0011\u0001k\u0015\t\u0003/EK!A\u0015\u0004\u0003\u000f\t{w\u000e\\3b]\")A+\u0014a\u0001s\u0005\u0019Q.\u0019=\t\u000bY\u000bD\u0011\u0001\u001d\u0002\u000fQ|g*\u00198pg\")\u0001,\rC\u0001q\u0005AAo\\'jGJ|7\u000fC\u0003[c\u0011\u0005\u0001(\u0001\u0005u_6KG\u000e\\5t\u0011\u0015a\u0016\u0007\"\u00019\u0003%!xnU3d_:$7\u000fC\u0003_c\u0011\u0005\u0001(A\u0005u_6Kg.\u001e;fg\")\u0001-\rC\u0001q\u00059Ao\u001c%pkJ\u001c\b\"\u000222\t\u0003A\u0014A\u0002;p\t\u0006L8\u000fC\u0003ec\u0011\u0005Q-\u0001\u0004u_Vs\u0017\u000e\u001e\u000b\u0003M&\u0004\"aF4\n\u0005!4!A\u0002#pk\ndW\rC\u0003kG\u0002\u0007\u0011)A\u0001v\u0011\u0015a\u0017\u0007\"\u0001n\u0003\u001d1'o\\7O_^,\u0012A\u001c\t\u0003\u0015=L!\u0001\u001d\u0002\u0003\u0011\u0011+\u0017\r\u001a7j]\u0016DaA]\u0019!\n\u0013\u0019\u0018AC;oSR\u001cFO]5oOV\tA\u000f\u0005\u0002\u0010k&\u0011a\u000f\u0005\u0002\u0007'R\u0014\u0018N\\4\t\u000ba\fD\u0011I=\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u001e\u0005\u0006wF\"\t\u0001`\u0001\bG>l\u0007/\u0019:f)\ri\u0018\u0011\u0001\t\u0003/yL!a \u0004\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0004i\u0004\raM\u0001\u0006_RDWM\u001d\u0005\t\u0003\u000f\t\u0004\u0015\"\u0003\u0002\n\u000591/\u00194f\u0003\u0012$G#B\u001d\u0002\f\u0005=\u0001bBA\u0007\u0003\u000b\u0001\r!O\u0001\u0002C\"9\u0011\u0011CA\u0003\u0001\u0004I\u0014!\u00012\t\u0011\u0005U\u0011\u0007)C\u0005\u0003/\t1!\u00193e)\u0015\u0001\u0014\u0011DA\u000f\u0011\u001d\tY\"a\u0005A\u0002e\n1b\u001c;iKJdUM\\4uQ\"9\u0011qDA\n\u0001\u0004\t\u0015!C8uQ\u0016\u0014XK\\5u\u0011\u001d\t\u0019#\rC\u0001\u0003K\tQ\u0001\n9mkN$2aMA\u0014\u0011\u001d\t\u0019!!\tA\u0002MBq!a\u000b2\t\u0003\ti#\u0001\u0004%[&tWo\u001d\u000b\u0004g\u0005=\u0002bBA\u0002\u0003S\u0001\ra\r\u0005\b\u0003g\tD\u0011AA\u001b\u0003\u0019!C/[7fgR\u00191'a\u000e\t\u000f\u0005e\u0012\u0011\u0007a\u0001M\u00061a-Y2u_JDq!!\u00102\t\u0003\ty$\u0001\u0003%I&4HcA\u001a\u0002B!9\u0011\u0011HA\u001e\u0001\u00041\u0007\u0002CA#c\u0001&I!a\u0012\u0002\u00135Lg.^:[KJ|W#\u00014\t\u000f\u0005u\u0012\u0007\"\u0001\u0002LQ\u0019a-!\u0014\t\u000f\u0005\r\u0011\u0011\na\u0001g!9\u00111E\u0019\u0005\u0002\u0005ECc\u0001\u0019\u0002T!9\u00111AA(\u0001\u0004\u0001\u0004bBA\u0016c\u0011\u0005\u0011q\u000b\u000b\u0004a\u0005e\u0003bBA\u0002\u0003+\u0002\r\u0001\r\u0005\b\u0003;\nD\u0011AA0\u0003\u0011\u0001H.^:\u0015\u0007A\n\t\u0007C\u0004\u0002\u0004\u0005m\u0003\u0019\u0001\u0019\t\u000f\u0005\u0015\u0014\u0007\"\u0001\u0002h\u0005)Q.\u001b8vgR\u0019\u0001'!\u001b\t\u000f\u0005\r\u00111\ra\u0001a!9\u0011QN\u0019\u0005B\u0005=\u0014a\u00013jmR\u00191'!\u001d\t\u000f\u0005e\u00121\u000ea\u0001M\"9\u0011QO\u0019\u0005B\u0005]\u0014aA7vYR\u00191'!\u001f\t\u000f\u0005e\u00121\u000fa\u0001M\"9\u0011QP\u0019\u0005\u0002\u0005}\u0014aA7j]R\u0019\u0001'!!\t\u000f\u0005\r\u00111\u0010a\u0001a!1A+\rC\u0001\u0003\u000b#2\u0001MAD\u0011\u001d\t\u0019!a!A\u0002ABq!a#2\t\u0003\ti)\u0001\u0007v]\u0006\u0014\u0018p\u0018\u0013nS:,8/F\u00011\u0011\u001d\t\t*\rC\u0003\u0003'\u000b\u0001\"[:GS:LG/\u001a\u000b\u0002!\"9\u0011qS\u0019\u0005B\u0005e\u0015AB3rk\u0006d7\u000fF\u0002Q\u00037C\u0001\"a\u0001\u0002\u0016\u0002\u0007\u0011Q\u0014\t\u0004/\u0005}\u0015bAAQ\r\t\u0019\u0011I\\=\t\u000f\u0005\u0015\u0016\u0007\"\u0011\u0002(\u0006A\u0001.Y:i\u0007>$W\rF\u0001~\u0011\u0019Y\u0012\u0005\"\u0001\u0002,R\tq\u0004\u0003\u0004|C\u0011\u0005\u0011q\u0016\u000b\u0006{\u0006E\u00161\u0017\u0005\b\u0003\u001b\ti\u000b1\u00011\u0011\u001d\t\t\"!,A\u0002AB\u0011\"a.\"\u0003\u0003%I!!/\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002\u001d!9\u0011QX\u0006\u0005\u0002\u0005}\u0016!B1qa2LH#\u0002\u0019\u0002B\u0006\r\u0007BB\u001c\u0002<\u0002\u0007\u0011\b\u0003\u0004@\u0003w\u0003\r!\u0011\u0005\b\u0003{[A\u0011AAd)\u0015\u0001\u0014\u0011ZAf\u0011\u00199\u0014Q\u0019a\u0001s!9q(!2A\u0002\u00055\u0007\u0003BAh\u0003+t1aFAi\u0013\r\t\u0019NB\u0001\u0007!J,G-\u001a4\n\u0007Y\f9NC\u0002\u0002T\u001aA\u0011\"a7\f\u0005\u0004%i!!8\u0002\r5\f\u0007p\u00188t+\t\tyn\u0004\u0002\u0002bzAqp\u0000\u0000\u0000\u0000\u0000\u0000\u0000 \u0003\u0005\u0002f.\u0001\u000bQBAp\u0003\u001di\u0017\r_0og\u0002B\u0011\"!;\f\u0005\u0004%i!a;\u0002\u000f5\f\u0007p\u0018b6hV\u0011\u0011Q^\b\u0003\u0003_tr\u0001\tc\u001cL\u000f v\u001f\u0003\u0005\u0002t.\u0001\u000bQBAw\u0003!i\u0017\r_0ClO\u0004\u0003\"CA|\u0017\t\u0007IQBA}\u0003\u0019i\u0017\r_0ngV\u0011\u00111`\b\u0003\u0003{tb\u0001C2|!l3\u0010\u0002\u0003B\u0001\u0017\u0001\u0006i!a?\u0002\u000f5\f\u0007pX7tA!I!QA\u0006C\u0002\u00135!qA\u0001\u0006[\u0006Dxl]\u000b\u0003\u0005\u0013y!Aa\u0003\u001f\u000b\t)\u00139 \u0003\t\u0011\t=1\u0002)A\u0007\u0005\u0013\ta!\\1y?N\u0004\u0003\"\u0003B\n\u0017\t\u0007IQ\u0002B\u000b\u0003\u001di\u0017\r_0nS:,\"Aa\u0006\u0010\u0005\tea\u0004B\u0005*?OH\u0001B!\b\fA\u00035!qC\u0001\t[\u0006Dx,\\5oA!I!\u0011E\u0006C\u0002\u00135!1E\u0001\u0006[\u0006Dx\f[\u000b\u0003\u0005Ky!Aa\n\u001f\u0007\u001d:r \u0003\u0005\u0003,-\u0001\u000bQ\u0002B\u0013\u0003\u0019i\u0017\r_0iA!I!qF\u0006C\u0002\u00135!\u0011G\u0001\u0006[\u0006Dx\fZ\u000b\u0003\u0005gy!A!\u000e\u001f\u0007\u0005\u0001{ \u0003\u0005\u0003:-\u0001\u000bQ\u0002B\u001a\u0003\u0019i\u0017\r_0eA!I\u0011qW\u0006\u0002\u0002\u0013%\u0011\u0011\u0018")
public final class FiniteDuration
extends Duration {
    private final long length;
    private final TimeUnit unit;

    public static FiniteDuration apply(long l, String string2) {
        return FiniteDuration$.MODULE$.apply(l, string2);
    }

    public static FiniteDuration apply(long l, TimeUnit timeUnit) {
        return FiniteDuration$.MODULE$.apply(l, timeUnit);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public TimeUnit unit() {
        return this.unit;
    }

    private boolean bounded(long max2) {
        return -max2 <= this.length() && this.length() <= max2;
    }

    @Override
    public long toNanos() {
        return this.unit().toNanos(this.length());
    }

    @Override
    public long toMicros() {
        return this.unit().toMicros(this.length());
    }

    @Override
    public long toMillis() {
        return this.unit().toMillis(this.length());
    }

    @Override
    public long toSeconds() {
        return this.unit().toSeconds(this.length());
    }

    @Override
    public long toMinutes() {
        return this.unit().toMinutes(this.length());
    }

    @Override
    public long toHours() {
        return this.unit().toHours(this.length());
    }

    @Override
    public long toDays() {
        return this.unit().toDays(this.length());
    }

    @Override
    public double toUnit(TimeUnit u) {
        return (double)this.toNanos() / (double)TimeUnit.NANOSECONDS.convert(1L, u);
    }

    public Deadline fromNow() {
        return Deadline$.MODULE$.now().$plus(this);
    }

    private String unitString() {
        return new StringBuilder().append((Object)((String)Duration$.MODULE$.timeUnitName().apply(this.unit()))).append((Object)(this.length() == 1L ? "" : "s")).toString();
    }

    public String toString() {
        return new StringBuilder().append((Object)"").append(BoxesRunTime.boxToLong(this.length())).append((Object)" ").append((Object)this.unitString()).toString();
    }

    @Override
    public int compare(Duration other) {
        int n;
        Duration duration = other;
        if (duration instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)duration;
            n = new RichLong(Predef$.MODULE$.longWrapper(this.toNanos())).compare(BoxesRunTime.boxToLong(x2.toNanos()));
        } else {
            n = -other.compare(this);
        }
        return n;
    }

    private long safeAdd(long a, long b) {
        if (b > 0L && a > Long.MAX_VALUE - b || b < 0L && a < Long.MIN_VALUE - b) {
            throw new IllegalArgumentException("integer overflow");
        }
        return a + b;
    }

    private FiniteDuration add(long otherLength, TimeUnit otherUnit) {
        TimeUnit commonUnit = otherUnit.convert(1L, this.unit()) == 0L ? this.unit() : otherUnit;
        long totalLength = this.safeAdd(commonUnit.convert(this.length(), this.unit()), commonUnit.convert(otherLength, otherUnit));
        return new FiniteDuration(totalLength, commonUnit);
    }

    @Override
    public Duration $plus(Duration other) {
        Duration duration;
        Duration duration2 = other;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)duration2;
            duration = this.add(x2.length(), x2.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    @Override
    public Duration $minus(Duration other) {
        Duration duration;
        Duration duration2 = other;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)duration2;
            duration = this.add(-x2.length(), x2.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    @Override
    public Duration $times(double factor) {
        return Predef$.MODULE$.double2Double(factor).isInfinite() ? (Predef$.MODULE$.double2Double(factor).isNaN() ? Duration$.MODULE$.Undefined() : (factor > 0.0 ^ this.$less(Duration$.MODULE$.Zero()) ? Duration$.MODULE$.Inf() : Duration$.MODULE$.MinusInf())) : Duration$.MODULE$.fromNanos((double)this.toNanos() * factor);
    }

    @Override
    public Duration $div(double factor) {
        return Predef$.MODULE$.double2Double(factor).isInfinite() ? (Predef$.MODULE$.double2Double(factor).isNaN() ? Duration$.MODULE$.Undefined() : Duration$.MODULE$.Zero()) : Duration$.MODULE$.fromNanos((double)this.toNanos() / factor);
    }

    private double minusZero() {
        return -0.0;
    }

    @Override
    public double $div(Duration other) {
        return other.isFinite() ? (double)this.toNanos() / (double)other.toNanos() : (other == Duration$.MODULE$.Undefined() ? Double.NaN : (this.length() < 0L ^ other.$greater(Duration$.MODULE$.Zero()) ? 0.0 : this.minusZero()));
    }

    public FiniteDuration $plus(FiniteDuration other) {
        return this.add(other.length(), other.unit());
    }

    public FiniteDuration $minus(FiniteDuration other) {
        return this.add(-other.length(), other.unit());
    }

    public FiniteDuration plus(FiniteDuration other) {
        return this.$plus(other);
    }

    public FiniteDuration minus(FiniteDuration other) {
        return this.$minus(other);
    }

    @Override
    public Duration div(double factor) {
        return this.$div(factor);
    }

    @Override
    public Duration mul(double factor) {
        return this.$times(factor);
    }

    public FiniteDuration min(FiniteDuration other) {
        return this.$less(other) ? this : other;
    }

    public FiniteDuration max(FiniteDuration other) {
        return this.$greater(other) ? this : other;
    }

    @Override
    public FiniteDuration unary_$minus() {
        return Duration$.MODULE$.apply(-this.length(), this.unit());
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)object;
            bl = this.toNanos() == x2.toNanos();
        } else {
            bl = super.equals(other);
        }
        return bl;
    }

    public int hashCode() {
        return (int)this.toNanos();
    }

    public FiniteDuration(long length, TimeUnit unit) {
        boolean bl;
        this.length = length;
        this.unit = unit;
        TimeUnit timeUnit = unit;
        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            TimeUnit x2 = timeUnit;
            bl = this.bounded(Long.MAX_VALUE);
        } else {
            TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
            TimeUnit timeUnit5 = timeUnit;
            if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
                TimeUnit x3 = timeUnit;
                bl = this.bounded(9223372036854775L);
            } else {
                TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
                TimeUnit timeUnit7 = timeUnit;
                if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
                    TimeUnit x4 = timeUnit;
                    bl = this.bounded(9223372036854L);
                } else {
                    TimeUnit timeUnit8 = TimeUnit.SECONDS;
                    TimeUnit timeUnit9 = timeUnit;
                    if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
                        TimeUnit x5 = timeUnit;
                        bl = this.bounded(9223372036L);
                    } else {
                        TimeUnit timeUnit10 = TimeUnit.MINUTES;
                        TimeUnit timeUnit11 = timeUnit;
                        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
                            TimeUnit x6 = timeUnit;
                            bl = this.bounded(153722867L);
                        } else {
                            TimeUnit timeUnit12 = TimeUnit.HOURS;
                            TimeUnit timeUnit13 = timeUnit;
                            if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
                                TimeUnit x7 = timeUnit;
                                bl = this.bounded(2562047L);
                            } else {
                                TimeUnit timeUnit14 = TimeUnit.DAYS;
                                TimeUnit timeUnit15 = timeUnit;
                                if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
                                    TimeUnit x8 = timeUnit;
                                    bl = this.bounded(106751L);
                                } else {
                                    long v = TimeUnit.DAYS.convert(length, unit);
                                    bl = -106751L <= v && v <= 106751L;
                                }
                            }
                        }
                    }
                }
            }
        }
        Predef$.MODULE$.require(bl, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Duration is limited to +-(2^63-1)ns (ca. 292 years)";
            }
        }));
    }
}

