import sbt._
import Keys._

object ScalaBuildKeys {
  val lockerLock        = TaskKey[Unit]("locker-lock", "Locks the locker layer of the compiler build such that it won't rebuild on changed source files.")
  val lockerUnlock      = TaskKey[Unit]("locker-unlock", "Unlocks the locker layer of the compiler so that it will be recompiled on changed source files.")
  val lockFile          = SettingKey[File]("lock-file", "Location of the lock file compiling this project.")
  val lock              = TaskKey[Unit]("lock", "Locks this project so it won't be recompiled.")
  val unlock            = TaskKey[Unit]("unlock", "Unlocks this project so it will be recompiled.")
  val makeDist          = TaskKey[File]("make-dist",  "Creates a mini-distribution (scala home directory) for this build in a zip file.")
  val makeExplodedDist  = TaskKey[File]("make-exploded-dist", "Creates a mini-distribution (scala home directory) for this build in a directory.")
  val makeDistMappings  = TaskKey[Seq[(File, String)]]("make-dist-mappings", "Creates distribution mappings for creating zips,jars,directorys,etc.")
  val buildFixed        = AttributeKey[Boolean]("build-uri-fixed")
  val genBinRunner      = TaskKey[ScalaToolRunner]("gen-bin-runner", "Creates a utility to generate script files for Scala.")  
  val genBin            = TaskKey[Seq[(File,String)]]("gen-bin", "Creates script files for Scala distribution.")
  val binDir            = SettingKey[File]("binaries-directory", "Directory where binary scripts will be located.")
  val genBinQuick       = TaskKey[Seq[(File,String)]]("gen-quick-bin", "Creates script files for testing against current Scala build classfiles (not local dist).")
  val runManmakerMan    = TaskKey[Seq[(File,String)]]("make-man", "Runs the man maker project to generate man pages")
  val runManmakerHtml   = TaskKey[Seq[(File,String)]]("make-html", "Runs the man maker project to generate html pages")
  val checkSame         = TaskKey[Unit]("check-same-binaries", "checks whether or not the class files generated by scala are the same.")
  val checkSameLibrary  = TaskKey[Unit]("check-same-lib-binaries", "checks whether or not the librayr class files generated by scala are the same.")
  val checkSameCompiler = TaskKey[Unit]("check-same-comp-binaries", "checks whether or not the compiler class files generated by scala are the same.")
}
