#!perl
# This file was automatically generated by Dist::Zilla::Plugin::Test::Pod::Coverage::Configurable.

use Test::Pod::Coverage 1.08;
use Test::More 0.88;

BEGIN {
    if ( $] <= 5.008008 ) {
        plan skip_all => 'These tests require Pod::Coverage::TrustPod, which only works with Perl 5.8.9+';
    }
}
use Pod::Coverage::TrustPod;

my %skip = map { $_ => 1 } qw( DateTime::TimeZone::Catalog DateTime::TimeZone::Floating DateTime::TimeZone::OffsetOnly DateTime::TimeZone::UTC );

my @modules;
for my $module ( all_modules() ) {
    next if $skip{$module};
    next if $module =~ qr/^DateTime::TimeZone::OlsonDB/;
    next if $module =~ qr/^DateTime::TimeZone::Local::.+/;
    next if $module =~ qr/^DateTime::TimeZone::(?:Africa|America|Antarctica|Asia|Atlantic|Australia|Europe|Indian|Pacific)/;
    next if $module =~ qr/^DateTime::TimeZone::(?:CET|CST6CDT|EET|EST5EDT|EST|HST|MET|MST7MDT|MST|PST8PDT|WET)/;

    push @modules, $module;
}

plan skip_all => 'All the modules we found were excluded from POD coverage test.'
    unless @modules;

plan tests => scalar @modules;

my %trustme = (
             'DateTime::TimeZone' => [
                                     qr/^STORABLE_/,
                                     qr/^max_span$/
                                   ]
           );

my @also_private;

for my $module ( sort @modules ) {
    pod_coverage_ok(
        $module,
        {
            coverage_class => 'Pod::Coverage::TrustPod',
            also_private   => \@also_private,
            trustme        => $trustme{$module} || [],
        },
        "pod coverage for $module"
    );
}

done_testing();
