// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

'use strict';
const common = require('../common');
const http = require('http');
const Countdown = require('../common/countdown');

const N = 8;

const countdown = new Countdown(N, common.mustCall(() => server.close()));

const server = http.Server(common.mustCall((req, res) => {
  res.writeHead(200);
  res.write('Working on it...');
  req.on('aborted', common.mustCall(() => countdown.dec()));
}, N));

server.listen(0, common.mustCall(() => {

  const requests = [];
  const reqCountdown = new Countdown(N, common.mustCall(() => {
    requests.forEach((req) => req.abort());
  }));

  const options = { port: server.address().port };

  for (let i = 0; i < N; i++) {
    options.path = `/?id=${i}`;
    requests.push(
      http.get(options, common.mustCall((res) => {
        res.resume();
        reqCountdown.dec();
      })));
  }
}));
