# Node Foundation CTC Meeting 2016-01-06

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2016-01-06
* **GitHub Issue**: https://github.com/nodejs/node/issues/4553
* **Minutes Google Doc**: <https://docs.google.com/document/d/1LyECbnYZcxPoBal9JA8quGEvie1Rj_ofKn4CVMni9eY>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1084kuafyFax-1dymqvMlVUPvu3apdzw0ZM_4FX3z1RM>_

## Present

* James Snell (CTC)
* Trevor Norris (CTC)
* Colin Ihrig (CTC)
* Brian White (CTC)
* Michael Dawson (observer)
* Alexis Campailla (CTC)
* Bert Belder (CTC)
* Chris Dickinson (CTC)
* Shigeki Ohtsu (CTC)
* Steven Loomis (observer)
* Mikeal Rogers (observer)
* Jeremiah Senkpiel (CTC)
* Rod Vagg (CTC)
* Ben Noordhuis (CTC)

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* Nominating new Release team members [#4319](https://github.com/nodejs/node/issues/4319)
* repl: Reverses order of .node_repl_history [#4313](https://github.com/nodejs/node/pull/4313)
* doc: add Docs working group [#4244](https://github.com/nodejs/node/pull/4244)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Potential Licensing issues with npm [#3959](https://github.com/nodejs/node/issues/3959)
* Joyent Copyright still in header of many files [#3926](https://github.com/nodejs/node/issues/3926)
* gripe: deprecating fs.exists/existsSync [#1592](https://github.com/nodejs/node/issues/1592)


## Standup

* James Snell (CTC): Docs work, refactoring some docs, about halfway through currently. Working on landing some PRs, 4.2.4 release came out before xmas, 4.2.5 next week with Myles
* Trevor Norris (CTC): Working with Fedor to make callbacks reentrant.
* Colin Ihrig (CTC): Opened a PR for the releases doc page, reviewing issues and PRs, working on a PR to libuv
* Brian White (CTC): JS DNS resolver PR updated against master, perf compared to existing impl isn’t very good (yet?), other than that: fixed some flaky tests
* Michael Dawson (observer):Benchmarking infrastructure to generate charts, meeting this week to discuss proposed approach.  Chasing down last dependency updates for AIX, adding zLinux machine.
* Alexis Campailla (CTC): Prototyping module building service
* Bert Belder (CTC): Nothing interesting
* Chris Dickinson (CTC): Poking at AsyncWrap
* Shigeki Ohtsu (CTC): Reviewing james doc improvements and small fix for tool.
* Steven Loomis (observer): Some issue review.
* Mikeal Rogers (observer): Foundation strategy for 2016, legal stuff; individual member elections are coming up.
* Jeremiah Senkpiel (CTC): Working on the v5.4.0 release at the time of the meeting. Nothing else interesting. (vacation!)
* Rod Vagg (CTC): Download metrics, analyzing that; put out infographics regarding DL numbers, end of year v4 became the most popular downloaded version, taking over from v0.10, which had been very persistent in its popularity. v5 took over 2nd place from v0.12. Reworking readme in the build repo to mention infra providers.
* Ben Noordhuis (CTC): Gloriously nothing.

## Review of last meeting

* Discussion: OpenSSL 1.1.0 planning [#4270](https://github.com/nodejs/node/issues/4270)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Potential Licensing issues with npm [#3959](https://github.com/nodejs/node/issues/3959)
* Joyent Copyright still in header of many files [#3926](https://github.com/nodejs/node/issues/3926)
* AsyncWrap for LTS Argon [#59](https://github.com/nodejs/LTS/issues/59)
* Discuss possibility of adjusting LTS schedule for better alignment with V8 schedule [#62](https://github.com/nodejs/LTS/issues/62)

## Minutes

### Nominating new Release team members [#4319](https://github.com/nodejs/node/issues/4319)

Rod: Ratification is desired here?
James: Any objections to adding Myles and Evan to the release team?

`[crickets]`

James: No objections. Who wants to take the lead on adding them?
Jeremiah: I can do that.

* repl: Reverses order of .node_repl_history [#4313](https://github.com/nodejs/node/pull/4313)

_Discussion in minutes doc prior to meeting discussion:_
> CD: I won’t be able to note this one, so someone should take over for this issue.
> RV: CD - do you have an opinion to offer here?
> CD — yep! mostly: it’s a breaking change that doesn’t seem to be worth breaking things for.
> RV: thanks!

Rod: do we want to

Ben: seems like a pointless change, not very compelling, -1

Trevor: how’s it going to work when jumping between versions? my history will be all over the place.

James: haven’t review, is this fixing an actual bug?

Jeremiah: no, it’s just changing the order that it’s saved.

Ben: anyone on the call in favour of making the change?

James: Unless new information is presented, we’re leaning towards not accepting the change.

### doc: add Docs working group [#4244](https://github.com/nodejs/node/pull/4244)

Chris: last month, @bengl opened a PR to add the doc working group, lots of conversation has been had. Tried to pull out docs from core, came against some difficulties with finding a space to work on them and commiting them back, also wanted to have a better editorial review process so made a new repo and this also has problems because the website repo hosts some docs so docs are spanned across multiple issues.

Ben: what’s the problem with following the contributing rules/guidelines on the node repo?

Chris: mainly about relaxing the requirements for commit-bit, having documentation authors able to land PRs, and only docs PRs.

Mikeal: there are several doc writers who have commit-bits, we’re talking about trying to do the clean-up prior to landing on the node repo by doing it in the docs repo first. Is there still a problem with needing commit-bit for docs people? A lot of them are collaborators already.

Chris: I think we’re fine

James: current process has been working well enough, this is just about giving the WG responsibility for the docs directory in the main repo

Mikeal: sounds like the WG wants to be a holistic group working on docs across the project, not just the docs dir in the node repo?

Chris: yes

Mikeal: one problem I have with chartering the group at this stage then is: is the membership representative of all of these efforts?

Chris: is the parallel effort you’re talking about in the website group?

Mikeal: yes, and the website group is the most liberal about adding contributors so it’s not very organized

Chris: last touch-point with the website WG was at the collab summit and they are aware of the docs WF

Mikeal: in-person meeting not very representative of actual activity, prefer to look at who is actually contributing and pull them into the effort

Chris: cool, will circle back and look at the two repos and pull in more individuals, concern is about doing lots of work without any guarantee of getting ratified

Mikeal: we can’t give any guarantees without seeing things

Chris: big amounts of work re pulling out docs into topic-tocs and tutorials

Mikeal: but that’s already going on in the website repo, there’s tutorials that are being iterated on so why can’t we just continue that?

Chris: core docs and tutorials etc. should live in the same place

Mikeal: still not sure why this single issue is a blocker and how being ratified changes anything

.. discussion ..

Mikeal: if you wanted all of the tutorials etc. to live in core then that could just be a PR, if you want the tutorials to be moved out of the website then you’d need to be chartered and have this accepted by the website group

Chris: problem with building momentum is that the scope of responsibility lives between two groups

Mikeal: but there’s a ton of momentum going on in the two main places already, moving everything into a separate repo is a separate issue.

James: need to move on, propose that we continue the conversation there

Trevor: is there a dot-point list of what this list wants to achieve?

Chris to update with a link to what this is

Bert: sounds like this is not about whether this WG should exist but there is a technical blocker that we should focus on.

James: moving discussion to github, will come back if necessary

### Legal update

* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Potential Licensing issues with npm [#3959](https://github.com/nodejs/node/issues/3959)
* Joyent Copyright still in header of many files [#3926](https://github.com/nodejs/node/issues/3926)

Rod: Legal committee had a meeting this week, didn’t quite get through all of it. Not resolved yet but looking like a recommendation to put a simplified license block at the top of each source file. Those were removed in io.js but DCO process discusses license in each source file. Copyright is still Joyent and that was not assigned when things were moved so we need to resolve that.

(James: Note: we should add that to linting)

Mikeal: Leaving Joyent in the copyright doesn’t assign new rights but may need to seek their permission to remove. Nor do we need Joyent to assign copyright.

Rod: npm license issue still being looked at. The way npm licensing is being handled is still being worked out.

Mikeal: May be moving towards SPDX approach.

Ben: Question about Joyent boilerplate… is it possible that copyright actually belongs to other entity?

Mikeal: The copyright is owned by the contributors and Joyent. Going forward, copyright is owned by the contributors. We won’t be assigning copyright to the foundation.

James: I’ll *possibly* take the todo to get those updated

Bert: What about binary files?

Mikeal: It’s unclear.

James: Can we change the DCO language?

Mikeal: Modifying the DCO is an expensive process. Recommendation is to wait until the current stuff is resolved.

### gripe: deprecating fs.exists/existsSync [#1592](https://github.com/nodejs/node/issues/1592)

Bert: is the “deprecation” language useful here?

Trevor: this was discussed

Bert: “deprecation” is not really working

Jeremiah: there has been some work here

Bert: I’m against any form of deprecation from now on.

James: Let’s keep `deprecate` to mean that the thing is strongly discouraged, let’s come up with a stronger term that means this thing will definitely be going away.

Jeremiah: not sure if this discussion is relevant to the actual conversation. existSync is not something we want to keep because it’s different from everything else. Switch to accessibleSync?

Trevor: (explains the issues with access and exists on windows vs linux)

(more back and forth technical discussion about the nuances of determining if a file actually exists and is accessible)

(James: Let’s have a function that simply returns ‘\_(ツ)_/’ on Windows in response to `accessibleSync()`)

Trevor: Let’s take the conversation back to Github to see if we can get resolution. Agnostic on the resolution.

## Next Meeting

2016-01-13
