# Code of Conduct

## Conduct

* We are committed to providing a friendly, safe and welcoming
  environment for all, regardless of level of experience, gender
  identity and expression, sexual orientation, disability,
  personal appearance, body size, race, ethnicity, age, religion,
  nationality, or other similar characteristic.
* Please avoid using overtly sexual nicknames or other nicknames that
  might detract from a friendly, safe and welcoming environment for
  all.
* Please be kind and courteous. There's no need to be mean or rude.
* Respect that some individuals and cultures consider the casual use of
  profanity and sexualized language offensive and off-putting.
* Respect that people have differences of opinion and that every
  design or implementation choice carries a trade-off and numerous
  costs. There is seldom a right answer.
* Please keep unstructured critique to a minimum. If you have solid
  ideas you want to experiment with, make a fork and see how it works.
* We will exclude you from interaction if you insult, demean or harass
  anyone. That is not welcome behavior. We interpret the term
  "harassment" as including the definition in the [Citizen Code of
  Conduct](http://citizencodeofconduct.org/); if you have any lack of
  clarity about what might be included in that concept, please read
  their definition. In particular, we don't tolerate behavior that
  excludes people in socially marginalized groups.
* Private harassment is also unacceptable. No matter who you are, if
  you feel you have been or are being harassed or made uncomfortable
  by a community member, please contact one of the channel ops or any
  of the TSC members immediately with a capture (log, photo, email) of
  the harassment if possible. Whether you're a regular contributor or
  a newcomer, we care about making this community a safe place for you
  and we've got your back.
* Likewise any spamming, trolling, flaming, baiting or other
  attention-stealing behavior is not welcome.
* Avoid the use of personal pronouns in code comments or
  documentation. There is no need to address persons when explaining
  code (e.g. "When the developer").

## Contact
Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by:

* Emailing [report@nodejs.org](mailto:report@nodejs.org) (this will email all TSC members)
* Contacting [individual TSC members](https://nodejs.org/en/foundation/tsc/#current-members-of-the-technical-steering-committee).

## Moderation
See the TSC's [moderation policy](https://github.com/nodejs/TSC/blob/master/Moderation-Policy.md) for details about moderation.

## Attribution

This Code of Conduct is adapted from [Rust's wonderful
CoC](http://www.rust-lang.org/conduct.html) as well as the
[Contributor Covenant v1.3.0](http://contributor-covenant.org/version/1/3/0/).
