# Node Foundation CTC Meeting 2016-09-21

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8656](https://github.com/nodejs/node/issues/8656)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1-PS20PGCJQIi4_quBHqVgrQNJeJP10NH21wUelcMhfw>
* _Previous Minutes Google Doc_: <https://docs.google.com/document/d/1kW9wLdfojpIGbu3fQMrtr7S_RJFq8CWupoKnmtWw17Q>

## Present

* Anna Henningsen @addaleax (CTC)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Fedor Indutny @indutny (CTC)
* James M Snell @jasnell (CTC)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Myles Borins @TheAlphaNerd (CTC)
* Rich Trott @Trott (CTC)
* Steven R Loomis @srl295 (observer/IBM/ICU)
* Seth Thompson (observer/Google)
* Jenn Turner (observer/Node Foundation)
* Josh Gavant (observer/Microsoft)


## Standup

* Anna Henningsen @addaleax (CTC)
    * Node Interactive EU
    * In particular, Code & Learn
* Сковорода Никита Андреевич @ChALkeR (CTC)
    * Filed some PRs regarding doc linting
    * Some issue comments and PR reviews as usual
* Evan Lucas @evanlucas (CTC)
    * Working on an EP for exposing is* methods from core
* Jeremiah Senkpiel @Fishrock123 (CTC)
    * async_hooks review
    * v6.6.0 release
* Fedor Indutny @indutny (CTC)
    * PRs, regular/security issues, Node.js Interactive!
* James M Snell @jasnell (CTC)
    * Node Interactive EU/Collab summit
    * Reviewing PRs (primarily from the code n learn)
    * Preparing v7.0.0-beta1 (built now!)
    * Preparing for TC-39 meeting next week
    * Continued work on HTTP/2 plan
* Michael Dawson @mhdawson (CTC)
    * Node Interactive EU/Collaborators summit
    * New PPC machines into CI
    * Addition of LinuxOne and AIX to nightlies
    * build WG meeting, benchmarking WG meeting
    * Investigating an AIX issues
    * Some work on ABI stable API
    * Catching up on issues
* Brian White @mscdex (CTC)
    * Performance testing for various things
    * Submitted PRs to improve setImmediate() and setTimeout()/setInterval() performance
    * Submitted alternative PR to fix the malloc(0) compatibility issue introduced in node v6.6.0
    * Worked on other various potential optimizations in core
    * Reviewed PRs, commented on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
    * Mostly busy with internal stuff; work with some inspector PRs; finishing up V8 guide.
* Myles Borins @TheAlphaNerd (CTC)
    * Node Interactive EU / Collab Summit
    * Work on new tap reporter
    * Reviewing @ofrobots work on V8 guide
    * LTS backporting work
* Rich Trott @Trott (CTC)
    * Onboarded @ak239 and @eugeneo
    * assorted test, tools, and doc PRs
    * https://github.com/nodejs/node/pull/8572 (Malloc and Calloc with size 0) to fix https://github.com/nodejs/node/issues/8571 (node::PBKDF2() Out of Memory) to land imminently, please take a look
    * looking at the recent uptick in test failures, trying to figure out ways to fix it systemically and avoid it from recurring
    * CTC meeting time proposal: more work than you think, trust me
* Seth Thompson @s3ththompson (observer/Google)
    * continued v8_inspector work

## Agenda

* deps: update V8 to 5.4 [node#8317](https://github.com/nodejs/node/pull/8317)
* Scheduling Meetings [ctc#14](https://github.com/nodejs/CTC/issues/14)
* Decide on what problem points for ES Modules we care about the most. [ctc#15](https://github.com/nodejs/CTC/issues/15)

## Previous Meeting Review

* AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)
    * Merge.


## Minutes

@trott: removed the async_hooks EP from the agenda, if anybody has concerns, the place for that would be on Github, or if necessary the item can be put on the agenda again.

### deps: update V8 to 5.4 [#8317](https://github.com/nodejs/node/pull/8317)

@ofrobots: V8 5.4 is part of Chrome beta. Since we’re trying to release v7.x with V8 5.4 I think it would be best to land this in master now rather than close to release.

Traditionally we’ve only landed V8 once it goes stable, but in this particular instance I think it’s important cause of 7.0 and this beta lining up so closely.

@Fishrock123: Original reason why we only landed stable was because in io.js we were landing beta, but the V8 team warned us that things could change, and they did change.

Did these things change on the V8 end? How is this different than yesterday?

@ofrobots: Google is saying we shouldn’t *ship* a V8 beta. It’s in master so it can undergo testing, but we wouldn’t ship it. Things could change but it doesn’t matter cause it’s just in master, we’re not shipping it.

@Fishrock123: Do RC’s count as shipping this? Some people will expect not much breakage between RC and release.

@jasnell: We’ve had issues where things are broken in master and people complain cause it’s broken in master even if it doesn’t go to releases.

@ofrobots: Purpose of an RC is to say this is what we think we’re going to ship, intention is not to change. With V8, we’ll also have the intention not to change. If a bug is found which breaks the web and a change needs to happen then it would happen.

@Seth: We treat beta as an RC in that respect.

@myles: Re what @jasnell said about things on master, it’s about things landing on master which are experience breaking. We’ve already been testing with 5.4. We should just be ready to revert if there’s an experience-breaking problem.

@Fishrock123: Good arguments, but we’re changing what we’re doing where we took a particular stance because people had issues with it.

@jasnell: We took that stance before we had the improved release model, with LTS. Risk was much greater then than now.

@trott: Any other voices?

@jasnell: @Fishrock123 is this something you absolutely want to see?

@Fishrock123: If there’s a vote I’ll just abstain.

@trott: Seems we have consensus and don’t need to vote.

@Fishrock123: Might as well try it again and see if it works.

@jasnell: If anything comes up, V8 team please give us a heads up as early as possible.

@ofrobots: one change that’s going to happen, is that since Node is going to use V8 5.4, we’re going to get v8_inspector into v8 and out of separate deps folder. This will make build and maintenance easier for Node.

**Next steps**:

- Do this and keep a careful eye.
- Evaluate after this cycle and decide what to do in the future.

---

### Scheduling Meetings [ctc#14](https://github.com/nodejs/CTC/issues/14)

@trott: Raising for CTC awareness.

---

### Decide on what problem points for ES Modules we care about the most. [ctc#15](https://github.com/nodejs/CTC/issues/15)

@Fishrock123: Majority of problems we can see so far are in EP #002, also in CTC#15.

Bradley’s been at this for almost a year trying to get better support for us and nothing’s really moved from the spec end. I kind of doubt it will but would like to push in that direction.

Would be good to find out what the CTC and Collaborators care about. Focus on CTC cause it’s easier to get overall decision with a smaller group. There’s a lot to talk about.

Hard to know what opinion I should have.

@trott: Is the question: Assuming the spec does not change, what should we do?

@Fishrock123: If we want to push the spec to changing for better compatibility, what do we want to push? Pushing on everything would be basically rewriting the entire spec…

@jasnell: Another aspect of this, conversations with TC39 at multiple levels, not just technical but also process. Try to help TC39 understand and care about the issues. If there’s something to change, it’s something they should care about also.

@Fishrock123: Still comes back to this list of issues. What do we want to tackle the most?

TC39 meeting next week, a couple people are going to that, context around what CTC cares about would be helpful.

@jasnell: TC39 is 9/27-29. We should have a call just for CTC to make sure all are on same page beforehand.

@Fishrock123: While I agree with that, we still need a consensus from the CTC on where to focus. Do we care about loading modules, REPLs, wrapping modules.

@trott: Anything in particular?

@jasnell: All are breaking issues.

@Fishrock123: We don’t break modules, but if a module moves to ESM they could break downstream modules.

@joshgav: In particular cannot change modules after import, breaks mocks and APMs.

@Fishrock123: For example, `graceful-fs` might not work at all.

@jasnell: What are our goals to come away from TC39 meeting?

@Fishrock123:
* TC39 showing some amount of care for our problems.
* Communication of those problems and some cooperation.
* Look at delaying shipping dates so we don’t have a browser vendor war which exacerbates our problems.

@trott: Encourage everyone to read the issue carefully, ask a bunch of questions, know that date of TC39 meeting is coming and we need one clear set of priorities. Everyone that can have an informed opinion on this should educate themselves and participate.

@jasnell: Talked with some of the members of TC39. What they articulated is that not to expect sweeping changes be made just because we ask for them.

Instead describe why the current spec is a problem, and if there are aspects which are incorrect or can be improved, it’s on us to make those changes.

We can’t expect them to care. Ideally they’d care already. But we have to have a proposal - this is why the module spec is broken, in terms of “we can’t implement it and this is why.”

@thealphanerd: Conversations on Twitter, biggest sentiment from TC39 is that there are individuals who do care and want to work with us on it. If we approach with that narrative we’ll likely have more progress.

@jasnell: Definite sentiment that we should be able to make this work, just a matter of making the right case.

---

## Q/A on public channels

None.


## Upcoming Meetings

* CTC: 2016-09-28
* TSC: 2016-09-22
* Build:
* Diagnostics: 2016-09-28
* Benchmarking: 2016-09-21
* LTS:
* Post-Mortem:
* API:
