# Node Foundation CTC Meeting 2016-07-20

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: https://github.com/nodejs/node/issues/7809
* **Minutes Google Doc**: <https://docs.google.com/document/d/1Gr1XX-DuzgGXON5uAzrZHjWwXoQ4AIJEAJ2DK5jNmp4>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1fP9_ZNcPoFh2VWCgUFu9-rDiDcMP88vhCC_oX6Aj528>_

## Present

* Anna Henningsen @addaleax (observer)
* Ben Noordhuis @bnoordhuis (CTC)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Julien Gilli @misterdjules (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Alexis Campailla @orangemocha (CTC)
* Rod Vagg @rvagg (CTC)
* Seth Thompson @s3ththompson (observer/Google)
* Shigeki Ohtsu @shigeki (CTC)
* Steven R Loomis @srl295 (observer/IBM/ICU)
* Myles Borins @TheAlphaNerd (observer)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Standup

* Anna Henningsen @addaleax (observer)
  * Issues & PRs
  * looking into porting JS-based realpath to C
* Ben Noordhuis @bnoordhuis (CTC)
  * The usual (PR review and comment)
  * Updating code base to do less manual memory management. PR coming soon.
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * Some initial work on docs linting.
  * Some comments on issues and PRs.
* Colin Ihrig @cjihrig (CTC)
  * Reviewed issues and PRs
  * Opened PRs
* Evan Lucas @evanlucas (CTC)
  * working on v6.3.1 release
  * working on repl bugfix
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Did some timers review for https://github.com/nodejs/node/commit/5aac4c42da104c30d8f701f1042d61c2f06b7e6c
  * Clearing out some other old stuff I’ve assigned myself to
* Josh Gavant @joshgav (observer/Microsoft)
  * Internal Microsoft work.
* Michael Dawson @mhdawson (CTC)
  * Misc issues with PPC machines, added new PPC
    machines from newer openstack
  * Working with Ian/Sampson on ABI stable abi, status
    update at API WG meeting
  * Working with Richard/Howard on post-mortem activities,
    post-mortem WG meeting this week.
  * Misc reviews/lands
  * Reading/keeping up/commenting on issues
  * Getting ready for Node Summit talk.
* Julien Gilli @misterdjules (CTC)
  * Looking forward to getting more involved again
  * Investigating timers bug. Looking for someone to mentor on it
  * Reviewing and commenting on pull requests
* Brian White @mscdex (CTC)
  * Diving deep into reworking API docs
  * Reviewing PRs, commenting on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * shepherding some V8 backports, v8_inspector license issue and roll
* Alexis Campailla @orangemocha (CTC)
  * Nothing to report.
* Rod Vagg @rvagg (CTC)
  * Usual administrative stuff, some build maintenance
* Seth Thompson @s3ththompson (observer/Google)
  * Setting priorities for the next quarter.
  * Team is continuing work on v8_inspector.
  * Migrating v8_inspector into V8 itself.
* Shigeki Ohtsu @shigeki (CTC)
  * Nothing special. Working internal jobs.
* Steven R Loomis @srl295 (observer/IBM/ICU)
  * Nodesummit prep…
* Myles Borins @TheAlphaNerd (observer)
  * v4.5.0-rc.2 released
  * Email sent to npm team
* Trevor Norris @trevnorris (CTC)
  * realpath fix
* Rich Trott @Trott (CTC)
  * CTC governance doc updates
  * onboarded @andrasq, will set up something with @princejwesley next, open to other nominations for after that
  * eliminating more flaky tests (IT NEVER ENDS!!!!11!!!)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* [meta] realpath issues in v6 [#7726](https://github.com/nodejs/node/issues/7726)
* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

## Previous Meeting

* build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/pull/7484)

* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/pull/7175)

* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

## Minutes

### [meta] realpath issues in v6 [#7726](https://github.com/nodejs/node/issues/7726)

@rvagg: some discussion of reversion to v5 behavior, i.e. JS implementation rather than libuv implementation.

@trevnorris: looks like everybody’s leaning towards a full revert (or at least a partial revert). I don’t like this plan but will go along.

@addaleax: Unfortunate to have to do full revert for *nix systems. But having alternate impl for Windows increases maintenance costs.

As part of the new implementation, the `cache` parameter was removed from the method. It was created to improve perf for the JS impl but is considered less necessary since the native impl performs better anyway.

Should we reinstate the `cache` parameter as part of the revert? Would this be a semver-major again? Does caching in the JS impl provide a significant perf benefit?

@addaleax: Benchmarking fs perf will show how much benefit the caching capability in libuv provides.

@mhdawson: we run two benchmarks nightly: one with caching and one without.

@orangemocha: It seems okay to have two impl’s, one for Windows and one for *nix, increased maintenance surface isn’t a concern, libuv manages libuv impl.

@rvagg: As we move v6 to LTS it would be best to have a known-good implementation. So would prefer a full revert, then fix libuv impl independently, then re-integrate.

@thealphanerd: Could we provide both interfaces? Revert the primary one to original behavior and add a second one with libuv behavior?

@rvagg: Still doesn’t address breaking change in Windows.

@fishrock123: also in favor of reverting. This has been going on for a long time, best to revert and then fix.

@orangemocha: should not compromise correctness for performance.

@trevnorris: caching could be separated from fs API. For example, it could be part of `module` module.

@rvagg: This is why I’m in favor of a full reversion. These other discussions may continue for a month and we need to correct problem now.

@thealphanerd: do we have a list of the original bugs the libuv patch addressed?

@saghul has a list.

@rvagg: back to github for now.

**Next steps**: continue discussion in GH.

### v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

@thealphanerd is raising visibility for tests and feedback.

@misterdjules may have some testers.

### http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

@rvagg: Need choices to vote on.

@ofrobots: Wants to explore more options including `map` so wait for vote. If the goal is to go to a map why don’t we do that now?

@Fishrock123: Because community has taken dependencies on it being an object.

@ofrobots: headers end up with “megamorphic IC’s” so wants to research further.

@Fishrock123: We are fixing this because header names like `__proto__` conflict with default object properties.

We should really just make an API for headers.

@rvagg: We’ll come back to this next week. Prepare wording for vote if ready.

**Next steps**: List available options and conduct vote next week.


## Q/A on public fora

None.

## Upcoming Meetings

* CTC: 2016-07-27
* TSC: 2016-07-28
* Build: 2016-08-07
* LTS: 2016-07-25
* Diagnostics: 2016-08-03
* Post-Mortem: August
* API: August
