'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
/* eslint-disable sorting/sort-object-props */

/**
 * @typedef border
 * @property {string} topBody
 * @property {string} topJoin
 * @property {string} topLeft
 * @property {string} topRight
 * @property {string} bottomBody
 * @property {string} bottomJoin
 * @property {string} bottomLeft
 * @property {string} bottomRight
 * @property {string} bodyLeft
 * @property {string} bodyRight
 * @property {string} bodyJoin
 * @property {string} joinBody
 * @property {string} joinLeft
 * @property {string} joinRight
 * @property {string} joinJoin
 */

/**
 * @param {string} name
 * @returns {border}
 */

exports.default = function (name) {
    if (name === 'honeywell') {
        return {
            topBody: '═',
            topJoin: '╤',
            topLeft: '╔',
            topRight: '╗',

            bottomBody: '═',
            bottomJoin: '╧',
            bottomLeft: '╚',
            bottomRight: '╝',

            bodyLeft: '║',
            bodyRight: '║',
            bodyJoin: '│',

            joinBody: '─',
            joinLeft: '╟',
            joinRight: '╢',
            joinJoin: '┼'
        };
    }

    if (name === 'norc') {
        return {
            topBody: '─',
            topJoin: '┬',
            topLeft: '┌',
            topRight: '┐',

            bottomBody: '─',
            bottomJoin: '┴',
            bottomLeft: '└',
            bottomRight: '┘',

            bodyLeft: '│',
            bodyRight: '│',
            bodyJoin: '│',

            joinBody: '─',
            joinLeft: '├',
            joinRight: '┤',
            joinJoin: '┼'
        };
    }

    if (name === 'ramac') {
        return {
            topBody: '-',
            topJoin: '+',
            topLeft: '+',
            topRight: '+',

            bottomBody: '-',
            bottomJoin: '+',
            bottomLeft: '+',
            bottomRight: '+',

            bodyLeft: '|',
            bodyRight: '|',
            bodyJoin: '|',

            joinBody: '-',
            joinLeft: '|',
            joinRight: '|',
            joinJoin: '|'
        };
    }

    if (name === 'void') {
        return {
            topBody: '',
            topJoin: '',
            topLeft: '',
            topRight: '',

            bottomBody: '',
            bottomJoin: '',
            bottomLeft: '',
            bottomRight: '',

            bodyLeft: '',
            bodyRight: '',
            bodyJoin: '',

            joinBody: '',
            joinLeft: '',
            joinRight: '',
            joinJoin: ''
        };
    }

    throw new Error('Unknown border template "${name}".');
};

module.exports = exports['default'];
//# sourceMappingURL=getBorderCharacters.js.map
