// Copyright 2013 Google Inc. All Rights Reserved.

// This file was generated from a python script.

#include "v8.h"
#include "trig-table.h"

namespace v8 {
namespace internal {

  const double TrigonometricLookupTable::kSinTable[] =
      { 0.0,0.0008726645152351496,0.0017453283658983088,0.002617990887417994,0.003490651415223732,0.004363309284746571,0.0052359638314195805,0.006108614390678361,0.0069812602979615525,0.007853900888711334,0.008726535498373935,0.00959916346240014,0.010471784116245794,0.011344396795372308,0.012217000835247169,0.013089595571344441,0.013962180339145272,0.014834754474138404,0.015707317311820675,0.016579868187697525,0.01745240643728351,0.018324931396102796,0.019197442399689665,0.020069938783589036,0.02094241988335696,0.02181488503456112,0.022687333572781358,0.023559764833610154,0.024432178152653153,0.02530457286552966,0.026176948307873153,0.02704930381533178,0.02792163872356888,0.02879395236826347,0.029666244085110757,0.03053851320982266,0.03141075907812829,0.03228298102577449,0.033155178388526274,0.034027350502167444,0.03489949670250097,0.035771616325349594,0.036643708706556276,0.03751577318198474,0.03838780908751994,0.03925981575906861,0.04013179253255973,0.04100373874394506,0.04187565372919963,0.042747536824322245,0.043619387365336,0.04449120468828878,0.04536298812925378,0.046234737024329974,0.047106450709642665,0.04797812852134395,0.04884976979561326,0.04972137386865785,0.05059294007671331,0.051464467756044054,0.052335956242943835,0.053207404873736264,0.05407881298477529,0.054950179912445746,0.0558215049931638,0.05669278756337751,0.057564026959567284,0.05843522251824643,0.05930637357596162,0.06017747946929345,0.06104853953485687,0.06191955310930176,0.06279051952931337,0.06366143813161292,0.06453230825295798,0.06540312923014308,0.06627390040000014,0.06714462109939906,0.06801529066524817,0.06888590843449467,0.0697564737441253,0.07062698593116669,0.07149744433268593,0.07236784828579108,0.07323819712763169,0.07410849019539924,0.07497872682632771,0.07584890635769403,0.07671902812681863,0.07758909147106598,0.07845909572784494,0.07932904023460945,0.08019892432885892,0.08106874734813876,0.08193850863004093,0.08280820751220434,0.0836778433323155,0.08454741542810887,0.08541692313736747,0.08628636579792337,0.08715574274765817,0.08802505332450349,0.08889429686644151,0.08976347271150548,0.09063258019778016,0.09150161866340238,0.09237058744656158,0.09323948588550021,0.09410831331851433,0.09497706908395402,0.095845752520224,0.09671436296578402,0.09758289975914947,0.09845136223889178,0.09931974974363901,0.10018806161207629,0.10105629718294634,0.10192445579505004,0.10279253678724681,0.10366053949845523,0.10452846326765347,0.10539630743387983,0.10626407133623321,0.10713175431387366,0.10799935570602284,0.10886687485196457,0.10973431109104527,0.1106016637626745,0.11146893220632548,0.11233611576153554,0.11320321376790672,0.11407022556510614,0.11493715049286661,0.11580398789098709,0.11667073709933316,0.11753739745783764,0.11840396830650095,0.11927044898539167,0.1201368388346471,0.12100313719447367,0.12186934340514748,0.12273545680701484,0.12360147674049271,0.12446740254606924,0.12533323356430426,0.12619896913582976,0.1270646086013505,0.1279301513016443,0.1287955965775628,0.12966094377003173,0.1305261922200516,0.13139134126869806,0.13225639025712244,0.13312133852655234,0.13398618541829205,0.134850930273723,0.13571557243430438,0.13658011124157357,0.13744454603714665,0.13830887616271895,0.13917310096006544,0.14003721977104136,0.14090123193758267,0.14176513680170647,0.14262893370551166,0.14349262199117932,0.1443562010009732,0.1452196700772404,0.14608302856241162,0.1469462757990018,0.14780941112961063,0.148672433896923,0.14953534344370956,0.1503981391128271,0.15126082024721924,0.1521233861899167,0.15298583628403806,0.15384816987279004,0.1547103862994681,0.1555724849074569,0.15643446504023087,0.15729632604135463,0.15815806725448353,0.1590196880233642,0.15988118769183488,0.1607425656038261,0.16160382110336113,0.16246495353455648,0.16332596224162227,0.16418684656886295,0.16504760586067765,0.16590823946156075,0.16676874671610228,0.16762912696898857,0.1684893795650026,0.1693495038490246,0.17020949916603256,0.1710693648611026,0.17192910027940952,0.17278870476622754,0.17364817766693033,0.17450751832699196,0.1753667260919871,0.17622580030759166,0.1770847403195833,0.17794354547384175,0.1788022151163496,0.17966074859319253,0.18051914525055998,0.1813774044347455,0.18223552549214747,0.18309350776926928,0.18395135061272017,0.18480905336921546,0.18566661538557722,0.18652403600873463,0.18738131458572463,0.18823845046369228,0.1890954429898913,0.18995229151168463,0.19080899537654483,0.19166555393205464,0.19252196652590742,0.1933782325059078,0.19423435121997198,0.19509032201612825,0.1959461442425177,0.19680181724739437,0.19765734037912616,0.1985127129861949,0.1993679344171972,0.20022300402084467,0.20107792114596468,0.2019326851415006,0.2027872953565125,0.2036417511401775,0.20449605184179034,0.2053501968107639,0.20620418539662966,0.20705801694903808,0.20791169081775934,0.20876520635268367,0.20961856290382183,0.21047175982130567,0.21132479645538868,0.21217767215644626,0.21303038627497656,0.21388293816160067,0.2147353271670632,0.21558755264223287,0.21643961393810288,0.2172915104057915,0.21814324139654254,0.2189948062617258,0.21984620435283753,0.2206974350215011,0.2215484976194673,0.22239939149861496,0.22325011601095138,0.2241006705086128,0.224951054343865,0.2258012668691037,0.22665130743685505,0.2275011753997762,0.22835087011065575,0.22920039092241418,0.23004973718810443,0.2308989082609124,0.23174790349415733,0.23259672224129246,0.2334453638559054,0.23429382769171864,0.23514211310259,0.23599021944251333,0.23683814606561868,0.2376858923261731,0.23853345757858088,0.23938084117738426,0.24022804247726373,0.24107506083303865,0.24192189559966773,0.2427685461322494,0.24361501178602252,0.24446129191636662,0.24530738587880258,0.24615329302899305,0.2469990127227429,0.24784454431599987,0.2486898871648548,0.24953504062554235,0.25038000405444144,0.2512247768080756,0.25206935824311366,0.2529137477163701,0.25375794458480566,0.2546019482055276,0.25544575793579055,0.25628937313299666,0.2571327931546962,0.2579760173585882,0.2588190451025208,0.25966187574449157,0.2605045086426484,0.26134694315528956,0.2621891786408647,0.2630312144579748,0.26387304996537286,0.26471468452196467,0.2655561174868088,0.2663973482191174,0.26723837607825685,0.2680792004237477,0.2689198206152657,0.26976023601264193,0.27060044597586363,0.27144044986507426,0.27228024704057435,0.27311983686282176,0.27395921869243245,0.27479839189018057,0.27563735581699916,0.2764761098339808,0.2773146533023778,0.27815298558360274,0.2789911060392293,0.2798290140309921,0.2806667089207878,0.2815041900706754,0.2823414568428765,0.283178508599776,0.28401534470392265,0.2848519645180293,0.28568836740497355,0.2865245527277983,0.287360519849712,0.28819626813408933,0.2890317969444716,0.2898671056445673,0.2907021935982525,0.29153706016957137,0.29237170472273677,0.29320612662213047,0.294040325232304,0.29487429991797875,0.2957080500440467,0.296541574975571,0.297374874077786,0.29820794671609824,0.2990407922560867,0.2998734100635032,0.3007057995042731,0.30153795994449567,0.30236989075044446,0.30320159128856805,0.30403306092549026,0.30486429902801077,0.30569530496310565,0.3065260780979277,0.30735661779980705,0.3081869234362516,0.3090169943749474,0.30984682998375945,0.3106764296307318,0.3115057926840881,0.31233491851223255,0.31316380648374953,0.31399245596740494,0.31482086633214607,0.31564903694710245,0.31647696718158613,0.31730465640509214,0.3181321039872992,0.31895930929807,0.3197862717074516,0.32061299058567627,0.3214394653031616,0.3222656952305111,0.32309167973851477,0.3239174181981494,0.32474290998057936,0.3255681544571567,0.3263931509994218,0.3272178989791039,0.32804239776812166,0.32886664673858323,0.3296906452627873,0.330514392713223,0.331337888462571,0.33216113188370333,0.33298412234968433,0.33380685923377096,0.3346293419094133,0.33545156975025503,0.3362735421301339,0.33709525842308213,0.337916718003327,0.33873792024529137,0.339558864523594,0.3403795502130501,0.3411999766886718,0.3420201433256687,0.3428400494994482,0.34365969458561607,0.3444790779599769,0.34529819899853464,0.34611705707749296,0.34693565157325584,0.34775398186242795,0.3485720473218152,0.34938984732842515,0.35020738125946743,0.35102464849235454,0.35184164840470183,0.3526583803743283,0.35347484377925714,0.35429103799771583,0.35510696240813705,0.35592261638915884,0.3567379993196252,0.3575531105785866,0.35836794954530027,0.359182515599231,0.3599968081200512,0.3608108264876418,0.3616245700820923,0.36243803828370164,0.36325123047297836,0.36406414603064124,0.36487678433761966,0.3656891447750543,0.3665012267242973,0.3673130295669129,0.368124552684678,0.3689357954595823,0.36974675727382933,0.3705574375098363,0.37136783555023484,0.37217795077787175,0.37298778257580895,0.3737973303273243,0.37460659341591207,0.3754155712252831,0.37622426313936563,0.37703266854230555,0.3778407868184671,0.37864861735243294,0.3794561595290051,0.3802634127332049,0.3810703763502741,0.38187704976567466,0.3826834323650898,0.38348952353442395,0.3842953226598037,0.38510082912757804,0.38590604232431863,0.3867109616368206,0.387515586452103,0.38831991615740885,0.38912395014020623,0.38992768778818826,0.39073112848927377,0.39153427163160764,0.39233711660356146,0.3931396627937339,0.3939419095909511,0.39474385638426723,0.39554550256296495,0.39634684751655574,0.3971478906347806,0.3979486313076104,0.3987490689252462,0.39954920287812,0.40034903255689497,0.401148557352466,0.40194777665596015,0.40274668985873724,0.40354529635239006,0.404343595528745,0.40514158677986256,0.40593926949803766,0.4067366430758002,0.40753370690591556,0.40833046038138493,0.4091269028954459,0.4099230338415728,0.4107188526134773,0.4115143586051088,0.4123095512106549,0.4131044298245418,0.4138989938414348,0.414693242656239,0.4154871756640993,0.41628079226040116,0.41707409184077104,0.41786707380107674,0.4186597375374281,0.4194520824461771,0.4202441079239187,0.421035813367491,0.4218271981739759,0.42261826174069944,0.42340900346523225,0.4241994227453902,0.42498951897923454,0.42577929156507266,0.4265687399014583,0.4273578633871924,0.4281466614213229,0.4289351334031459,0.4297232787322056,0.43051109680829514,0.43129858703145674,0.4320857488019823,0.43287258152041397,0.4336590845875443,0.4344452574044171,0.4352310993723275,0.4360166098928227,0.4368017883677022,0.43758663419901855,0.4383711467890774,0.43915532554043835,0.43993916985591514,0.44072267913857627,0.4415058527917452,0.4422886902190013,0.44307119082417973,0.4438533540113722,0.4446351791849275,0.4454166657494517,0.4461978131098088,0.44697862067112115,0.4477590878387697,0.4485392140183949,0.44931899861589664,0.450098441037435,0.45087754068943076,0.4516562969785656,0.4524347093117827,0.45321277709628727,0.45399049973954675,0.45476787664929164,0.45554490723351554,0.45632159090047586,0.4570979270586942,0.45787391511695674,0.45864955448431494,0.4594248445700856,0.46019978478385165,0.46097437453546236,0.4617486132350339,0.46252250029294995,0.4632960351198617,0.46406921712668886,0.4648420457246196,0.4656145203251114,0.4663866403398912,0.467158405180956,0.4679298142605734,0.4687008669912817,0.4694715627858908,0.47024190105748226,0.47101188121941,0.47178150268530067,0.472550764869054,0.4733196671848434,0.4740882090471163,0.4748563898705946,0.47562420907027525,0.47639166606143046,0.47715876025960846,0.4779254910806335,0.4786918579406068,0.4794578602559066,0.48022349744318893,0.48098876891938763,0.4817536741017153,0.48251821240766324,0.4832823832550024,0.4840461860617833,0.48480962024633706,0.48557268522727515,0.48633538042349056,0.48709770525415746,0.4878596591387327,0.48862124149695496,0.48938245174884626,0.49014328931471185,0.4909037536151409,0.49166384407100655,0.49242356010346716,0.4931829011339657,0.493941866584231,0.49470045587627787,0.4954586684324076,0.4962165036752082,0.49697396102755537,0.4977310399126122,0.4984877397538304,0.49924405997494986,0.5,0.5007555592532996,0.5015107371594574,0.5022655331433725,0.5030199466302351,0.5037739770455263,0.5045276238150193,0.5052808863647792,0.5060337641211637,0.5067862565108241,0.5075383629607041,0.5082900828980425,0.5090414157503713,0.5097923609455183,0.5105429179116057,0.5112930860770522,0.5120428648705715,0.512792253721175,0.51354125205817,0.5142898593111622,0.5150380749100542,0.5157858982850475,0.5165333288666418,0.5172803660856365,0.5180270093731302,0.5187732581605214,0.5195191118795094,0.5202645699620939,0.5210096318405764,0.5217542969475597,0.5224985647159488,0.5232424345789518,0.5239859059700791,0.5247289783231451,0.5254716510722678,0.5262139236518696,0.5269557954966776,0.5276972660417242,0.5284383347223471,0.5291790009741907,0.5299192642332049,0.5306591239356475,0.5313985795180829,0.5321376304173836,0.53287627607073,0.5336145159156116,0.5343523493898263,0.5350897759314822,0.5358267949789967,0.5365634059710976,0.5372996083468239,0.5380354015455252,0.538770785006863,0.539505758170811,0.540240320477655,0.5409744713679939,0.5417082102827399,0.5424415366631187,0.5431744499506707,0.5439069495872502,0.5446390350150271,0.5453707056764864,0.5461019610144291,0.5468328004719724,0.5475632234925503,0.5482932295199138,0.5490228179981318,0.5497519883715907,0.5504807400849956,0.5512090725833704,0.5519369853120581,0.5526644777167218,0.5533915492433441,0.5541181993382285,0.5548444274479993,0.5555702330196022,0.5562956155003048,0.5570205743376967,0.5577451089796902,0.5584692188745206,0.5591929034707469,0.5599161622172515,0.5606389945632417,0.5613613999582491,0.5620833778521306,0.5628049276950685,0.5635260489375715,0.564246741030474,0.564967003424938,0.565686835572452,0.5664062369248328,0.5671252069342249,0.5678437450531013,0.5685618507342639,0.5692795234308442,0.569996762596303,0.5707135676844317,0.5714299381493518,0.5721458734455163,0.572861373027709,0.573576436351046,0.5742910628709756,0.5750052520432786,0.5757190033240687,0.5764323161697932,0.5771451900372336,0.5778576243835053,0.5785696186660586,0.5792811723426788,0.5799922848714869,0.5807029557109398,0.5814131843198306,0.5821229701572894,0.5828323126827835,0.5835412113561175,0.5842496656374344,0.5849576749872154,0.5856652388662806,0.5863723567357892,0.5870790280572404,0.5877852522924731,0.5884910289036669,0.5891963573533421,0.5899012371043605,0.5906056676199254,0.5913096483635824,0.5920131787992196,0.5927162583910678,0.5934188866037015,0.5941210629020386,0.5948227867513413,0.5955240576172165,0.5962248749656158,0.5969252382628364,0.5976251469755212,0.5983246005706591,0.5990235985155858,0.5997221402779842,0.600420225325884,0.6011178531276634,0.6018150231520483,0.6025117348681135,0.6032079877452825,0.6039037812533287,0.6045991148623748,0.6052939880428944,0.605988400265711,0.6066823510019996,0.6073758397232867,0.6080688659014502,0.6087614290087207,0.6094535285176811,0.6101451639012676,0.6108363346327699,0.6115270401858311,0.6122172800344493,0.6129070536529765,0.6135963605161202,0.6142852000989433,0.6149735718768642,0.6156614753256583,0.6163489099214569,0.6170358751407486,0.6177223704603797,0.6184083953575542,0.619093949309834,0.6197790317951402,0.6204636422917524,0.6211477802783104,0.621831445233813,0.6225146366376195,0.6231973539694503,0.6238795967093862,0.6245613643378697,0.6252426563357052,0.6259234721840591,0.6266038113644605,0.6272836733588016,0.6279630576493379,0.6286419637186886,0.6293203910498375,0.6299983391261322,0.6306758074312863,0.6313527954493777,0.6320293026648509,0.632705328562516,0.6333808726275503,0.634055934345497,0.6347305132022677,0.635404608684141,0.636078220277764,0.636751347470152,0.6374239897486896,0.6380961466011305,0.6387678175155976,0.6394390019805848,0.6401096994849554,0.6407799095179446,0.6414496315691578,0.642118865128573,0.6427876096865393,0.6434558647337789,0.6441236297613865,0.64479090426083,0.6454576877239505,0.6461239796429639,0.6467897795104596,0.647455086819402,0.6481199010631309,0.6487842217353611,0.6494480483301837,0.6501113803420657,0.6507742172658509,0.6514365585967604,0.6520984038303922,0.6527597524627224,0.6534206039901054,0.654080957909274,0.6547408137173397,0.6554001709117939,0.6560590289905073,0.6567173874517308,0.6573752457940958,0.6580326035166145,0.6586894601186805,0.659345815100069,0.6600016679609367,0.6606570182018237,0.6613118653236518,0.6619662088277268,0.6626200482157375,0.6632733829897567,0.6639262126522416,0.6645785367060341,0.6652303546543609,0.6658816660008343,0.6665324702494525,0.6671827669045998,0.6678325554710467,0.6684818354539511,0.6691306063588582,0.6697788676917006,0.6704266189587991,0.671073859666863,0.6717205893229903,0.672366807434668,0.6730125135097733,0.6736577070565728,0.6743023875837234,0.674946554600273,0.6755902076156602,0.6762333461397154,0.6768759696826607,0.6775180777551102,0.6781596698680706,0.6788007455329417,0.6794413042615166,0.6800813455659817,0.6807208689589178,0.6813598739533001,0.6819983600624985,0.682636326800278,0.6832737736807992,0.6839107002186184,0.6845471059286887,0.6851829903263591,0.6858183529273763,0.6864531932478837,0.687087510804423,0.6877213051139337,0.688354575693754,0.6889873220616206,0.6896195437356698,0.6902512402344372,0.6908824110768584,0.6915130557822694,0.6921431738704068,0.6927727648614084,0.693401828275813,0.6940303636345616,0.6946583704589974,0.6952858482708654,0.6959127965923144,0.6965392149458957,0.6971651028545646,0.6977904598416802,0.6984152854310058,0.6990395791467099,0.6996633405133654,0.700286569055951,0.7009092642998509,0.7015314257708557,0.7021530529951624,0.7027741454993748,0.7033947028105039,0.7040147244559684,0.7046342099635946,0.7052531588616178,0.705871570678681,0.706489444943837,0.7071067811865475,0.7077235789366842,0.7083398377245287,0.7089555570807734,0.7095707365365209,0.7101853756232854,0.7107994738729924,0.7114130308179796,0.7120260459909964,0.7126385189252054,0.7132504491541816,0.7138618362119135,0.7144726796328034,0.7150829789516673,0.7156927337037358,0.7163019434246543,0.7169106076504828,0.7175187259176972,0.7181262977631888,0.7187333227242655,0.7193398003386511,0.7199457301444867,0.7205511116803304,0.7211559444851576,0.7217602280983622,0.7223639620597556,0.7229671459095681,0.7235697791884494,0.7241718614374675,0.724773392198111,0.7253743710122875,0.7259747974223262,0.7265746709709759,0.7271739912014068,0.7277727576572104,0.7283709698824002,0.7289686274214116,0.729565729819102,0.7301622766207523,0.7307582673720661,0.7313537016191705,0.7319485789086162,0.7325428987873788,0.7331366608028573,0.7337298645028764,0.7343225094356856,0.7349145951499598,0.7355061211948004,0.7360970871197343,0.7366874924747153,0.737277336810124,0.7378666196767683,0.7384553406258838,0.7390434992091337,0.7396310949786097,0.740218127486832,0.74080459628675,0.7413905009317421,0.7419758409756163,0.7425606159726109,0.7431448254773942,0.7437284690450652,0.744311546231154,0.744894056591622,0.7454759996828622,0.7460573750616994,0.7466381822853914,0.7472184209116277,0.7477980904985319,0.7483771906046599,0.7489557207890021,0.7495336806109825,0.7501110696304596,0.7506878874077263,0.7512641335035111,0.7518398074789774,0.7524149088957244,0.7529894373157873,0.7535633923016378,0.7541367734161843,0.7547095802227719,0.7552818122851835,0.7558534691676395,0.7564245504347982,0.7569950556517564,0.7575649843840495,0.7581343361976522,0.7587031106589781,0.7592713073348807,0.7598389257926538,0.7604059656000309,0.7609724263251867,0.7615383075367367,0.7621036088037377,0.7626683296956882,0.7632324697825288,0.7637960286346421,0.7643590058228538,0.7649214009184317,0.7654832134930881,0.766044443118978,0.7666050893687006,0.7671651518152995,0.7677246300322628,0.7682835235935234,0.7688418320734596,0.7693995550468951,0.7699566920890997,0.7705132427757891,0.7710692066831262,0.77162458338772,0.7721793724666269,0.7727335734973511,0.7732871860578441,0.7738402097265061,0.7743926440821856,0.7749444887041795,0.7754957431722345,0.7760464070665459,0.7765964799677596,0.7771459614569708,0.7776948511157258,0.778243148526021,0.7787908532703041,0.7793379649314741,0.7798844830928817,0.7804304073383297,0.7809757372520728,0.7815204724188187,0.7820646124237278,0.7826081568524139,0.7831511052909441,0.7836934573258398,0.784235212544076,0.7847763705330829,0.7853169308807448,0.7858568931754019,0.7863962570058489,0.7869350219613374,0.7874731876315738,0.7880107536067219,0.7885477194774018,0.7890840848346906,0.7896198492701227,0.7901550123756904,0.7906895737438433,0.79122353296749,0.7917568896399972,0.7922896433551907,0.7928217937073552,0.7933533402912352,0.7938842827020347,0.7944146205354181,0.79494435338751,0.7954734808548959,0.796002002534622,0.7965299180241963,0.797057226921588,0.7975839288252284,0.7981100233340114,0.7986355100472928,0.7991603885648918,0.7996846584870906,0.8002083194146346,0.8007313709487335,0.8012538126910607,0.801775644243754,0.8022968652094161,0.8028174751911146,0.8033374737923821,0.8038568606172174,0.8043756352700844,0.804893797355914,0.8054113464801033,0.8059282822485158,0.8064446042674825,0.8069603121438019,0.80747540548474,0.8079898838980304,0.808503746991876,0.8090169943749473,0.8095296256563844,0.810041640445796,0.8105530383532606,0.8110638189893267,0.8115739819650123,0.8120835268918062,0.8125924533816679,0.8131007610470276,0.813608449500787,0.8141155183563191,0.8146219672274693,0.8151277957285542,0.8156330034743637,0.8161375900801602,0.8166415551616789,0.8171448983351285,0.8176476192171913,0.8181497174250234,0.8186511925762553,0.8191520442889917,0.8196522721818125,0.8201518758737721,0.8206508549844007,0.821149209133704,0.8216469379421637,0.8221440410307375,0.8226405180208598,0.8231363685344418,0.8236315921938719,0.8241261886220157,0.8246201574422163,0.8251134982782952,0.8256062107545517,0.8260982944957639,0.8265897491271886,0.8270805742745618,0.8275707695640988,0.8280603346224944,0.8285492690769236,0.8290375725550416,0.8295252446849841,0.8300122850953675,0.8304986934152891,0.8309844692743282,0.8314696123025451,0.8319541221304825,0.8324379983891649,0.8329212407100994,0.8334038487252762,0.8338858220671681,0.8343671603687316,0.8348478632634065,0.8353279303851167,0.8358073613682702,0.8362861558477594,0.8367643134589616,0.837241833837739,0.8377187166204387,0.8381949614438942,0.838670567945424,0.8391455357628332,0.8396198645344132,0.8400935538989418,0.8405666034956842,0.8410390129643924,0.841510781945306,0.8419819100791528,0.8424523970071476,0.8429222423709944,0.8433914458128856,0.8438600069755025,0.8443279255020151,0.8447952010360832,0.8452618332218561,0.8457278217039732,0.846193166127564,0.8466578661382484,0.847121921382137,0.847585331505832,0.848048096156426,0.8485102149815036,0.8489716876291414,0.849432513747908,0.849892692986864,0.8503522249955628,0.8508111094240511,0.8512693459228684,0.8517269341430476,0.8521838737361154,0.8526401643540922,0.853095805649493,0.8535507972753275,0.8540051388850991,0.8544588301328073,0.8549118706729465,0.8553642601605067,0.8558159982509732,0.8562670846003282,0.8567175188650495,0.8571673007021123,0.8576164297689877,0.8580649057236445,0.8585127282245488,0.8589598969306644,0.8594064115014527,0.8598522715968734,0.8602974768773848,0.8607420270039436,0.8611859216380056,0.8616291604415257,0.8620717430769582,0.8625136692072575,0.8629549384958771,0.8633955506067716,0.8638355052043957,0.8642748019537048,0.8647134405201551,0.8651514205697044,0.865588741768812,0.8660254037844387,0.8664614062840472,0.8668967489356028,0.8673314314075731,0.8677654533689285,0.8681988144891423,0.8686315144381912,0.8690635528865555,0.869494929505219,0.8699256439656696,0.8703556959398997,0.8707850851004058,0.8712138111201894,0.8716418736727571,0.8720692724321206,0.8724960070727971,0.8729220772698096,0.8733474826986873,0.8737722230354652,0.8741962979566852,0.8746197071393957,0.8750424502611525,0.8754645270000179,0.8758859370345622,0.8763066800438635,0.8767267557075078,0.8771461637055887,0.8775649037187092,0.8779829754279805,0.8784003785150228,0.8788171126619654,0.8792331775514471,0.8796485728666165,0.880063298291132,0.880477353509162,0.8808907382053855,0.8813034520649922,0.8817154947736825,0.8821268660176678,0.8825375654836711,0.8829475928589269,0.8833569478311817,0.8837656300886935,0.8841736393202331,0.8845809752150839,0.8849876374630419,0.8853936257544159,0.8857989397800282,0.8862035792312147,0.8866075437998248,0.8870108331782217,0.8874134470592833,0.8878153851364013,0.8882166471034827,0.8886172326549489,0.8890171414857364,0.8894163732912975,0.8898149277675997,0.8902128046111265,0.8906100035188773,0.8910065241883678,0.8914023663176304,0.8917975296052141,0.8921920137501848,0.8925858184521255,0.892978943411137,0.8933713883278376,0.8937631529033632,0.8941542368393681,0.894544639838025,0.8949343616020251,0.895323401834578,0.8957117602394129,0.8960994365207778,0.8964864303834406,0.8968727415326884,0.8972583696743284,0.8976433145146883,0.8980275757606156,0.8984111531194788,0.898794046299167,0.8991762550080903,0.8995577789551804,0.8999386178498898,0.9003187714021935,0.9006982393225879,0.9010770213220917,0.9014551171122457,0.9018325264051138,0.9022092489132822,0.9025852843498606,0.9029606324284815,0.9033352928633008,0.9037092653689985,0.9040825496607784,0.904455145454368,0.9048270524660196,0.9051982704125096,0.9055687990111396,0.905938637979736,0.9063077870366499,0.9066762459007588,0.907044014291465,0.9074110919286968,0.9077774785329087,0.9081431738250813,0.9085081775267217,0.9088724893598641,0.9092361090470685,0.9095990363114232,0.9099612708765432,0.9103228124665711,0.9106836608061771,0.9110438156205597,0.9114032766354452,0.9117620435770886,0.912120116172273,0.9124774941483107,0.9128341772330428,0.9131901651548396,0.9135454576426009,0.9139000544257558,0.9142539552342637,0.9146071597986136,0.9149596678498249,0.9153114791194471,0.915662593339561,0.9160130102427778,0.9163627295622396,0.9167117510316201,0.917060074385124,0.9174076993574883,0.9177546256839811,0.9181008531004031,0.9184463813430872,0.9187912101488983,0.9191353392552345,0.9194787684000263,0.9198214973217376,0.9201635257593656,0.9205048534524404,0.9208454801410263,0.9211854055657211,0.9215246294676572,0.9218631515885005,0.9222009716704518,0.9225380894562464,0.9228745046891544,0.9232102171129809,0.9235452264720665,0.9238795325112867,0.9242131349760532,0.9245460336123131,0.9248782281665496,0.9252097183857821,0.9255405040175664,0.9258705848099947,0.9261999605116964,0.9265286308718373,0.9268565956401208,0.9271838545667874,0.9275104074026153,0.92783625389892,0.9281613938075555,0.9284858268809135,0.9288095528719242,0.9291325715340562,0.9294548826213165,0.9297764858882515,0.930097381089946,0.9304175679820246,0.9307370463206508,0.9310558158625283,0.9313738763649,0.9316912275855489,0.9320078692827984,0.9323238012155123,0.9326390231430941,0.932953534825489,0.9332673360231827,0.9335804264972017,0.9338928060091143,0.9342044743210295,0.9345154311955987,0.9348256763960145,0.9351352096860117,0.9354440308298673,0.9357521395924006,0.9360595357389733,0.9363662190354899,0.9366721892483976,0.9369774461446869,0.9372819894918916,0.9375858190580882,0.9378889346118977,0.9381913359224842,0.9384930227595559,0.9387939948933655,0.9390942520947091,0.9393937941349282,0.9396926207859083,0.9399907318200802,0.9402881270104189,0.9405848061304454,0.9408807689542255,0.9411760152563706,0.941470544812038,0.9417643573969303,0.9420574527872967,0.9423498307599323,0.9426414910921784,0.9429324335619231,0.943222657947601,0.9435121640281936,0.9438009515832294,0.9440890203927842,0.944376370237481,0.9446630008984905,0.9449489121575309,0.9452341037968682,0.9455185755993167,0.945802327348239,0.9460853588275453,0.9463676698216952,0.9466492601156964,0.9469301294951057,0.9472102777460288,0.9474897046551207,0.9477684100095857,0.9480463935971775,0.9483236552061993,0.9486001946255046,0.9488760116444965,0.9491511060531285,0.9494254776419039,0.949699126201877,0.9499720515246525,0.950244253402386,0.9505157316277837,0.9507864859941033,0.9510565162951535,0.9513258223252946,0.9515944038794382,0.9518622607530478,0.9521293927421387,0.9523957996432784,0.9526614812535863,0.9529264373707343,0.953190667792947,0.9534541723190012,0.9537169507482269,0.9539790028805069,0.9542403285162768,0.9545009274565261,0.9547607995027975,0.9550199444571866,0.9552783621223436,0.9555360523014722,0.9557930147983301,0.9560492494172291,0.9563047559630354,0.9565595342411698,0.9568135840576074,0.9570669052188783,0.9573194975320672,0.9575713608048144,0.9578224948453149,0.9580728994623192,0.9583225744651332,0.9585715196636188,0.958819734868193,0.9590672198898296,0.9593139745400575,0.9595599986309626,0.9598052919751869,0.9600498543859287,0.9602936856769431,0.960536785662542,0.9607791541575942,0.9610207909775255,0.9612616959383189,0.9615018688565149,0.9617413095492113,0.9619800178340637,0.9622179935292854,0.9624552364536473,0.9626917464264788,0.9629275232676672,0.9631625667976582,0.9633968768374559,0.963630453208623,0.963863295733281,0.9640954042341101,0.9643267785343497,0.9645574184577981,0.964787323828813,0.9650164944723114,0.96524493021377,0.9654726308792251,0.9656995962952725,0.9659258262890683,0.9661513206883285,0.9663760793213293,0.9666001020169074,0.9668233886044594,0.9670459389139431,0.9672677527758767,0.9674888300213395,0.9677091704819712,0.9679287739899732,0.9681476403781077,0.9683657694796987,0.9685831611286311,0.9687998151593519,0.9690157314068695,0.9692309097067544,0.9694453498951389,0.9696590518087175,0.9698720152847468,0.970084240161046,0.9702957262759965,0.9705064734685425,0.9707164815781908,0.9709257504450111,0.9711342799096361,0.9713420698132614,0.9715491199976461,0.9717554303051126,0.9719610005785463,0.9721658306613966,0.9723699203976766,0.972573269631963,0.9727758782093966,0.972977745975682,0.9731788727770883,0.9733792584604485,0.9735789028731603,0.9737778058631857,0.9739759672790516,0.9741733869698493,0.9743700647852352,0.9745660005754306,0.9747611941912218,0.9749556454839603,0.9751493543055633,0.9753423205085127,0.9755345439458566,0.9757260244712084,0.9759167619387474,0.9761067562032187,0.9762960071199334,0.9764845145447686,0.9766722783341679,0.9768592983451408,0.9770455744352636,0.9772311064626789,0.9774158942860959,0.9775999377647907,0.9777832367586061,0.9779657911279522,0.9781476007338057,0.9783286654377106,0.9785089851017784,0.9786885595886878,0.978867388761685,0.9790454724845838,0.9792228106217657,0.9793994030381801,0.9795752495993441,0.9797503501713428,0.9799247046208296,0.980098312815026,0.9802711746217219,0.9804432899092753,0.980614658546613,0.9807852804032304,0.9809551553491916,0.9811242832551292,0.9812926639922451,0.9814602974323101,0.981627183447664,0.9817933219112157,0.9819587126964436,0.9821233556773956,0.9822872507286886,0.9824503977255098,0.9826127965436152,0.9827744470593314,0.9829353491495543,0.98309550269175,0.9832549075639546,0.9834135636447744,0.9835714708133859,0.9837286289495359,0.9838850379335417,0.9840406976462909,0.9841956079692419,0.9843497687844239,0.9845031799744366,0.9846558414224508,0.984807753012208,0.9849589146280212,0.985109326154774,0.9852589874779214,0.9854078984834901,0.9855560590580777,0.9857034690888535,0.9858501284635585,0.9859960370705049,0.9861411947985772,0.9862856015372314,0.9864292571764954,0.9865721616069694,0.9867143147198253,0.9868557164068072,0.9869963665602319,0.9871362650729879,0.9872754118385365,0.9874138067509114,0.9875514497047189,0.9876883405951378,0.9878244793179197,0.9879598657693891,0.9880944998464434,0.9882283814465528,0.9883615104677608,0.9884938868086836,0.988625510368511,0.9887563810470058,0.9888864987445046,0.9890158633619168,0.9891444748007258,0.9892723329629883,0.9893994377513348,0.9895257890689695,0.9896513868196702,0.989776230907789,0.9899003212382514,0.9900236577165575,0.9901462402487812,0.9902680687415704,0.9903891431021473,0.9905094632383088,0.9906290290584258,0.9907478404714436,0.9908658973868822,0.9909831997148363,0.9910997473659748,0.9912155402515417,0.9913305782833557,0.9914448613738104,0.9915583894358742,0.9916711623830904,0.9917831801295777,0.9918944425900297,0.992004949679715,0.9921147013144779,0.9922236974107375,0.9923319378854887,0.9924394226563017,0.992546151641322,0.992652124759271,0.9927573419294455,0.9928618030717181,0.9929655081065369,0.9930684569549263,0.9931706495384861,0.9932720857793922,0.9933727656003964,0.9934726889248269,0.9935718556765875,0.9936702657801585,0.9937679191605964,0.9938648157435337,0.9939609554551797,0.9940563382223196,0.9941509639723154,0.9942448326331054,0.9943379441332046,0.9944302984017045,0.9945218953682733,0.9946127349631559,0.9947028171171742,0.9947921417617265,0.9948807088287882,0.9949685182509117,0.9950555699612262,0.9951418638934383,0.9952273999818312,0.9953121781612654,0.9953961983671789,0.9954794605355862,0.99556196460308,0.9956437105068296,0.9957246981845821,0.9958049275746618,0.9958843986159703,0.9959631112479873,0.9960410654107695,0.9961182610449516,0.9961946980917455,0.9962703764929413,0.9963452961909064,0.9964194571285864,0.9964928592495044,0.9965655024977614,0.9966373868180366,0.9967085121555869,0.9967788784562471,0.9968484856664305,0.996917333733128,0.9969854226039088,0.9970527522269202,0.997119322550888,0.9971851335251157,0.9972501850994857,0.9973144772244581,0.9973780098510718,0.997440782930944,0.9975027964162702,0.9975640502598242,0.997624544414959,0.9976842788356053,0.9977432534762729,0.99780146829205,0.9978589232386035,0.997915618272179,0.9979715533496006,0.9980267284282716,0.9980811434661735,0.9981347984218669,0.9981876932544914,0.9982398279237653,0.9982912023899855,0.9983418166140283,0.9983916705573488,0.998440764181981,0.9984890974505379,0.9985366703262117,0.9985834827727736,0.9986295347545738,0.9986748262365419,0.9987193571841863,0.9987631275635946,0.9988061373414341,0.9988483864849507,0.99888987496197,0.9989306027408966,0.9989705697907147,0.9990097760809875,0.9990482215818578,0.9990859062640476,0.9991228300988584,0.999158993058171,0.999194395114446,0.9992290362407229,0.9992629164106211,0.9992960355983396,0.9993283937786562,0.9993599909269292,0.9993908270190958,0.9994209020316729,0.9994502159417572,0.9994787687270248,0.9995065603657316,0.9995335908367129,0.999559860119384,0.9995853681937397,0.9996101150403544,0.9996341006403823,0.9996573249755573,0.9996797880281931,0.9997014897811831,0.9997224302180006,0.9997426093226983,0.9997620270799091,0.9997806834748455,0.9997985784932998,0.9998157121216442,0.9998320843468308,0.9998476951563913,0.9998625445384374,0.9998766324816606,0.9998899589753325,0.9999025240093042,0.999914327574007,0.999925369660452,0.99993565026023,0.9999451693655121,0.999953926969049,0.9999619230641713,0.9999691576447897,0.9999756307053947,0.9999813422410571,0.9999862922474267,0.9999904807207345,0.9999939076577904,0.9999965730559848,0.9999984769132877,0.9999996192282494,1.0,0.9999996192282494 };
  const double TrigonometricLookupTable::kCosXIntervalTable[] =
      { 0.0008726646259971648,0.0008726642937111275,0.0008726632968532686,0.0008726616354243474,0.000872659309425629,0.0008726563188588848,0.0008726526637263922,0.0008726483440309349,0.0008726433597758022,0.0008726377109647903,0.0008726313976022007,0.0008726244196928414,0.0008726167772420263,0.0008726084702555755,0.0008725994987398151,0.0008725898627015774,0.0008725795621482006,0.0008725685970875289,0.000872556967527913,0.000872544673478209,0.0008725317149477794,0.0008725180919464928,0.0008725038044847237,0.0008724888525733525,0.0008724732362237658,0.0008724569554478562,0.0008724400102580221,0.0008724224006671681,0.0008724041266887046,0.0008723851883365481,0.0008723655856251209,0.0008723453185693514,0.0008723243871846737,0.0008723027914870281,0.0008722805314928606,0.0008722576072191232,0.0008722340186832738,0.0008722097659032759,0.0008721848488975992,0.0008721592676852189,0.0008721330222856165,0.0008721061127187786,0.0008720785390051984,0.0008720503011658744,0.0008720213992223109,0.0008719918331965179,0.0008719616031110113,0.0008719307089888126,0.0008718991508534491,0.0008718669287289536,0.0008718340426398646,0.0008718004926112263,0.0008717662786685887,0.0008717314008380069,0.0008716958591460423,0.000871659653619761,0.0008716227842867353,0.0008715852511750429,0.0008715470543132667,0.0008715081937304954,0.0008714686694563229,0.0008714284815208487,0.0008713876299546778,0.0008713461147889203,0.0008713039360551918,0.0008712610937856133,0.0008712175880128112,0.0008711734187699166,0.0008711285860905668,0.0008710830900089035,0.000871036930559574,0.0008709901077777308,0.0008709426216990315,0.0008708944723596388,0.0008708456597962206,0.0008707961840459494,0.0008707460451465037,0.0008706952431360661,0.0008706437780533246,0.0008705916499374721,0.0008705388588282064,0.0008704854047657303,0.0008704312877907515,0.0008703765079444821,0.0008703210652686396,0.0008702649598054461,0.000870208191597628,0.000870150760688417,0.0008700926671215491,0.0008700339109412653,0.0008699744921923108,0.0008699144109199356,0.0008698536671698943,0.0008697922609884458,0.0008697301924223535,0.0008696674615188856,0.0008696040683258141,0.0008695400128914158,0.0008694752952644717,0.0008694099154942671,0.0008693438736305917,0.0008692771697237389,0.0008692098038245068,0.0008691417759841975,0.0008690730862546171,0.000869003734688076,0.0008689337213373882,0.000868863046255872,0.0008687917094973494,0.0008687197111161468,0.0008686470511670938,0.0008685737297055241,0.0008684997467872755,0.0008684251024686888,0.0008683497968066092,0.000868273829858385,0.0008681972016818687,0.0008681199123354155,0.000868041961877885,0.0008679633503686397,0.0008678840778675457,0.0008678041444349725,0.0008677235501317928,0.0008676422950193826,0.0008675603791596214,0.0008674778026148917,0.0008673945654480789,0.000867310667722572,0.0008672261095022625,0.0008671408908515454,0.0008670550118353181,0.0008669684725189817,0.0008668812729684392,0.0008667934132500969,0.0008667048934308642,0.0008666157135781523,0.0008665258737598758,0.0008664353740444516,0.0008663442145007991,0.0008662523951983402,0.0008661599162069995,0.0008660667775972037,0.0008659729794398817,0.0008658785218064652,0.0008657834047688877,0.0008656876283995847,0.0008655911927714945,0.0008654940979580567,0.0008653963440332132,0.0008652979310714082,0.0008651988591475871,0.0008650991283371978,0.0008649987387161893,0.0008648976903610129,0.0008647959833486213,0.0008646936177564686,0.000864590593662511,0.0008644869111452056,0.0008643825702835112,0.0008642775711568879,0.0008641719138452971,0.0008640655984292015,0.0008639586249895647,0.000863850993607852,0.0008637427043660291,0.000863633757346563,0.0008635241526324216,0.0008634138903070737,0.0008633029704544889,0.0008631913931591373,0.0008630791585059902,0.0008629662665805189,0.0008628527174686955,0.0008627385112569927,0.0008626236480323836,0.0008625081278823412,0.0008623919508948395,0.0008622751171583522,0.000862157626761853,0.0008620394797948164,0.0008619206763472163,0.0008618012165095264,0.0008616811003727209,0.0008615603280282733,0.0008614388995681571,0.0008613168150848454,0.0008611940746713106,0.0008610706784210251,0.0008609466264279603,0.0008608219187865875,0.0008606965555918767,0.0008605705369392976,0.0008604438629248189,0.0008603165336449081,0.0008601885491965322,0.0008600599096771571,0.000859930615184747,0.0008598006658177656,0.0008596700616751747,0.0008595388028564354,0.0008594068894615068,0.0008592743215908467,0.0008591410993454111,0.000859007222826655,0.0008588726921365307,0.0008587375073774896,0.0008586016686524805,0.0008584651760649505,0.0008583280297188447,0.0008581902297186061,0.0008580517761691753,0.0008579126691759907,0.0008577729088449883,0.0008576324952826018,0.0008574914285957621,0.0008573497088918977,0.0008572073362789344,0.0008570643108652949,0.0008569206327598994,0.0008567763020721651,0.0008566313189120059,0.000856485683389833,0.0008563393956165541,0.0008561924557035737,0.0008560448637627929,0.0008558966199066095,0.0008557477242479175,0.0008555981769001075,0.0008554479779770664,0.0008552971275931769,0.0008551456258633184,0.0008549934729028661,0.000854840668827691,0.0008546872137541599,0.0008545331077991357,0.0008543783510799769,0.0008542229437145371,0.0008540668858211662,0.0008539101775187088,0.0008537528189265051,0.0008535948101643906,0.0008534361513526958,0.0008532768426122463,0.0008531168840643626,0.0008529562758308602,0.0008527950180340491,0.0008526331107967344,0.0008524705542422152,0.0008523073484942855,0.0008521434936772335,0.000851978989915842,0.0008518138373353875,0.0008516480360616412,0.0008514815862208675,0.0008513144879398256,0.0008511467413457681,0.0008509783465664411,0.0008508093037300847,0.0008506396129654322,0.0008504692744017108,0.0008502982881686405,0.0008501266543964349,0.0008499543732158004,0.0008497814447579367,0.0008496078691545365,0.0008494336465377849,0.0008492587770403601,0.0008490832607954329,0.0008489070979366666,0.0008487302885982167,0.0008485528329147314,0.0008483747310213507,0.0008481959830537072,0.000848016589147925,0.0008478365494406204,0.0008476558640689017,0.0008474745331703685,0.0008472925568831121,0.0008471099353457156,0.000846926668697253,0.0008467427570772898,0.000846558200625883,0.0008463729994835801,0.0008461871537914199,0.0008460006636909319,0.0008458135293241367,0.0008456257508335449,0.0008454373283621582,0.0008452482620534685,0.0008450585520514579,0.000844868198500599,0.0008446772015458543,0.000844485561332676,0.0008442932780070067,0.0008441003517152786,0.0008439067826044132,0.000843712570821822,0.0008435177165154057,0.0008433222198335543,0.000843126080925147,0.0008429292999395522,0.000842731877026627,0.0008425338123367177,0.0008423351060206591,0.0008421357582297747,0.0008419357691158767,0.0008417351388312651,0.000841533867528729,0.0008413319553615451,0.0008411294024834783,0.0008409262090487814,0.0008407223752121951,0.0008405179011289477,0.000840312786954755,0.0008401070328458206,0.0008399006389588349,0.0008396936054509762,0.0008394859324799091,0.000839277620203786,0.0008390686687812455,0.0008388590783714134,0.0008386488491339016,0.0008384379812288092,0.0008382264748167211,0.0008380143300587084,0.000837801547116329,0.000837588126151626,0.000837374067327129,0.000837159370805853,0.0008369440367512988,0.0008367280653274524,0.0008365114566987857,0.0008362942110302556,0.0008360763284873039,0.0008358578092358581,0.0008356386534423295,0.0008354188612736151,0.0008351984328970964,0.0008349773684806388,0.0008347556681925926,0.0008345333322017923,0.0008343103606775564,0.0008340867537896874,0.0008338625117084715,0.0008336376346046792,0.0008334121226495639,0.0008331859760148627,0.0008329591948727964,0.0008327317793960684,0.0008325037297578657,0.0008322750461318579,0.0008320457286921975,0.0008318157776135199,0.0008315851930709426,0.000831353975240066,0.0008311221242969722,0.0008308896404182261,0.0008306565237808742,0.0008304227745624449,0.0008301883929409485,0.0008299533790948766,0.0008297177332032027,0.0008294814554453814,0.0008292445460013482,0.0008290070050515202,0.0008287688327767952,0.0008285300293585516,0.0008282905949786486,0.000828050529819426,0.0008278098340637037,0.0008275685078947822,0.0008273265514964418,0.0008270839650529427,0.000826840748749025,0.0008265969027699088,0.0008263524273012932,0.0008261073225293569,0.000825861588640758,0.0008256152258226333,0.0008253682342625991,0.0008251206141487498,0.0008248723656696593,0.0008246234890143794,0.0008243739843724406,0.0008241238519338514,0.0008238730918890987,0.0008236217044291471,0.0008233696897454392,0.0008231170480298949,0.0008228637794749121,0.0008226098842733657,0.0008223553626186079,0.000822100214704468,0.0008218444407252525,0.0008215880408757441,0.0008213310153512025,0.000821073364347364,0.0008208150880604409,0.0008205561866871218,0.0008202966604245715,0.0008200365094704304,0.0008197757340228148,0.0008195143342803165,0.0008192523104420029,0.0008189896627074165,0.000818726391276575,0.000818462496349971,0.000818197978128572,0.0008179328368138201,0.0008176670726076318,0.0008174006857123985,0.0008171336763309851,0.0008168660446667308,0.000816597790923449,0.0008163289153054265,0.0008160594180174237,0.0008157892992646746,0.0008155185592528863,0.0008152471981882391,0.0008149752162773864,0.0008147026137274541,0.0008144293907460411,0.0008141555475412182,0.0008138810843215294,0.0008136060012959899,0.0008133302986740878,0.0008130539766657824,0.0008127770354815051,0.0008124994753321583,0.0008122212964291166,0.0008119424989842251,0.0008116630832098002,0.000811383049318629,0.0008111023975239699,0.0008108211280395511,0.0008105392410795717,0.0008102567368587007,0.0008099736155920776,0.0008096898774953115,0.0008094055227844811,0.0008091205516761352,0.0008088349643872914,0.0008085487611354371,0.0008082619421385283,0.0008079745076149903,0.0008076864577837169,0.0008073977928640707,0.0008071085130758825,0.0008068186186394514,0.0008065281097755447,0.0008062369867053975,0.0008059452496507127,0.0008056528988336608,0.0008053599344768796,0.0008050663568034743,0.0008047721660370167,0.0008044773624015464,0.000804181946121569,0.0008038859174220567,0.0008035892765284483,0.0008032920236666489,0.0008029941590630293,0.0008026956829444264,0.0008023965955381427,0.0008020968970719463,0.0008017965877740708,0.0008014956678732146,0.0008011941375985413,0.0008008919971796794,0.0008005892468467219,0.0008002858868302264,0.0007999819173612147,0.000799677338671173,0.0007993721509920508,0.000799066354556262,0.0007987599495966841,0.0007984529363466574,0.0007981453150399863,0.0007978370859109374,0.0007975282491942408,0.000797218805125089,0.0007969087539391373,0.000796598095872503,0.0007962868311617657,0.000795974960043967,0.0007956624827566107,0.0007953493995376613,0.0007950357106255456,0.0007947214162591515,0.0007944065166778275,0.0007940910121213833,0.0007937749028300897,0.0007934581890446774,0.0007931408710063378,0.0007928229489567225,0.0007925044231379428,0.0007921852937925701,0.0007918655611636351,0.0007915452254946282,0.0007912242870294991,0.0007909027460126562,0.000790580602688967,0.0007902578573037579,0.0007899345101028132,0.000789610561332376,0.0007892860112391474,0.0007889608600702864,0.0007886351080734097,0.0007883087554965918,0.0007879818025883641,0.0007876542495977158,0.0007873260967740924,0.0007869973443673969,0.0007866679926279883,0.0007863380418066823,0.000786007492154751,0.0007856763439239221,0.0007853445973663796,0.0007850122527347627,0.0007846793102821665,0.0007843457702621411,0.0007840116329286916,0.0007836768985362782,0.0007833415673398158,0.0007830056395946736,0.0007826691155566753,0.0007823319954820985,0.0007819942796276747,0.0007816559682505894,0.0007813170616084814,0.0007809775599594427,0.0007806374635620187,0.0007802967726752075,0.0007799554875584602,0.0007796136084716802,0.0007792711356752233,0.0007789280694298973,0.0007785844099969623,0.0007782401576381297,0.0007778953126155627,0.0007775498751918759,0.0007772038456301347,0.0007768572241938558,0.0007765100111470066,0.0007761622067540048,0.0007758138112797187,0.0007754648249894665,0.0007751152481490165,0.0007747650810245865,0.0007744143238828442,0.0007740629769909064,0.000773711040616339,0.0007733585150271568,0.0007730054004918234,0.000772651697279251,0.0007722974056587999,0.0007719425259002786,0.0007715870582739433,0.0007712310030504983,0.0007708743605010951,0.0007705171308973324,0.0007701593145112562,0.0007698009116153591,0.0007694419224825807,0.0007690823473863067,0.0007687221866003692,0.0007683614403990463,0.0007680001090570619,0.0007676381928495857,0.0007672756920522325,0.0007669126069410622,0.0007665489377925803,0.0007661846848837366,0.0007658198484919254,0.0007654544288949854,0.0007650884263712,0.0007647218411992953,0.0007643546736584426,0.0007639869240282554,0.0007636185925887913,0.0007632496796205506,0.0007628801854044768,0.0007625101102219555,0.0007621394543548154,0.0007617682180853266,0.0007613964016962022,0.0007610240054705962,0.0007606510296921046,0.0007602774746447647,0.0007599033406130549,0.0007595286278818947,0.0007591533367366438,0.0007587774674631031,0.0007584010203475133,0.000758023995676555,0.0007576463937373492,0.0007572682148174561,0.0007568894592048754,0.0007565101271880459,0.0007561302190558456,0.0007557497350975908,0.0007553686756030368,0.0007549870408623769,0.0007546048311662428,0.0007542220468057033,0.0007538386880722659,0.0007534547552578746,0.000753070248654911,0.0007526851685561936,0.0007522995152549778,0.0007519132890449553,0.0007515264902202538,0.000751139119075438,0.0007507511759055075,0.0007503626610058982,0.0007499735746724807,0.0007495839172015615,0.0007491936888898814,0.0007488028900346168,0.0007484115209333774,0.0007480195818842082,0.0007476270731855875,0.000747233995136428,0.0007468403480360758,0.0007464461321843102,0.0007460513478813435,0.0007456559954278213,0.0007452600751248218,0.0007448635872738554,0.0007444665321768648,0.000744068910136225,0.0007436707214547422,0.0007432719664356544,0.000742872645382631,0.0007424727585997725,0.0007420723063916098,0.0007416712890631049,0.0007412697069196497,0.0007408675602670667,0.0007404648494116077,0.0007400615746599551,0.0007396577363192198,0.0007392533346969424,0.0007388483701010922,0.0007384428428400673,0.0007380367532226947,0.0007376301015582289,0.0007372228881563532,0.000736815113327178,0.0007364067773812417,0.00073599788062951,0.0007355884233833754,0.0007351784059546574,0.0007347678286556024,0.0007343566917988823,0.0007339449956975963,0.0007335327406652684,0.0007331199270158491,0.0007327065550637138,0.0007322926251236634,0.0007318781375109233,0.0007314630925411438,0.0007310474905304,0.0007306313317951909,0.0007302146166524392,0.0007297973454194917,0.0007293795184141187,0.0007289611359545137,0.0007285421983592929,0.0007281227059474957,0.0007277026590385836,0.0007272820579524409,0.0007268609030093734,0.0007264391945301091,0.000726016932835797,0.0007255941182480083,0.0007251707510887341,0.0007247468316803874,0.0007243223603458011,0.0007238973374082282,0.0007234717631913428,0.0007230456380192378,0.0007226189622164262,0.0007221917361078401,0.0007217639600188308,0.0007213356342751683,0.0007209067592030415,0.0007204773351290573,0.0007200473623802408,0.0007196168412840348,0.0007191857721683002,0.0007187541553613146,0.000718321991191773,0.0007178892799887876,0.0007174560220818862,0.000717022217801014,0.0007165878674765314,0.0007161529714392156,0.0007157175300202585,0.0007152815435512677,0.000714845012364266,0.0007144079367916908,0.0007139703171663941,0.0007135321538216425,0.0007130934470911161,0.0007126541973089095,0.0007122144048095305,0.0007117740699278998,0.0007113331929993522,0.0007108917743596341,0.0007104498143449052,0.0007100073132917374,0.0007095642715371145,0.0007091206894184318,0.0007086765672734966,0.0007082319054405273,0.000707786704258153,0.0007073409640654137,0.0007068946852017604,0.0007064478680070535,0.0007060005128215639,0.0007055526199859718,0.0007051041898413674,0.0007046552227292495,0.0007042057189915263,0.0007037556789705142,0.0007033051030089386,0.0007028539914499323,0.0007024023446370365,0.0007019501629142,0.000701497446625779,0.0007010441961165363,0.0007005904117316421,0.0007001360938166728,0.0006996812427176115,0.0006992258587808468,0.0006987699423531735,0.0006983134937817918,0.0006978565134143073,0.0006973990015987302,0.0006969409586834758,0.0006964823850173635,0.0006960232809496172,0.0006955636468298649,0.0006951034830081376,0.0006946427898348702,0.0006941815676609006,0.0006937198168374694,0.0006932575377162203,0.0006927947306491985,0.0006923313959888522,0.0006918675340880305,0.0006914031452999845,0.0006909382299783667,0.00069047278847723,0.0006900068211510287,0.000689540328354617,0.0006890733104432493,0.0006886057677725803,0.0006881377006986641,0.0006876691095779539,0.0006871999947673026,0.0006867303566239611,0.0006862601955055796,0.000685789511770206,0.0006853183057762866,0.0006848465778826652,0.0006843743284485833,0.0006839015578336791,0.0006834282663979881,0.0006829544545019423,0.0006824801225063701,0.000682005270772496,0.0006815298996619403,0.0006810540095367185,0.000680577600759242,0.0006801006736923163,0.0006796232286991427,0.0006791452661433161,0.0006786667863888256,0.0006781877898000545,0.0006777082767417796,0.0006772282475791708,0.0006767477026777914,0.0006762666424035969,0.000675785067122936,0.000675302977202549,0.0006748203730095685,0.0006743372549115185,0.0006738536232763144,0.0006733694784722627,0.0006728848208680608,0.0006723996508327968,0.0006719139687359483,0.0006714277749473837,0.0006709410698373606,0.000670453853776526,0.0006699661271359163,0.0006694778902869566,0.0006689891436014602,0.0006684998874516295,0.0006680101222100536,0.0006675198482497107,0.0006670290659439654,0.0006665377756665697,0.0006660459777916628,0.0006655536726937702,0.0006650608607478034,0.0006645675423290603,0.0006640737178132241,0.0006635793875763641,0.0006630845519949337,0.0006625892114457722,0.0006620933663061026,0.000661597016953533,0.0006611001637660545,0.000660602807122043,0.0006601049474002567,0.0006596065849798378,0.0006591077202403106,0.0006586083535615826,0.0006581084853239432,0.0006576081159080636,0.0006571072456949971,0.0006566058750661781,0.0006561040044034222,0.0006556016340889256,0.0006550987645052652,0.0006545953960353983,0.0006540915290626614,0.0006535871639707715,0.0006530823011438244,0.0006525769409662953,0.0006520710838230376,0.000651564730099284,0.0006510578801806444,0.0006505505344531075,0.0006500426933030388,0.0006495343571171814,0.0006490255262826558,0.0006485162011869585,0.0006480063822179629,0.0006474960697639181,0.0006469852642134494,0.0006464739659555574,0.000645962175379618,0.0006454498928753819,0.0006449371188329747,0.0006444238536428958,0.0006439100976960193,0.0006433958513835926,0.0006428811150972366,0.0006423658892289454,0.0006418501741710859,0.0006413339703163974,0.000640817278057992,0.000640300097789353,0.0006397824299043357,0.0006392642747971669,0.000638745632862444,0.0006382265044951354,0.0006377068900905803,0.0006371867900444872,0.0006366662047529352,0.0006361451346123726,0.000635623580019617,0.0006351015413718548,0.0006345790190666413,0.0006340560135018998,0.0006335325250759219,0.0006330085541873666,0.000632484101235261,0.0006319591666189982,0.0006314337507383394,0.0006309078539934109,0.0006303814767847067,0.0006298546195130856,0.0006293272825797722,0.0006287994663863568,0.0006282711713347942,0.0006277423978274042,0.0006272131462668707,0.0006266834170562418,0.0006261532105989294,0.0006256225272987087,0.0006250913675597182,0.0006245597317864592,0.0006240276203837952,0.0006234950337569525,0.0006229619723115187,0.0006224284364534437,0.0006218944265890378,0.000621359943124973,0.0006208249864682816,0.0006202895570263565,0.0006197536552069503,0.0006192172814181758,0.0006186804360685047,0.0006181431195667684,0.0006176053323221565,0.0006170670747442175,0.0006165283472428581,0.0006159891502283424,0.0006154494841112927,0.0006149093493026881,0.0006143687462138647,0.0006138276752565154,0.000613286136842689,0.0006127441313847909,0.0006122016592955816,0.0006116587209881773,0.0006111153168760492,0.000610571447373023,0.0006100271128932791,0.0006094823138513519,0.0006089370506621295,0.0006083913237408535,0.0006078451335031188,0.0006072984803648731,0.0006067513647424162,0.0006062037870524009,0.000605655747711831,0.0006051072471380626,0.0006045582857488027,0.0006040088639621092,0.0006034589821963907,0.0006029086408704061,0.0006023578404032643,0.0006018065812144237,0.0006012548637236922,0.0006007026883512269,0.0006001500555175331,0.0005995969656434647,0.000599043419150224,0.0005984894164593604,0.0005979349579927712,0.0005973800441727007,0.0005968246754217398,0.000596268852162826,0.0005957125748192431,0.00059515584381462,0.0005945986595729321,0.000594041022518499,0.000593482933075986,0.0005929243916704023,0.0005923653987271013,0.0005918059546717806,0.0005912460599304814,0.0005906857149295874,0.0005901249200958262,0.0005895636758562671,0.0005890019826383222,0.0005884398408697452,0.0005878772509786318,0.0005873142133934182,0.0005867507285428824,0.0005861867968561424,0.0005856224187626569,0.0005850575946922241,0.0005844923250749825,0.0005839266103414092,0.0005833604509223205,0.0005827938472488718,0.0005822267997525561,0.0005816593088652049,0.000581091375018987,0.0005805229986464091,0.0005799541801803143,0.0005793849200538825,0.0005788152187006303,0.0005782450765544099,0.0005776744940494094,0.000577103471620152,0.0005765320097014965,0.0005759601087286358,0.0005753877691370974,0.0005748149913627426,0.000574241775841767,0.0005736681230106989,0.0005730940333063999,0.0005725195071660642,0.0005719445450272186,0.0005713691473277217,0.0005707933145057639,0.0005702170469998669,0.0005696403452488836,0.0005690632096919975,0.000568485640768722,0.0005679076389189016,0.0005673292045827094,0.0005667503382006485,0.0005661710402135506,0.0005655913110625767,0.0005650111511892154,0.0005644305610352839,0.0005638495410429268,0.0005632680916546162,0.0005626862133131508,0.0005621039064616567,0.0005615211715435855,0.0005609380090027154,0.0005603544192831501,0.0005597704028293183,0.0005591859600859743,0.0005586010914981963,0.0005580157975113874,0.0005574300785712743,0.0005568439351239076,0.0005562573676156609,0.000555670376493231,0.0005550829622036371,0.0005544951251942207,0.0005539068659126455,0.000553318184806896,0.000552729082325279,0.0005521395589164214,0.000551549615029271,0.0005509592511130957,0.0005503684676174833,0.0005497772649923412,0.000549185643687896,0.0005485936041546926,0.0005480011468435956,0.0005474082722057863,0.0005468149806927649,0.0005462212727563488,0.000545627148848672,0.0005450326094221861,0.0005444376549296585,0.0005438422858241731,0.0005432465025591292,0.0005426503055882419,0.0005420536953655409,0.0005414566723453708,0.0005408592369823909,0.000540261389731574,0.0005396631310482069,0.0005390644613878894,0.0005384653812065347,0.0005378658909603684,0.0005372659911059283,0.0005366656821000643,0.0005360649643999379,0.0005354638384630216,0.000534862304747099,0.0005342603637102642,0.0005336580158109215,0.0005330552615077851,0.0005324521012598785,0.0005318485355265346,0.0005312445647673948,0.0005306401894424092,0.0005300354100118359,0.0005294302269362407,0.0005288246406764969,0.0005282186516937849,0.0005276122604495913,0.0005270054674057097,0.0005263982730242394,0.0005257906777675852,0.0005251826820984573,0.0005245742864798711,0.000523965491375146,0.0005233562972479063,0.0005227467045620795,0.0005221367137818972,0.0005215263253718938,0.0005209155397969066,0.0005203043575220755,0.0005196927790128423,0.0005190808047349505,0.0005184684351544455,0.0005178556707376731,0.0005172425119512801,0.0005166289592622136,0.0005160150131377206,0.000515400674045348,0.0005147859424529416,0.0005141708188286462,0.0005135553036409051,0.0005129393973584603,0.0005123231004503507,0.0005117064133859137,0.0005110893366347829,0.0005104718706668895,0.0005098540159524603,0.0005092357729620189,0.0005086171421663839,0.0005079981240366697,0.0005073787190442855,0.0005067589276609354,0.0005061387503586172,0.0005055181876096231,0.0005048972398865383,0.0005042759076622419,0.000503654191409905,0.0005030320916029922,0.0005024096087152589,0.0005017867432207532,0.0005011634955938143,0.0005005398663090723,0.000499915855841448,0.0004992914646661527,0.0004986666932586872,0.0004980415420948422,0.0004974160116506975,0.0004967901024026219,0.0004961638148272723,0.0004955371494015941,0.00049491010660282,0.0004942826869084707,0.0004936548907963535,0.0004930267187445625,0.0004923981712314777,0.0004917692487357658,0.0004911399517363783,0.0004905102807125526,0.0004898802361438103,0.0004892498185099578,0.0004886190282910858,0.000487987865967568,0.0004873563320200624,0.0004867244269295093,0.000486092151177132,0.0004854595052444361,0.0004848264896132089,0.0004841931047655194,0.0004835593511837176,0.00048292522935043447,0.00048229073974858153,0.0004816558828613499,0.0004810206591722111,0.00048038506916491517,0.0004797491133234919,0.00047911279213224913,0.0004784761060757733,0.00047783905563892834,0.000477201641306856,0.00047656386356497506,0.00047592572289898095,0.0004752872197948454,0.00047464835473881654,0.0004740091282174177,0.00047336954071744794,0.0004727295927259807,0.00047208928473036437,0.0004714486172182214,0.00047080759067744766,0.000470166205596213,0.00046952446246296015,0.0004688823617664042,0.00046823990399553274,0.0004675970896396056,0.00046695391918815364,0.0004663103931309792,0.00046566651195815523,0.0004650222761600255,0.00046437768622720356,0.00046373274265057256,0.00046308744592128486,0.0004624417965307625,0.0004617957949706954,0.00046114944173304175,0.0004605027373100275,0.0004598556821941466,0.0004592082768781594,0.0004585605218550933,0.00045791241761824195,0.00045726396466116466,0.00045661516347768696,0.000455966014561899,0.00045531651840815586,0.0004546666755110771,0.0004540164863655465,0.00045336595146671136,0.0004527150713099822,0.0004520638463910324,0.0004514122772057985,0.0004507603642504786,0.00045010810802153275,0.00044945550901568217,0.0004488025677299099,0.0004481492846614588,0.0004474956603078325,0.00044684169516679404,0.0004461873897363669,0.00044553274451483265,0.0004448777600007324,0.00044422243669286506,0.0004435667750902881,0.00044291077569231623,0.0004422544389985215,0.00044159776550873285,0.000440940755723036,0.00044028341014177213,0.0004396257292655386,0.0004389677135951878,0.0004383093636318278,0.0004376506798768203,0.0004369916628317819,0.00043633231299858234,0.00043567263087934574,0.0004350126169764484,0.00043435227179251974,0.00043369159583044113,0.0004330305895933463,0.00043236925358462026,0.000431707588307899,0.00043104559426706933,0.00043038327196626884,0.00042972062190988456,0.0004290576446025534,0.00042839434054916137,0.00042773071025484314,0.00042706675422498247,0.0004264024729652106,0.00042573786698140657,0.00042507293677969654,0.00042440768286645426,0.0004237421057482991,0.0004230762059320973,0.00042240998392496017,0.00042174344023424514,0.00042107657536755405,0.0004204093898327335,0.00041974188413787414,0.00041907405879131087,0.0004184059143016217,0.00041773745117762765,0.00041706866992839226,0.000416399571063222,0.00041573015509166445,0.0004150604225235091,0.00041439037386878624,0.0004137200096377674,0.0004130493303409639,0.0004123783364891272,0.0004117070285932482,0.0004110354071645574,0.0004103634727145235,0.00040969122575485394,0.00040901866679749366,0.000408345796354626,0.000407672614938671,0.0004069991230622854,0.00040632532123836254,0.0004056512099800321,0.000404976789800659,0.0004043020612138435,0.0004036270247334206,0.00040295168087346034,0.00040227603014826623,0.0004016000730723757,0.00040092381016055927,0.0004002472419278209,0.00039957036888939665,0.0003988931915607547,0.00039821571045759504,0.00039753792609584893,0.00039685983899167887,0.00039618144966147755,0.00039550275862186807,0.00039482376638970277,0.0003941444734820643,0.0003934648804162636,0.0003927849877098402,0.000392104795880562,0.0003914243054464248,0.0003907435169256516,0.0003900624308366926,0.00038938104769822406,0.0003886993680291494,0.00038801739234859713,0.0003873351211759214,0.00038665255503070117,0.0003859696944327406,0.00038528653990206764,0.00038460309195893414,0.0003839193511238153,0.0003832353179174098,0.0003825509928606385,0.0003818663764746447,0.0003811814692807935,0.0003804962718006718,0.00037981078455608705,0.00037912500806906767,0.00037843894286186214,0.00037775258945693923,0.0003770659483769868,0.00037637902014491187,0.00037569180528384,0.0003750043043171156,0.00037431651776830027,0.0003736284461611735,0.0003729400900197316,0.00037225144986818793,0.0003715625262309719,0.00037087331963272873,0.000370183830598319,0.0003694940596528191,0.0003688040073215194,0.00036811367412992467,0.00036742306060375354,0.0003667321672689386,0.00036604099465162505,0.0003653495432781709,0.0003646578136751464,0.00036396580636933356,0.00036327352188772645,0.00036258096075752957,0.0003618881235061584,0.0003611950106612385,0.00036050162275060575,0.000359807960302305,0.0003591140238445905,0.0003584198139059247,0.0003577253310149792,0.00035703057570063266,0.00035633554849197146,0.00035564024991828887,0.00035494468050908544,0.00035424884079406733,0.0003535527313031467,0.0003528563525664411,0.00035215970511427345,0.00035146278947717106,0.00035076560618586545,0.0003500681557712919,0.00034937043876458944,0.0003486724556970999,0.0003479742071003677,0.0003472756935061393,0.0003465769154463637,0.00034587787345319044,0.00034517856805897044,0.00034447899979625507,0.00034377916919779624,0.0003430790767965453,0.00034237872312565306,0.0003416781087184691,0.0003409772341085422,0.00034027609982961856,0.00033957470641564255,0.0003388730544007555,0.0003381711443192964,0.0003374689767058,0.00033676655209499755,0.00033606387102181587,0.0003353609340213773,0.000334657741628999,0.00033395429438019244,0.00033325059281066324,0.0003325466374563107,0.0003318424288532278,0.00033113796753769976,0.0003304332540462045,0.00032972828891541205,0.00032902307268218407,0.0003283176058835734,0.00032761188905682366,0.0003269059227393688,0.0003261997074688331,0.0003254932437830301,0.0003247865322199627,0.0003240795733178222,0.000323372367614989,0.00032266491565003075,0.00032195721796170293,0.000321249275088948,0.00032054108757089556,0.000319832655946861,0.00031912398075634586,0.00031841506253903694,0.0003177059018348067,0.00031699649918371156,0.0003162868551259926,0.0003155769702020745,0.0003148668449525658,0.0003141564799182576,0.00031344587564012376,0.0003127350326593202,0.0003120239515171851,0.00031131263275523753,0.0003106010769151777,0.0003098892845388861,0.00030917725616842393,0.0003084649923460317,0.0003077524936141291,0.000307039760515315,0.0003063267935923668,0.00030561359338823963,0.00030490016044606663,0.0003041864953091578,0.00030347259852100045,0.000302758470625258,0.0003020441121657698,0.0003013295236865507,0.00030061470573179136,0.0002998996588458565,0.00029918438357328547,0.00029846888045879146,0.0002977531500472611,0.00029703719288375454,0.0002963210095135042,0.0002956046004819147,0.0002948879663345627,0.00029417110761719654,0.0002934540248757351,0.0002927367186562682,0.00029201918950505544,0.00029130143796852695,0.00029058346459328145,0.00028986526992608695,0.00028914685451387974,0.0002884282189037648,0.0002877093636430142,0.0002869902892790675,0.00028627099635953094,0.00028555148543217774,0.00028483175704494657,0.00028411181174594187,0.00028339165008343313,0.0002826712726058552,0.0002819506798618067,0.0002812298724000503,0.00028050885076951203,0.00027978761551928163,0.000279066167198611,0.0002783445063569143,0.00027762263354376746,0.0002769005493089086,0.00027617825420223584,0.00027545574877380844,0.0002747330335738456,0.0002740101091527266,0.00027328697606098976,0.0002725636348493324,0.00027184008606861,0.000271116330269837,0.0002703923680041846,0.0002696681998229815,0.00026894382627771325,0.0002682192479200221,0.0002674944653017058,0.0002667694789747179,0.00026604428949116694,0.0002653188974033161,0.00026459330326358344,0.00026386750762454026,0.0002631415110389115,0.0002624153140595749,0.0002616889172395614,0.0002609623211320538,0.00026023552629038637,0.000259508533268045,0.0002587813426186668,0.0002580539548960389,0.0002573263706540987,0.0002565985904469332,0.00025587061482877876,0.00025514244435402057,0.00025441407957719196,0.00025368552105297433,0.00025295676933619694,0.0002522278249818358,0.0002514986885450137,0.00025076936058099965,0.000250039841645209,0.0002493101322932019,0.00024858023308068375,0.0002478501445635044,0.0002471198672976584,0.00024638940183928343,0.0002456587487446608,0.0002449279085702143,0.000244196881872511,0.00024346566920825936,0.0002427342711343095,0.00024200268820765284,0.00024127092098542185,0.00024053897002488902,0.0002398068358834668,0.00023907451911870693,0.00023834202028830096,0.00023760933995007846,0.00023687647866200723,0.00023614343698219294,0.00023541021546887904,0.0002346768146804455,0.00023394323517540884,0.00023320947751242178,0.00023247554225027254,0.00023174142994788514,0.00023100714116431782,0.0002302726764587634,0.00022953803639054856,0.00022880322151913403,0.0002280682324041131,0.000227333069605212,0.00022659773368228893,0.0002258622251953346,0.0002251265447044705,0.00022439069276994936,0.00022365466995215424,0.0002229184768115989,0.00022218211390892629,0.00022144558180490874,0.0002207088810604473,0.00021997201223657208,0.0002192349758944405,0.00021849777259533778,0.00021776040290067615,0.00021702286737199507,0.00021628516657095975,0.00021554730105936143,0.00021480927139911664,0.00021407107815226738,0.0002133327218809798,0.00021259420314754428,0.00021185552251437478,0.00021111668054400913,0.00021037767779910743,0.00020963851484245242,0.00020889919223694863,0.00020815971054562282,0.00020742007033162222,0.00020668027215821507,0.00020594031658878966,0.00020520020418685468,0.0002044599355160378,0.0002037195111400858,0.00020297893162286382,0.0002022381975283558,0.00020149730942066276,0.00020075626786400324,0.0002000150734227124,0.0001992737266612425,0.00019853222814416108,0.00019779057843615156,0.00019704877810201247,0.00019630682770665678,0.00019556472781511242,0.00019482247899252057,0.00019408008180413593,0.0001933375368153261,0.00019259484459157182,0.00019185200569846525,0.00019110902070171057,0.000190365890167123,0.00018962261466062906,0.00018887919474826532,0.00018813563099617827,0.00018739192397062397,0.00018664807423796794,0.000185904082364684,0.0001851599489173543,0.00018441567446266863,0.00018367125956742476,0.00018292670479852684,0.00018218201072298568,0.00018143717790791803,0.00018069220692054687,0.00017994709832819985,0.0001792018526983095,0.0001784564705984127,0.00017771095259615065,0.00017696529925926758,0.0001762195111556109,0.00017547358885313055,0.0001747275329198792,0.00017398134392401066,0.00017323502243378036,0.00017248856901754434,0.00017174198424375976,0.0001709952686809832,0.00017024842289787106,0.0001695014474631787,0.00016875434294576078,0.00016800710991456968,0.00016725974893865592,0.00016651226058716711,0.00016576464542934863,0.00016501690403454168,0.00016426903697218387,0.00016352104481180853,0.00016277292812304404,0.00016202468747561415,0.0001612763234393365,0.00016052783658412285,0.0001597792274799783,0.00015903049669700164,0.00015828164480538373,0.00015753267237540787,0.00015678357997744895,0.0001560343681819738,0.0001552850375595396,0.00015453558868079427,0.00015378602211647547,0.00015303633843741116,0.00015228653821451783,0.00015153662201880104,0.00015078659042135442,0.00015003644399335994,0.00014928618330608664,0.00014853580893089057,0.0001477853214392144,0.0001470347214025873,0.00014628400939262367,0.00014553318598102335,0.00014478225173957088,0.00014403120724013567,0.00014328005305467068,0.0001425287897552124,0.0001417774179138804,0.00014102593810287733,0.00014027435089448764,0.00013952265686107763,0.00013877085657509485,0.00013801895060906825,0.00013726693953560682,0.00013651482392739968,0.00013576260435721533,0.00013501028139790216,0.0001342578556223866,0.00013350532760367362,0.00013275269791484582,0.00013199996712906387,0.0001312471358195648,0.0001304942045596624,0.0001297411739227464,0.00012898804448228276,0.0001282348168118121,0.0001274814914849501,0.00012672806907538674,0.00012597455015688576,0.00012522093530328501,0.00012446722508849476,0.00012371342008649815,0.00012295952087135027,0.00012220552801717855,0.00012145144209818118,0.00012069726368862738,0.00011994299336285661,0.00011918863169527894,0.00011843417926037338,0.0001176796366326883,0.00011692500438684054,0.00011617028309751573,0.00011541547333946684,0.00011466057568751428,0.00011390559071654527,0.00011315051900151411,0.00011239536111744055,0.00011164011763941018,0.00011088478914257356,0.00011012937620214657,0.00010937387939340888,0.00010861829929170411,0.00010786263647243924,0.00010710689151108472,0.00010635106498317307,0.00010559515746429904,0.00010483916953011887,0.0001040831017563507,0.00010332695471877281,0.00010257072899322405,0.00010181442515560302,0.00010105804378186838,0.00010030158544803727,9.95450507301856e-05,9.87884402044473e-05,9.803175444701457e-05,9.727499403413633e-05,9.651815954211854e-05,9.576125154732344e-05,9.500427062616975e-05,9.424721735513117e-05,9.349009231073673e-05,9.273289606957007e-05,9.197562920826887e-05,9.121829230352517e-05,9.046088593208378e-05,8.970341067074262e-05,8.894586709635183e-05,8.818825578581418e-05,8.743057731608348e-05,8.667283226416481e-05,8.591502120711382e-05,8.515714472203696e-05,8.439920338608998e-05,8.364119777647815e-05,8.288312847045553e-05,8.212499604532527e-05,8.136680107843798e-05,8.060854414719213e-05,7.985022582903314e-05,7.909184670145383e-05,7.833340734199265e-05,7.757490832823419e-05,7.681635023780824e-05,7.605773364839019e-05,7.529905913769936e-05,7.45403272834994e-05,7.378153866359745e-05,7.302269385584441e-05,7.226379343813341e-05,7.150483798840017e-05,7.074582808462206e-05,6.998676430481854e-05,6.92276472270495e-05,6.84684774294156e-05,6.770925549005751e-05,6.69499819871561e-05,6.619065749893103e-05,6.543128260364089e-05,6.467185787958252e-05,6.391238390509128e-05,6.315286125853943e-05,6.239329051833652e-05,6.16336722629285e-05,6.087400707079809e-05,6.0114295520463224e-05,5.9354538190477286e-05,5.8594735659428504e-05,5.783488850593941e-05,5.707499730866702e-05,5.631506264630135e-05,5.5555085097565705e-05,5.479506524121585e-05,5.403500365604038e-05,5.327490092085903e-05,5.251475761452311e-05,5.1754574315914615e-05,5.09943516039466e-05,5.023409005756152e-05,4.947379025573163e-05,4.8713452777458084e-05,4.795307820177136e-05,4.7192667107729576e-05,4.6432220074418845e-05,4.5671737680952486e-05,4.49112205064713e-05,4.415066913014201e-05,4.3390084131157576e-05,4.262946608873636e-05,4.186881558212249e-05,4.1108133190584206e-05,4.034741949341425e-05,3.958667506992899e-05,3.88259004994688e-05,3.806509636139641e-05,3.7304263235097254e-05,3.6543401699978686e-05,3.578251233547023e-05,3.5021595721022054e-05,3.426065243610526e-05,3.349968306021106e-05,3.273868817285113e-05,3.197766835355599e-05,3.121662418187533e-05,3.04555562373772e-05,2.9694465099648343e-05,2.893335134829256e-05,2.8172215562931106e-05,2.7411058323201777e-05,2.6649880208759312e-05,2.5888681799273773e-05,2.5127463674430857e-05,2.4366226413931085e-05,2.3604970597490136e-05,2.2843696804837227e-05,2.208240561571548e-05,2.1321097609881245e-05,2.0559773367103495e-05,1.979843346716415e-05,1.903707848985646e-05,1.8275709014985368e-05,1.751432562236665e-05,1.675292889182728e-05,1.5991519403203776e-05,1.5230097736342602e-05,1.4468664471099282e-05,1.3707220187338758e-05,1.2945765464933781e-05,1.2184300883765245e-05,1.1422827023721365e-05,1.0661344464697992e-05,9.899853786597028e-06,9.138355569326752e-06,8.376850392800988e-06,7.615338836939439e-06,6.8538214816660904e-06,6.092298906909536e-06,5.3307716926021465e-06,4.569240418680413e-06,3.8077056650833337e-06,3.0461680117527496e-06,2.28462803863252e-06,1.5230863256688491e-06,7.61543452808685e-07,5.34352970478275e-20,-7.615434528087718e-07 };
  const int TrigonometricLookupTable::kSamples = 1800;
  const int TrigonometricLookupTable::kTableSize = 1802;
  const double TrigonometricLookupTable::kSamplesOverPiHalf =
      1145.9155902616465;

} }  // v8::internal
