/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.clirr.core.ClassFilter;
import org.apache.bcel.classfile.JavaClass;

public final class ClassSelector
implements ClassFilter {
    public static final Mode MODE_IF = new Mode();
    public static final Mode MODE_UNLESS = new Mode();
    private Mode mode;
    private ArrayList packages = new ArrayList();
    private ArrayList packageTrees = new ArrayList();
    private ArrayList classes = new ArrayList();

    public ClassSelector(Mode mode) {
        this.mode = mode;
    }

    public void addPackage(String packageName) {
        this.packages.add(packageName);
    }

    public void addPackageTree(String packageName) {
        this.packages.add(packageName);
    }

    public void addClass(String classname) {
        this.classes.add(classname);
    }

    public boolean isSelected(JavaClass clazz) {
        if (this.isAnonymousInnerClass(clazz)) {
            return false;
        }
        boolean matches = this.matchesCriteria(clazz);
        if (this.mode == MODE_IF) {
            return matches;
        }
        return !matches;
    }

    private boolean isAnonymousInnerClass(JavaClass clazz) {
        String name = clazz.getClassName();
        int dollarPos = name.indexOf(36);
        if (dollarPos == -1) {
            return false;
        }
        for (int i = dollarPos + 1; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesCriteria(JavaClass clazz) {
        String packageName = clazz.getPackageName();
        if (this.packages.contains(packageName)) {
            return true;
        }
        Iterator i = this.packageTrees.iterator();
        while (i.hasNext()) {
            String entry = (String)i.next();
            if (!packageName.startsWith(entry)) continue;
            if (packageName.length() == entry.length()) {
                return true;
            }
            if (packageName.charAt(entry.length()) != '.') continue;
            return true;
        }
        String className = clazz.getClassName();
        Iterator i2 = this.classes.iterator();
        while (i2.hasNext()) {
            String entry = (String)i2.next();
            if (!className.startsWith(entry)) continue;
            if (className.length() == entry.length()) {
                return true;
            }
            if (className.charAt(entry.length()) != '$') continue;
            return true;
        }
        return false;
    }

    public static final class Mode {
        private Mode() {
        }
    }
}

