/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.ant;

import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListenerAdapter;
import net.sf.clirr.core.Severity;

final class ChangeCounter
extends DiffListenerAdapter {
    private int binInfos = 0;
    private int binWarnings = 0;
    private int binErrors = 0;
    private int srcInfos = 0;
    private int srcWarnings = 0;
    private int srcErrors = 0;

    public int getBinInfos() {
        return this.binInfos;
    }

    public int getBinWarnings() {
        return this.binWarnings;
    }

    public int getBinErrors() {
        return this.binErrors;
    }

    public int getSrcInfos() {
        return this.srcInfos;
    }

    public int getSrcWarnings() {
        return this.srcWarnings;
    }

    public int getSrcErrors() {
        return this.srcErrors;
    }

    public void reportDiff(ApiDifference difference) {
        Severity binSeverity = difference.getBinaryCompatibilitySeverity();
        if (Severity.ERROR.equals(binSeverity)) {
            ++this.binErrors;
        } else if (Severity.WARNING.equals(binSeverity)) {
            ++this.binWarnings;
        } else if (Severity.INFO.equals(binSeverity)) {
            ++this.binInfos;
        }
        Severity srcSeverity = difference.getSourceCompatibilitySeverity();
        if (Severity.ERROR.equals(srcSeverity)) {
            ++this.srcErrors;
        } else if (Severity.WARNING.equals(srcSeverity)) {
            ++this.srcWarnings;
        } else if (Severity.INFO.equals(srcSeverity)) {
            ++this.srcInfos;
        }
    }
}

