/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.enum;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Enum
implements Comparable,
Serializable {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static final Map cEnumClasses = new HashMap();
    private final String iName;
    static /* synthetic */ Class class$org$apache$commons$lang$enum$Enum;

    protected Enum(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The Enum name must not be empty");
        }
        this.iName = name;
        Entry entry = (Entry)cEnumClasses.get(this.getClass().getName());
        if (entry == null) {
            entry = new Entry();
            cEnumClasses.put(this.getClass().getName(), entry);
        }
        if (entry.map.containsKey(name)) {
            throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
        }
        entry.map.put(name, this);
        entry.list.add(this);
    }

    protected Object readResolve() {
        return Enum.getEnum(this.getClass(), this.getName());
    }

    protected static Enum getEnum(Class enumClass, String name) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass.getName());
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(name);
    }

    protected static Map getEnumMap(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!(class$org$apache$commons$lang$enum$Enum == null ? (class$org$apache$commons$lang$enum$Enum = Enum.class$("org.apache.commons.lang.enum.Enum")) : class$org$apache$commons$lang$enum$Enum).isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass.getName());
        if (entry == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(entry.map);
    }

    protected static List getEnumList(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!(class$org$apache$commons$lang$enum$Enum == null ? (class$org$apache$commons$lang$enum$Enum = Enum.class$("org.apache.commons.lang.enum.Enum")) : class$org$apache$commons$lang$enum$Enum).isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass.getName());
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(entry.list);
    }

    protected static Iterator iterator(Class enumClass) {
        return Enum.getEnumList(enumClass).iterator();
    }

    public final String getName() {
        return this.iName;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.iName.equals(((Enum)other).iName);
        }
        if (other.getClass().getName().equals(this.getClass().getName())) {
            try {
                return this.iName.equals(((Enum)other).iName);
            }
            catch (ClassCastException ex) {
                try {
                    Method mth = other.getClass().getMethod("getName", null);
                    String name = (String)mth.invoke(other, null);
                    return this.iName.equals(name);
                }
                catch (NoSuchMethodException ex2) {
                }
                catch (IllegalAccessException ex2) {
                }
                catch (InvocationTargetException ex2) {
                    // empty catch block
                }
                return false;
            }
        }
        return false;
    }

    public final int hashCode() {
        return 7 + this.iName.hashCode();
    }

    public int compareTo(Object other) {
        return this.iName.compareTo(((Enum)other).iName);
    }

    public String toString() {
        String shortName = this.getClass().getName();
        int pos = shortName.lastIndexOf(46);
        if (pos != -1) {
            shortName = shortName.substring(pos + 1);
        }
        return shortName + "[" + this.getName() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Entry {
        final Map map = new HashMap(50);
        final List list = new ArrayList(25);

        private Entry() {
        }
    }
}

