/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import net.sf.clirr.core.Message;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Method;
import net.sf.clirr.core.spi.Scope;

public final class ClassModifierCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_MODIFIER_UNABLE_TO_DETERMINE_CLASS_SCOPE = new Message(3000);
    private static final Message MSG_MODIFIER_REMOVED_FINAL = new Message(3001);
    private static final Message MSG_MODIFIER_ADDED_FINAL_TO_EFFECTIVE_FINAL = new Message(3002);
    private static final Message MSG_MODIFIER_ADDED_FINAL = new Message(3003);
    private static final Message MSG_MODIFIER_REMOVED_ABSTRACT = new Message(3004);
    private static final Message MSG_MODIFIER_ADDED_ABSTRACT = new Message(3005);

    public ClassModifierCheck(ApiDiffDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean check(JavaType compatBaseLine, JavaType currentVersion) {
        String className = compatBaseLine.getName();
        Scope currentScope = currentVersion.getEffectiveScope();
        if (currentScope.isLessVisibleThan(Scope.PACKAGE)) {
            return true;
        }
        boolean currentIsFinal = currentVersion.isFinal();
        boolean compatIsFinal = compatBaseLine.isFinal();
        boolean currentIsAbstract = currentVersion.isAbstract();
        boolean compatIsAbstract = compatBaseLine.isAbstract();
        boolean currentIsInterface = currentVersion.isInterface();
        boolean compatIsInterface = compatBaseLine.isInterface();
        if (compatIsFinal && !currentIsFinal) {
            this.log(MSG_MODIFIER_REMOVED_FINAL, Severity.INFO, className, null, null, null);
        } else if (!compatIsFinal && currentIsFinal) {
            if (this.isEffectivelyFinal(compatBaseLine)) {
                this.log(MSG_MODIFIER_ADDED_FINAL_TO_EFFECTIVE_FINAL, Severity.INFO, className, null, null, null);
            } else {
                this.log(MSG_MODIFIER_ADDED_FINAL, this.getSeverity(compatBaseLine, Severity.ERROR), className, null, null, null);
            }
        }
        if (compatIsAbstract && !currentIsAbstract && !compatIsInterface) {
            this.log(MSG_MODIFIER_REMOVED_ABSTRACT, Severity.INFO, className, null, null, null);
        } else if (!compatIsAbstract && currentIsAbstract && !currentIsInterface) {
            this.log(MSG_MODIFIER_ADDED_ABSTRACT, this.getSeverity(compatBaseLine, Severity.ERROR), className, null, null, null);
        }
        return true;
    }

    private boolean isEffectivelyFinal(JavaType clazz) {
        if (clazz.isFinal()) {
            return true;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.equals("<init>") || !method.getEffectiveScope().isMoreVisibleThan(Scope.PACKAGE)) continue;
            return false;
        }
        return true;
    }
}

