/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.ant;

import java.io.File;
import java.util.List;
import net.sf.clirr.core.ClassFilter;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

class PatternSetFilter
implements ClassFilter {
    private final Project project;
    private final List patternSets;

    public PatternSetFilter(Project project, List patternSets) {
        this.project = project;
        this.patternSets = patternSets;
    }

    public boolean isSelected(JavaClass clazz) {
        String className = clazz.getClassName();
        String name = className.replace('.', File.separatorChar);
        if (this.patternSets == null || this.patternSets.isEmpty()) {
            return true;
        }
        boolean included = false;
        block0: for (int i = 0; i < this.patternSets.size(); ++i) {
            PatternSet p = (PatternSet)this.patternSets.get(i);
            p.getIncludePatterns(this.project);
            String[] incls = p.getIncludePatterns(this.project);
            if (incls == null || incls.length == 0) {
                incls = new String[]{"**"};
            }
            for (int w = 0; w < incls.length; ++w) {
                String pattern = incls[w].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                if (included = SelectorUtils.matchPath((String)pattern, (String)name)) break;
            }
            if (!included) break;
            String[] excls = p.getExcludePatterns(this.project);
            if (excls == null) continue;
            for (int w = 0; w < excls.length; ++w) {
                String pattern = excls[w].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                boolean bl = included = !SelectorUtils.matchPath((String)pattern, (String)name);
                if (!included) continue block0;
            }
        }
        this.project.log("included " + className + " = " + included, 3);
        return included;
    }
}

