/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableSortedSetTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAsList() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testAsList();
}

public void testAsListInconsistentComprator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testAsListInconsistentComprator();
}

public void testBuilderAddAll() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderAddAll();
}

public void testBuilderAddAllHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderAddAllHandlesNullsCorrectly();
}

public void testBuilderAddHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderAddHandlesNullsCorrectly();
}

public void testBuilderGenerics_SelfComparable() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderGenerics_SelfComparable();
}

public void testBuilderGenerics_SuperComparable() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderGenerics_SuperComparable();
}

public void testBuilderMethod() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderMethod();
}

public void testBuilderWithDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderWithDuplicateElements();
}

public void testBuilderWithNonDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testBuilderWithNonDuplicateElements();
}

public void testComplexBuilder() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testComplexBuilder();
}

public void testContainsAll_differentComparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testContainsAll_differentComparator();
}

public void testContainsAll_notSortedSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testContainsAll_notSortedSet();
}

public void testContainsAll_sameComparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testContainsAll_sameComparator();
}

public void testContainsAll_sameComparator_StringVsInt() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testContainsAll_sameComparator_StringVsInt();
}

public void testContainsAll_sameType() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testContainsAll_sameType();
}

public void testCopyOfExplicit_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfExplicit_comparator();
}

public void testCopyOfExplicit_iterator_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfExplicit_iterator_comparator();
}

public void testCopyOfExplicit_iterator_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfExplicit_iterator_ordering();
}

public void testCopyOfExplicit_iterator_ordering_dupes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfExplicit_iterator_ordering_dupes();
}

public void testCopyOfExplicit_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfExplicit_ordering();
}

public void testCopyOfExplicit_ordering_dupes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfExplicit_ordering_dupes();
}

public void testCopyOfSorted_explicit_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfSorted_explicit_ordering();
}

public void testCopyOfSorted_natural_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfSorted_natural_comparator();
}

public void testCopyOfSorted_natural_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOfSorted_natural_ordering();
}

public void testCopyOf_arrayContainingOnlyNull() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_arrayContainingOnlyNull();
}

public void testCopyOf_arrayOfOneElement() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_arrayOfOneElement();
}

public void testCopyOf_collectionContainingNull() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_collectionContainingNull();
}

public void testCopyOf_collection_empty() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_collection_empty();
}

public void testCopyOf_collection_enumSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_collection_enumSet();
}

public void testCopyOf_collection_general() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_collection_general();
}

public void testCopyOf_collection_oneElement() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_collection_oneElement();
}

public void testCopyOf_collection_oneElementRepeated() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_collection_oneElementRepeated();
}

public void testCopyOf_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_comparator();
}

public void testCopyOf_emptyArray() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_emptyArray();
}

public void testCopyOf_headSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_headSet();
}

public void testCopyOf_iteratorContainingNull() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iteratorContainingNull();
}

public void testCopyOf_iterator_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_comparator();
}

public void testCopyOf_iterator_empty() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_empty();
}

public void testCopyOf_iterator_general() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_general();
}

public void testCopyOf_iterator_oneElement() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_oneElement();
}

public void testCopyOf_iterator_oneElementRepeated() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_oneElementRepeated();
}

public void testCopyOf_iterator_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_ordering();
}

public void testCopyOf_iterator_ordering_dupes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_iterator_ordering_dupes();
}

public void testCopyOf_nullArray() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_nullArray();
}

public void testCopyOf_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_ordering();
}

public void testCopyOf_ordering_dupes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_ordering_dupes();
}

public void testCopyOf_plainIterable() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_plainIterable();
}

public void testCopyOf_plainIterable_iteratesOnce() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_plainIterable_iteratesOnce();
}

public void testCopyOf_shortcut_empty() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_shortcut_empty();
}

public void testCopyOf_shortcut_sameType() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_shortcut_sameType();
}

public void testCopyOf_shortcut_singleton() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_shortcut_singleton();
}

public void testCopyOf_sortedSetIterable() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_sortedSetIterable();
}

public void testCopyOf_sortedSet_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_sortedSet_comparator();
}

public void testCopyOf_sortedSet_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_sortedSet_ordering();
}

public void testCopyOf_subSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_subSet();
}

public void testCopyOf_tailSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCopyOf_tailSet();
}

public void testCreation_eightElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_eightElements();
}

public void testCreation_fiveElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_fiveElements();
}

public void testCreation_fourElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_fourElements();
}

public void testCreation_noArgs() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_noArgs();
}

public void testCreation_oneElement() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_oneElement();
}

public void testCreation_sevenElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_sevenElements();
}

public void testCreation_sixElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_sixElements();
}

public void testCreation_threeElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_threeElements();
}

public void testCreation_twoElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testCreation_twoElements();
}

public void testEmpty_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEmpty_comparator();
}

public void testEmpty_first() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEmpty_first();
}

public void testEmpty_headSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEmpty_headSet();
}

public void testEmpty_last() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEmpty_last();
}

public void testEmpty_subSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEmpty_subSet();
}

public void testEmpty_tailSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEmpty_tailSet();
}

public void testEquals_bothDefaultOrdering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEquals_bothDefaultOrdering();
}

public void testEquals_bothDefaultOrdering_StringVsInt() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEquals_bothDefaultOrdering_StringVsInt();
}

public void testEquals_bothExplicitOrdering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEquals_bothExplicitOrdering();
}

public void testEquals_bothExplicitOrdering_StringVsInt() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEquals_bothExplicitOrdering_StringVsInt();
}

public void testEquals_sameType() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testEquals_sameType();
}

public void testExplicit_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_comparator();
}

public void testExplicit_contains() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_contains();
}

public void testExplicit_containsMismatchedTypes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_containsMismatchedTypes();
}

public void testExplicit_first() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_first();
}

public void testExplicit_headSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_headSet();
}

public void testExplicit_last() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_last();
}

public void testExplicit_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_ordering();
}

public void testExplicit_ordering_dupes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_ordering_dupes();
}

public void testExplicit_subSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_subSet();
}

public void testExplicit_tailSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testExplicit_tailSet();
}

public void testHeadSetExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testHeadSetExclusive();
}

public void testHeadSetInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testHeadSetInclusive();
}

public void testLegacyComparable_builder_natural() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testLegacyComparable_builder_natural();
}

public void testLegacyComparable_builder_reverse() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testLegacyComparable_builder_reverse();
}

public void testLegacyComparable_copyOf_collection() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testLegacyComparable_copyOf_collection();
}

public void testLegacyComparable_copyOf_iterator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testLegacyComparable_copyOf_iterator();
}

public void testLegacyComparable_of() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testLegacyComparable_of();
}

public void testOf_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_comparator();
}

public void testOf_first() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_first();
}

public void testOf_gwtArraycopyBug() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_gwtArraycopyBug();
}

public void testOf_headSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_headSet();
}

public void testOf_last() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_last();
}

public void testOf_ordering() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_ordering();
}

public void testOf_ordering_dupes() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_ordering_dupes();
}

public void testOf_subSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_subSet();
}

public void testOf_tailSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testOf_tailSet();
}

public void testReuseBuilderWithDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testReuseBuilderWithDuplicateElements();
}

public void testReuseBuilderWithNonDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testReuseBuilderWithNonDuplicateElements();
}

public void testReverseOrder() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testReverseOrder();
}

public void testSingle_comparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSingle_comparator();
}

public void testSingle_first() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSingle_first();
}

public void testSingle_headSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSingle_headSet();
}

public void testSingle_last() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSingle_last();
}

public void testSingle_subSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSingle_subSet();
}

public void testSingle_tailSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSingle_tailSet();
}

public void testSubSetExclusiveExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSubSetExclusiveExclusive();
}

public void testSubSetExclusiveInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSubSetExclusiveInclusive();
}

public void testSubSetInclusiveExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSubSetInclusiveExclusive();
}

public void testSubSetInclusiveInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSubSetInclusiveInclusive();
}

public void testSubsetAsList() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSubsetAsList();
}

public void testSupertypeComparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSupertypeComparator();
}

public void testSupertypeComparatorSubtypeElements() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testSupertypeComparatorSubtypeElements();
}

public void testTailSetExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testTailSetExclusive();
}

public void testTailSetInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testTailSetInclusive();
}

public void testToImmutableSortedSet() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testToImmutableSortedSet();
}

public void testToImmutableSortedSet_customComparator() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testToImmutableSortedSet_customComparator();
}

public void testToImmutableSortedSet_duplicates() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testToImmutableSortedSet_duplicates();
}

public void testToString() throws Exception {
  com.google.common.collect.ImmutableSortedSetTest testCase = new com.google.common.collect.ImmutableSortedSetTest();
  testCase.testToString();
}
}
