/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.ContextSupport;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Predicate;
import org.xmlpull.v1.builder.xpath.jaxen.function.BooleanFunction;

class PredicateSet
implements Serializable {
    private List predicates = Collections.EMPTY_LIST;

    public void addPredicate(Predicate predicate) {
        if (this.predicates == Collections.EMPTY_LIST) {
            this.predicates = new ArrayList();
        }
        this.predicates.add(predicate);
    }

    public List getPredicates() {
        return this.predicates;
    }

    public void simplify() {
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            eachPred.simplify();
        }
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            buf.append(eachPred.getText());
        }
        return buf.toString();
    }

    protected boolean evaluateAsBoolean(List contextNodeSet, ContextSupport support) throws JaxenException {
        List result = this.evaluatePredicates(contextNodeSet, support);
        return !result.isEmpty();
    }

    protected List evaluatePredicates(List contextNodeSet, ContextSupport support) throws JaxenException {
        if (this.predicates.size() == 0) {
            return contextNodeSet;
        }
        ArrayList newNodeSet = new ArrayList();
        ArrayList filterSet = contextNodeSet;
        List predicates = this.getPredicates();
        Iterator predIter = predicates.iterator();
        Predicate eachPred = null;
        Object contextNode = null;
        Object predResult = null;
        Context predContext = new Context(support);
        if (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            int filterSize = filterSet.size();
            for (int i = 0; i < filterSize; ++i) {
                contextNode = filterSet.get(i);
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(contextNode);
                predContext.setNodeSet(list);
                predContext.setPosition(i + 1);
                predContext.setSize(filterSize);
                predResult = eachPred.evaluate(predContext);
                if (predResult instanceof Number) {
                    int proximity = ((Number)predResult).intValue();
                    if (proximity != i + 1) continue;
                    newNodeSet.add(contextNode);
                    continue;
                }
                Boolean includes = BooleanFunction.evaluate(predResult, predContext.getNavigator());
                if (!includes.booleanValue()) continue;
                newNodeSet.add(contextNode);
            }
        }
        boolean nodesFiltered = false;
        filterSet = newNodeSet;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            int filterSize = filterSet.size();
            for (int i = 0; i < filterSize; ++i) {
                contextNode = filterSet.get(i);
                if (contextNode == null) continue;
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(contextNode);
                predContext.setNodeSet(list);
                predContext.setPosition(i + 1);
                predContext.setSize(filterSize);
                predResult = eachPred.evaluate(predContext);
                if (predResult instanceof Number) {
                    int proximity = ((Number)predResult).intValue();
                    if (proximity == i + 1) continue;
                    filterSet.set(i, null);
                    nodesFiltered = true;
                    continue;
                }
                Boolean includes = BooleanFunction.evaluate(predResult, predContext.getNavigator());
                if (includes.booleanValue()) continue;
                filterSet.set(i, null);
                nodesFiltered = true;
            }
        }
        if (nodesFiltered) {
            Iterator iter = filterSet.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj != null) continue;
                iter.remove();
            }
        }
        return filterSet;
    }
}

