/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Hashtable;
import org.apache.xerces.dom.DeferredAttrImpl;
import org.apache.xerces.dom.DeferredAttrNSImpl;
import org.apache.xerces.dom.DeferredCDATASectionImpl;
import org.apache.xerces.dom.DeferredCommentImpl;
import org.apache.xerces.dom.DeferredDocumentTypeImpl;
import org.apache.xerces.dom.DeferredElementDefinitionImpl;
import org.apache.xerces.dom.DeferredElementImpl;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.apache.xerces.dom.DeferredEntityImpl;
import org.apache.xerces.dom.DeferredEntityReferenceImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.DeferredNotationImpl;
import org.apache.xerces.dom.DeferredProcessingInstructionImpl;
import org.apache.xerces.dom.DeferredTextImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeferredDocumentImpl
extends DocumentImpl
implements DeferredNode {
    static final long serialVersionUID = 5186323580749626857L;
    private static final boolean DEBUG_PRINT_REF_COUNTS = false;
    private static final boolean DEBUG_PRINT_TABLES = false;
    private static final boolean DEBUG_IDS = false;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    protected static final int CHUNK_MASK = 2047;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    protected transient int fNodeCount;
    protected transient int[][] fNodeType;
    protected transient int[][] fNodeName;
    protected transient int[][] fNodeValue;
    protected transient int[][] fNodeParent;
    protected transient int[][] fNodeFirstChild;
    protected transient int[][] fNodeNextSib;
    protected transient int fIdCount;
    protected transient int[] fIdName;
    protected transient int[] fIdElement;
    protected transient StringPool fStringPool;
    protected boolean fNamespacesEnabled = false;

    public DeferredDocumentImpl(StringPool stringPool) {
        this(stringPool, false);
    }

    public DeferredDocumentImpl(StringPool stringPool, boolean bl) {
        this(stringPool, bl, false);
    }

    public DeferredDocumentImpl(StringPool stringPool, boolean bl, boolean bl2) {
        super(bl2);
        this.fStringPool = stringPool;
        this.syncData = true;
        this.syncChildren = true;
        this.fNamespacesEnabled = bl;
    }

    boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public int createDocument() {
        int n = this.createNode((short)9);
        return n;
    }

    public int createDocumentType(int n, int n2, int n3) {
        int n4 = this.createNode((short)10);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        int n7 = this.createNode((short)0);
        int n8 = n7 >> 11;
        int n9 = n7 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n5, n6);
        this.setChunkIndex(this.fNodeValue, n7, n5, n6);
        this.setChunkIndex(this.fNodeName, n2, n8, n9);
        this.setChunkIndex(this.fNodeValue, n3, n8, n9);
        return n4;
    }

    public void setInternalSubset(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = this.fNodeValue[n3][n4];
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        this.fNodeFirstChild[n6][n7] = n2;
    }

    public int createNotation(int n, int n2, int n3) throws Exception {
        int n4 = this.createNode((short)12);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        int n7 = this.createNode((short)0);
        int n8 = n7 >> 11;
        int n9 = n7 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n5, n6);
        this.setChunkIndex(this.fNodeValue, n7, n5, n6);
        this.setChunkIndex(this.fNodeName, n2, n8, n9);
        this.setChunkIndex(this.fNodeValue, n3, n8, n9);
        return n4;
    }

    public int createEntity(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.createNode((short)6);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        int n8 = this.createNode((short)0);
        int n9 = n8 >> 11;
        int n10 = n8 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n6, n7);
        this.setChunkIndex(this.fNodeValue, n8, n6, n7);
        this.setChunkIndex(this.fNodeName, n2, n9, n10);
        this.setChunkIndex(this.fNodeValue, n3, n9, n10);
        this.setChunkIndex(this.fNodeFirstChild, n4, n9, n10);
        return n5;
    }

    public int createEntityReference(int n) throws Exception {
        int n2 = this.createNode((short)5);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n3, n4);
        return n2;
    }

    public int createElement(int n, XMLAttrList xMLAttrList, int n2) {
        int n3 = this.createNode((short)1);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n4, n5);
        if (n2 != -1) {
            int n6 = xMLAttrList.getFirstAttr(n2);
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = n6;
            while (n10 != -1) {
                int n11 = this.createAttribute(xMLAttrList.getAttrName(n10), xMLAttrList.getAttValue(n10), xMLAttrList.isSpecified(n10));
                int n12 = n11 >> 11;
                int n13 = n11 & 0x7FF;
                this.setChunkIndex(this.fNodeParent, n3, n12, n13);
                if (n10 == n6) {
                    this.setChunkIndex(this.fNodeValue, n11, n4, n5);
                } else {
                    this.setChunkIndex(this.fNodeNextSib, n11, n8, n9);
                }
                n7 = n11;
                n8 = n12;
                n9 = n13;
                n10 = xMLAttrList.getNextAttr(n10);
            }
        }
        return n3;
    }

    public int createAttribute(int n, int n2, boolean bl) {
        int n3 = this.createNode((short)2);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n4, n5);
        this.setChunkIndex(this.fNodeValue, bl ? 1 : 0, n4, n5);
        int n6 = this.createTextNode(n2, false);
        this.appendChild(n3, n6);
        return n3;
    }

    public int createElementDefinition(int n) {
        int n2 = this.createNode((short)-1);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n3, n4);
        return n2;
    }

    public int createTextNode(int n, boolean bl) {
        int n2 = this.createNode((short)3);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeValue, n, n3, n4);
        this.setChunkIndex(this.fNodeFirstChild, bl ? 1 : 0, n3, n4);
        return n2;
    }

    public int createCDATASection(int n, boolean bl) {
        int n2 = this.createNode((short)4);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeValue, n, n3, n4);
        this.setChunkIndex(this.fNodeFirstChild, bl ? 1 : 0, n3, n4);
        return n2;
    }

    public int createProcessingInstruction(int n, int n2) {
        int n3 = this.createNode((short)7);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n4, n5);
        this.setChunkIndex(this.fNodeValue, n2, n4, n5);
        return n3;
    }

    public int createComment(int n) {
        int n2 = this.createNode((short)8);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeValue, n, n3, n4);
        return n2;
    }

    public void appendChild(int n, int n2) {
        int n3;
        int n4 = n >> 11;
        int n5 = n & 0x7FF;
        int n6 = n2 >> 11;
        int n7 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeParent, n, n6, n7);
        int n8 = -1;
        int n9 = this.getChunkIndex(this.fNodeFirstChild, n4, n5);
        while (n9 != -1) {
            n8 = n9;
            n3 = this.getChunkIndex(this.fNodeNextSib, n9 >> 11, n9 & 0x7FF);
            if (n3 == -1) break;
            n9 = n3;
        }
        if (n8 == -1) {
            this.setChunkIndex(this.fNodeFirstChild, n2, n4, n5);
            return;
        }
        n3 = n8 >> 11;
        int n10 = n8 & 0x7FF;
        this.setChunkIndex(this.fNodeNextSib, n2, n3, n10);
    }

    public int setAttributeNode(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        String string = this.fStringPool.toString(this.getChunkIndex(this.fNodeName, n5, n6));
        int n7 = this.getChunkIndex(this.fNodeValue, n3, n4);
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        while (n7 != -1) {
            n9 = n7 >> 11;
            n10 = n7 & 0x7FF;
            String string2 = this.fStringPool.toString(this.getChunkIndex(this.fNodeName, n9, n10));
            if (string2.equals(string)) break;
            n8 = n7;
            n7 = this.getChunkIndex(this.fNodeNextSib, n9, n10);
        }
        if (n7 != -1) {
            int n11;
            int n12;
            int n13 = this.getChunkIndex(this.fNodeNextSib, n9, n10);
            if (n8 == -1) {
                this.setChunkIndex(this.fNodeValue, n13, n3, n4);
            } else {
                n12 = n8 >> 11;
                n11 = n8 & 0x7FF;
                this.setChunkIndex(this.fNodeNextSib, n13, n12, n11);
            }
            this.clearChunkIndex(this.fNodeType, n9, n10);
            this.clearChunkIndex(this.fNodeName, n9, n10);
            this.clearChunkIndex(this.fNodeValue, n9, n10);
            this.clearChunkIndex(this.fNodeParent, n9, n10);
            this.clearChunkIndex(this.fNodeNextSib, n9, n10);
            n12 = this.clearChunkIndex(this.fNodeFirstChild, n9, n10);
            n11 = n12 >> 11;
            int n14 = n12 & 0x7FF;
            this.clearChunkIndex(this.fNodeType, n11, n14);
            this.clearChunkIndex(this.fNodeValue, n11, n14);
            this.clearChunkIndex(this.fNodeParent, n11, n14);
            this.clearChunkIndex(this.fNodeFirstChild, n11, n14);
        }
        int n15 = this.getChunkIndex(this.fNodeValue, n3, n4);
        this.setChunkIndex(this.fNodeValue, n2, n3, n4);
        this.setChunkIndex(this.fNodeNextSib, n15, n5, n6);
        return n7;
    }

    public int insertBefore(int n, int n2, int n3) {
        if (n3 == -1) {
            this.appendChild(n, n2);
            return n2;
        }
        int n4 = n >> 11;
        int n5 = n & 0x7FF;
        int n6 = n2 >> 11;
        int n7 = n2 & 0x7FF;
        int n8 = this.getChunkIndex(this.fNodeFirstChild, n4, n5);
        if (n8 == n3) {
            this.setChunkIndex(this.fNodeFirstChild, n2, n4, n5);
        }
        int n9 = -1;
        int n10 = this.getChunkIndex(this.fNodeFirstChild, n4, n5);
        while (n10 != -1) {
            if (n10 == n3) break;
            n9 = n10;
            n10 = this.getChunkIndex(this.fNodeNextSib, n10 >> 11, n10 & 0x7FF);
        }
        if (n9 != -1) {
            int n11 = n9 >> 11;
            int n12 = n9 & 0x7FF;
            this.setChunkIndex(this.fNodeNextSib, n2, n11, n12);
        }
        this.setChunkIndex(this.fNodeNextSib, n3, n6, n7);
        return n2;
    }

    public void setAsFirstChild(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeFirstChild, n2, n3, n4);
        int n7 = n2;
        while (n7 != -1) {
            n2 = n7;
            n7 = this.getChunkIndex(this.fNodeNextSib, n5, n6);
            n5 = n7 >> 11;
            n6 = n7 & 0x7FF;
        }
    }

    public int getParentNode(int n) {
        return this.getParentNode(n, false);
    }

    public int getParentNode(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return this.clearChunkIndex(this.fNodeParent, n2, n3);
        }
        return this.getChunkIndex(this.fNodeParent, n2, n3);
    }

    public int getFirstChild(int n) {
        return this.getFirstChild(n, true);
    }

    public int getFirstChild(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return this.clearChunkIndex(this.fNodeFirstChild, n2, n3);
        }
        return this.getChunkIndex(this.fNodeFirstChild, n2, n3);
    }

    public int getNextSibling(int n) {
        return this.getNextSibling(n, true);
    }

    public int getNextSibling(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        n = bl ? this.clearChunkIndex(this.fNodeNextSib, n2, n3) : this.getChunkIndex(this.fNodeNextSib, n2, n3);
        while (n != -1 && this.getChunkIndex(this.fNodeType, n2, n3) == 3) {
            n = this.getChunkIndex(this.fNodeNextSib, n2, n3);
            n2 = n >> 11;
            n3 = n & 0x7FF;
        }
        return n;
    }

    public int getRealNextSibling(int n) {
        return this.getRealNextSibling(n, true);
    }

    public int getRealNextSibling(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return this.clearChunkIndex(this.fNodeNextSib, n2, n3);
        }
        return this.getChunkIndex(this.fNodeNextSib, n2, n3);
    }

    public int lookupElementDefinition(int n) {
        if (this.fNodeCount > 1) {
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.getChunkIndex(this.fNodeFirstChild, n3, n4);
            while (n5 != -1) {
                n3 = n5 >> 11;
                n4 = n5 & 0x7FF;
                if (this.getChunkIndex(this.fNodeType, n3, n4) == 10) {
                    n2 = n5;
                    break;
                }
                n5 = this.getChunkIndex(this.fNodeNextSib, n3, n4);
            }
            if (n2 == -1) {
                return -1;
            }
            n3 = n2 >> 11;
            n4 = n2 & 0x7FF;
            int n6 = this.getChunkIndex(this.fNodeFirstChild, n3, n4);
            while (n6 != -1) {
                n3 = n6 >> 11;
                n4 = n6 & 0x7FF;
                if (this.getChunkIndex(this.fNodeName, n3, n4) == n) {
                    return n6;
                }
                n6 = this.getChunkIndex(this.fNodeNextSib, n3, n4);
            }
        }
        return -1;
    }

    public DeferredNode getNodeObject(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.clearChunkIndex(this.fNodeType, n2, n3);
        this.clearChunkIndex(this.fNodeParent, n2, n3);
        NodeImpl nodeImpl = null;
        switch (n4) {
            case 2: {
                if (this.fNamespacesEnabled) {
                    nodeImpl = new DeferredAttrNSImpl(this, n);
                    break;
                }
                nodeImpl = new DeferredAttrImpl(this, n);
                break;
            }
            case 4: {
                nodeImpl = new DeferredCDATASectionImpl(this, n);
                break;
            }
            case 8: {
                nodeImpl = new DeferredCommentImpl(this, n);
                break;
            }
            case 9: {
                nodeImpl = this;
                break;
            }
            case 10: {
                nodeImpl = new DeferredDocumentTypeImpl(this, n);
                this.docType = (DocumentTypeImpl)nodeImpl;
                break;
            }
            case 1: {
                nodeImpl = this.fNamespacesEnabled ? new DeferredElementNSImpl(this, n) : new DeferredElementImpl(this, n);
                if (this.docElement == null) {
                    this.docElement = (ElementImpl)nodeImpl;
                }
                if (this.fIdElement == null) break;
                int n5 = DeferredDocumentImpl.binarySearch(this.fIdElement, 0, this.fIdCount - 1, n);
                while (n5 != -1) {
                    int n6 = this.fIdName[n5];
                    if (n6 != -1) {
                        String string = this.fStringPool.toString(n6);
                        this.putIdentifier0(string, (Element)((Object)nodeImpl));
                        this.fIdName[n5] = -1;
                    }
                    if (n5 + 1 < this.fIdCount && this.fIdElement[n5 + 1] == n) {
                        ++n5;
                        continue;
                    }
                    n5 = -1;
                }
                break;
            }
            case 6: {
                nodeImpl = new DeferredEntityImpl(this, n);
                break;
            }
            case 5: {
                nodeImpl = new DeferredEntityReferenceImpl(this, n);
                break;
            }
            case 12: {
                nodeImpl = new DeferredNotationImpl(this, n);
                break;
            }
            case 7: {
                nodeImpl = new DeferredProcessingInstructionImpl(this, n);
                break;
            }
            case 3: {
                nodeImpl = new DeferredTextImpl(this, n);
                break;
            }
            case -1: {
                nodeImpl = new DeferredElementDefinitionImpl(this, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("type: " + n4);
            }
        }
        if (nodeImpl != null) {
            return nodeImpl;
        }
        throw new IllegalArgumentException();
    }

    public String getNodeNameString(int n) {
        return this.getNodeNameString(n, true);
    }

    public String getNodeNameString(int n, boolean bl) {
        int n2;
        if (n == -1) {
            return null;
        }
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 = bl ? this.clearChunkIndex(this.fNodeName, n3, n4) : this.getChunkIndex(this.fNodeName, n3, n4);
        if (n2 == -1) {
            return null;
        }
        return this.fStringPool.toString(n2);
    }

    public String getNodeValueString(int n) {
        return this.getNodeValueString(n, true);
    }

    public String getNodeValueString(int n, boolean bl) {
        int n2;
        if (n == -1) {
            return null;
        }
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 = bl ? this.clearChunkIndex(this.fNodeValue, n3, n4) : this.getChunkIndex(this.fNodeValue, n3, n4);
        if (n2 == -1) {
            return null;
        }
        return this.fStringPool.toString(n2);
    }

    public int getNodeName(int n) {
        return this.getNodeName(n, true);
    }

    public int getNodeName(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return this.clearChunkIndex(this.fNodeName, n2, n3);
        }
        return this.getChunkIndex(this.fNodeName, n2, n3);
    }

    public int getNodeValue(int n) {
        return this.getNodeValue(n, true);
    }

    public int getNodeValue(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return this.clearChunkIndex(this.fNodeValue, n2, n3);
        }
        return this.getChunkIndex(this.fNodeValue, n2, n3);
    }

    public short getNodeType(int n) {
        return this.getNodeType(n, true);
    }

    public short getNodeType(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return (short)this.clearChunkIndex(this.fNodeType, n2, n3);
        }
        return (short)this.getChunkIndex(this.fNodeType, n2, n3);
    }

    public void putIdentifier(int n, int n2) {
        if (this.fIdName == null) {
            this.fIdName = new int[64];
            this.fIdElement = new int[64];
        }
        if (this.fIdCount == this.fIdName.length) {
            int[] nArray = new int[this.fIdCount * 2];
            System.arraycopy(this.fIdName, 0, nArray, 0, this.fIdCount);
            this.fIdName = nArray;
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(this.fIdElement, 0, nArray2, 0, this.fIdCount);
            this.fIdElement = nArray2;
        }
        this.fIdName[this.fIdCount] = n;
        this.fIdElement[this.fIdCount] = n2;
        ++this.fIdCount;
    }

    public void print() {
    }

    public int getNodeIndex() {
        return 0;
    }

    protected StringPool getStringPool() {
        return this.fStringPool;
    }

    protected void synchronizeData() {
        this.syncData = false;
        if (this.fIdElement != null) {
            IntVector intVector = new IntVector();
            int n = 0;
            while (n < this.fIdCount) {
                int n2 = this.fIdElement[n];
                int n3 = this.fIdName[n];
                if (n3 != -1) {
                    Node node;
                    int n4;
                    int n5;
                    intVector.removeAllElements();
                    int n6 = n2;
                    do {
                        intVector.addElement(n6);
                    } while ((n6 = this.getChunkIndex(this.fNodeParent, n5 = n6 >> 11, n4 = n6 & 0x7FF)) != -1);
                    Node node2 = this;
                    n4 = intVector.size() - 2;
                    while (n4 >= 0) {
                        n6 = intVector.elementAt(n4);
                        node = node2.getFirstChild();
                        while (node != null) {
                            int n7;
                            if (node instanceof DeferredNode && (n7 = ((DeferredNode)node).getNodeIndex()) == n6) {
                                node2 = node;
                                break;
                            }
                            node = node.getNextSibling();
                        }
                        --n4;
                    }
                    node = (Element)node2;
                    String string = this.fStringPool.toString(n3);
                    this.putIdentifier0(string, (Element)node);
                    this.fIdName[n] = -1;
                    while (this.fIdElement[n + 1] == n2) {
                        string = this.fStringPool.toString(this.fIdName[++n]);
                        this.putIdentifier0(string, (Element)node);
                    }
                }
                ++n;
            }
        }
    }

    protected void synchronizeChildren() {
        this.syncChildren = false;
        this.getNodeType(0);
        NodeImpl nodeImpl = null;
        int n = this.getFirstChild(0);
        while (n != -1) {
            NodeImpl nodeImpl2 = (NodeImpl)((Object)this.getNodeObject(n));
            if (nodeImpl == null) {
                this.firstChild = nodeImpl2;
            } else {
                nodeImpl.nextSibling = nodeImpl2;
            }
            nodeImpl2.parentNode = this;
            nodeImpl2.previousSibling = nodeImpl;
            nodeImpl = nodeImpl2;
            short s = nodeImpl2.getNodeType();
            if (s == 1) {
                this.docElement = (ElementImpl)nodeImpl2;
            } else if (s == 10) {
                this.docType = (DocumentTypeImpl)nodeImpl2;
            }
            n = this.getNextSibling(n);
        }
        if (nodeImpl != null) {
            this.lastChild = nodeImpl;
        }
    }

    protected boolean ensureCapacity(int n, int n2) {
        if (this.fNodeType == null) {
            this.fNodeType = new int[32][];
            this.fNodeName = new int[32][];
            this.fNodeValue = new int[32][];
            this.fNodeParent = new int[32][];
            this.fNodeFirstChild = new int[32][];
            this.fNodeNextSib = new int[32][];
        }
        try {
            return this.fNodeType[n][n2] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n3 = n * 2;
            int[][] nArray = new int[n3][];
            System.arraycopy(this.fNodeType, 0, nArray, 0, n);
            this.fNodeType = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeName, 0, nArray, 0, n);
            this.fNodeName = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeValue, 0, nArray, 0, n);
            this.fNodeValue = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeParent, 0, nArray, 0, n);
            this.fNodeParent = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeFirstChild, 0, nArray, 0, n);
            this.fNodeFirstChild = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeNextSib, 0, nArray, 0, n);
            this.fNodeNextSib = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.createChunk(this.fNodeType, n);
        this.createChunk(this.fNodeName, n);
        this.createChunk(this.fNodeValue, n);
        this.createChunk(this.fNodeParent, n);
        this.createChunk(this.fNodeFirstChild, n);
        this.createChunk(this.fNodeNextSib, n);
        return true;
    }

    protected int createNode(short s) {
        int n = this.fNodeCount >> 11;
        int n2 = this.fNodeCount & 0x7FF;
        this.ensureCapacity(n, n2);
        this.setChunkIndex(this.fNodeType, s, n, n2);
        return this.fNodeCount++;
    }

    protected static int binarySearch(int[] nArray, int n, int n2, int n3) {
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = nArray[n4];
            if (n5 == n3) {
                while (n4 > 0 && nArray[n4 - 1] == n3) {
                    --n4;
                }
                return n4;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            n = n4 + 1;
        }
        return -1;
    }

    private final void createChunk(int[][] nArray, int n) {
        nArray[n] = new int[2050];
        int n2 = 0;
        while (n2 < 2048) {
            nArray[n][n2] = -1;
            ++n2;
        }
    }

    private final int setChunkIndex(int[][] nArray, int n, int n2, int n3) {
        if (n == -1) {
            return this.clearChunkIndex(nArray, n2, n3);
        }
        int n4 = nArray[n2][n3];
        if (n4 == -1) {
            int[] nArray2 = nArray[n2];
            nArray2[2048] = nArray2[2048] + 1;
        }
        nArray[n2][n3] = n;
        return n4;
    }

    private final int getChunkIndex(int[][] nArray, int n, int n2) {
        if (nArray[n] != null) {
            return nArray[n][n2];
        }
        return -1;
    }

    private final int clearChunkIndex(int[][] nArray, int n, int n2) {
        int n3;
        int n4 = n3 = nArray[n] != null ? nArray[n][n2] : -1;
        if (n3 != -1) {
            int[] nArray2 = nArray[n];
            nArray2[2049] = nArray2[2049] + 1;
            nArray[n][n2] = -1;
            if (nArray[n][2048] == nArray[n][2049]) {
                nArray[n] = null;
            }
        }
        return n3;
    }

    private final void putIdentifier0(String string, Element element) {
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    private static void print(int[] nArray, int n, int n2, int n3, int n4) {
    }

    static class IntVector {
        private int[] data;
        private int size;

        public int size() {
            return this.size;
        }

        public int elementAt(int n) {
            return this.data[n];
        }

        public void addElement(int n) {
            this.ensureCapacity(this.size + 1);
            this.data[this.size++] = n;
        }

        public void removeAllElements() {
            this.size = 0;
        }

        private void ensureCapacity(int n) {
            if (this.data == null) {
                this.data = new int[n + 15];
                return;
            }
            if (n > this.data.length) {
                int[] nArray = new int[n + 15];
                System.arraycopy(this.data, 0, nArray, 0, this.data.length);
                this.data = nArray;
            }
        }

        IntVector() {
        }
    }
}

