/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.NamedNodeMap;

public class DeferredDocumentTypeImpl
extends DocumentTypeImpl
implements DeferredNode {
    static final long serialVersionUID = -2172579663227313509L;
    protected transient int fNodeIndex;

    DeferredDocumentTypeImpl(DeferredDocumentImpl deferredDocumentImpl, int n) {
        super(deferredDocumentImpl, null);
        this.fNodeIndex = n;
        this.syncData = true;
        this.syncChildren = true;
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        this.syncData = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        this.name = deferredDocumentImpl.getNodeNameString(this.fNodeIndex);
        StringPool stringPool = deferredDocumentImpl.getStringPool();
        int n = deferredDocumentImpl.getNodeValue(this.fNodeIndex);
        this.publicID = stringPool.toString(deferredDocumentImpl.getNodeName(n));
        this.systemID = stringPool.toString(deferredDocumentImpl.getNodeValue(n));
        this.internalSubset = stringPool.toString(deferredDocumentImpl.getFirstChild(n));
    }

    protected void synchronizeChildren() {
        this.syncChildren = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        this.entities = new NamedNodeMapImpl(deferredDocumentImpl, null);
        this.notations = new NamedNodeMapImpl(deferredDocumentImpl, null);
        this.elements = new NamedNodeMapImpl(deferredDocumentImpl, null);
        int n = deferredDocumentImpl.getFirstChild(this.fNodeIndex);
        while (n != -1) {
            DeferredNode deferredNode = deferredDocumentImpl.getNodeObject(n);
            short s = deferredNode.getNodeType();
            switch (s) {
                case 6: {
                    this.entities.setNamedItem(deferredNode);
                    break;
                }
                case 12: {
                    this.notations.setNamedItem(deferredNode);
                    break;
                }
                case -1: {
                    this.elements.setNamedItem(deferredNode);
                    NamedNodeMap namedNodeMap = deferredNode.getAttributes();
                    int n2 = deferredDocumentImpl.getFirstChild(deferredNode.getNodeIndex());
                    while (n2 != -1) {
                        DeferredNode deferredNode2 = deferredDocumentImpl.getNodeObject(n2);
                        namedNodeMap.setNamedItem(deferredNode2);
                        n2 = deferredDocumentImpl.getNextSibling(n2);
                    }
                    break;
                }
                case 1: {
                    if (((DocumentImpl)this.getOwnerDocument()).allowGrammarAccess) {
                        this.appendChild(deferredNode);
                        break;
                    }
                }
                default: {
                    System.out.println("DeferredDocumentTypeImpl#synchronizeInfo: node.getNodeType() = " + deferredNode.getNodeType() + ", class = " + deferredNode.getClass().getName());
                }
            }
            n = deferredDocumentImpl.getNextSibling(n);
        }
    }
}

