/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class XMLCharacterProperties {
    public static final byte[] fgAsciiXDigitChar;
    public static final byte[] fgAsciiAlphaChar;
    public static final byte[] fgAsciiEncNameChar;
    public static final byte[] fgAsciiPubidChar;
    public static final byte[] fgAsciiInitialNameChar;
    public static final byte[] fgAsciiNameChar;
    public static final byte[] fgAsciiInitialNCNameChar;
    public static final byte[] fgAsciiNCNameChar;
    public static final byte[] fgAsciiCharData;
    public static final byte[] fgAsciiWSCharData;
    public static final byte E_CharDataFlag = 1;
    public static final byte E_InitialNameCharFlag = 2;
    public static final byte E_NameCharFlag = 4;
    public static byte[] fgCharFlags;
    private static final char[] fgCharDataRanges;
    private static final char[] fgInitialNameCharRanges;
    private static final char[] fgNameCharRanges;

    public static boolean validVersionNum(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > 'z' || fgAsciiNameChar[c] == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean validEncName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c > 'z' || fgAsciiAlphaChar[c] == 0) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (c > 'z' || fgAsciiEncNameChar[c] == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int validPublicId(String string) {
        if (string.length() == 0) {
            return -1;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > 'z' || fgAsciiPubidChar[c] == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean validName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c > 'z' ? (fgCharFlags[c] & 2) == 0 : fgAsciiInitialNameChar[c] == 0) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (c > 'z' ? (fgCharFlags[c] & 4) == 0 : fgAsciiNameChar[c] == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean validNCName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c > 'z' ? (fgCharFlags[c] & 2) == 0 : fgAsciiInitialNCNameChar[c] == 0) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (c > 'z' ? (fgCharFlags[c] & 4) == 0 : fgAsciiNCNameChar[c] == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean validNmtoken(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > 'z' ? (fgCharFlags[c] & 4) == 0 : fgAsciiNameChar[c] == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static synchronized void initCharFlags() {
        if (fgCharFlags == null) {
            fgCharFlags = new byte[65536];
            XMLCharacterProperties.setFlagForRange(fgCharDataRanges, (byte)1);
            XMLCharacterProperties.setFlagForRange(fgInitialNameCharRanges, (byte)6);
            XMLCharacterProperties.setFlagForRange(fgNameCharRanges, (byte)4);
        }
    }

    private static void setFlagForRange(char[] cArray, byte by) {
        int n;
        int n2 = 0;
        while ((n = cArray[n2]) != 0) {
            char c = cArray[n2 + 1];
            while (n <= c) {
                int n3 = n++;
                fgCharFlags[n3] = (byte)(fgCharFlags[n3] | by);
            }
            n2 += 2;
        }
        ++n2;
        while ((n = cArray[n2]) != 0) {
            int n4 = n;
            fgCharFlags[n4] = (byte)(fgCharFlags[n4] | by);
            ++n2;
        }
    }

    static {
        byte[] byArray = new byte[128];
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[65] = 1;
        byArray[66] = 1;
        byArray[67] = 1;
        byArray[68] = 1;
        byArray[69] = 1;
        byArray[70] = 1;
        byArray[97] = 1;
        byArray[98] = 1;
        byArray[99] = 1;
        byArray[100] = 1;
        byArray[101] = 1;
        byArray[102] = 1;
        fgAsciiXDigitChar = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[65] = 1;
        byArray2[66] = 1;
        byArray2[67] = 1;
        byArray2[68] = 1;
        byArray2[69] = 1;
        byArray2[70] = 1;
        byArray2[71] = 1;
        byArray2[72] = 1;
        byArray2[73] = 1;
        byArray2[74] = 1;
        byArray2[75] = 1;
        byArray2[76] = 1;
        byArray2[77] = 1;
        byArray2[78] = 1;
        byArray2[79] = 1;
        byArray2[80] = 1;
        byArray2[81] = 1;
        byArray2[82] = 1;
        byArray2[83] = 1;
        byArray2[84] = 1;
        byArray2[85] = 1;
        byArray2[86] = 1;
        byArray2[87] = 1;
        byArray2[88] = 1;
        byArray2[89] = 1;
        byArray2[90] = 1;
        byArray2[97] = 1;
        byArray2[98] = 1;
        byArray2[99] = 1;
        byArray2[100] = 1;
        byArray2[101] = 1;
        byArray2[102] = 1;
        byArray2[103] = 1;
        byArray2[104] = 1;
        byArray2[105] = 1;
        byArray2[106] = 1;
        byArray2[107] = 1;
        byArray2[108] = 1;
        byArray2[109] = 1;
        byArray2[110] = 1;
        byArray2[111] = 1;
        byArray2[112] = 1;
        byArray2[113] = 1;
        byArray2[114] = 1;
        byArray2[115] = 1;
        byArray2[116] = 1;
        byArray2[117] = 1;
        byArray2[118] = 1;
        byArray2[119] = 1;
        byArray2[120] = 1;
        byArray2[121] = 1;
        byArray2[122] = 1;
        fgAsciiAlphaChar = byArray2;
        byte[] byArray3 = new byte[128];
        byArray3[45] = 1;
        byArray3[46] = 1;
        byArray3[48] = 1;
        byArray3[49] = 1;
        byArray3[50] = 1;
        byArray3[51] = 1;
        byArray3[52] = 1;
        byArray3[53] = 1;
        byArray3[54] = 1;
        byArray3[55] = 1;
        byArray3[56] = 1;
        byArray3[57] = 1;
        byArray3[65] = 1;
        byArray3[66] = 1;
        byArray3[67] = 1;
        byArray3[68] = 1;
        byArray3[69] = 1;
        byArray3[70] = 1;
        byArray3[71] = 1;
        byArray3[72] = 1;
        byArray3[73] = 1;
        byArray3[74] = 1;
        byArray3[75] = 1;
        byArray3[76] = 1;
        byArray3[77] = 1;
        byArray3[78] = 1;
        byArray3[79] = 1;
        byArray3[80] = 1;
        byArray3[81] = 1;
        byArray3[82] = 1;
        byArray3[83] = 1;
        byArray3[84] = 1;
        byArray3[85] = 1;
        byArray3[86] = 1;
        byArray3[87] = 1;
        byArray3[88] = 1;
        byArray3[89] = 1;
        byArray3[90] = 1;
        byArray3[95] = 1;
        byArray3[97] = 1;
        byArray3[98] = 1;
        byArray3[99] = 1;
        byArray3[100] = 1;
        byArray3[101] = 1;
        byArray3[102] = 1;
        byArray3[103] = 1;
        byArray3[104] = 1;
        byArray3[105] = 1;
        byArray3[106] = 1;
        byArray3[107] = 1;
        byArray3[108] = 1;
        byArray3[109] = 1;
        byArray3[110] = 1;
        byArray3[111] = 1;
        byArray3[112] = 1;
        byArray3[113] = 1;
        byArray3[114] = 1;
        byArray3[115] = 1;
        byArray3[116] = 1;
        byArray3[117] = 1;
        byArray3[118] = 1;
        byArray3[119] = 1;
        byArray3[120] = 1;
        byArray3[121] = 1;
        byArray3[122] = 1;
        fgAsciiEncNameChar = byArray3;
        byte[] byArray4 = new byte[128];
        byArray4[10] = 1;
        byArray4[13] = 1;
        byArray4[32] = 1;
        byArray4[33] = 1;
        byArray4[35] = 1;
        byArray4[36] = 1;
        byArray4[37] = 1;
        byArray4[39] = 1;
        byArray4[40] = 1;
        byArray4[41] = 1;
        byArray4[42] = 1;
        byArray4[43] = 1;
        byArray4[44] = 1;
        byArray4[45] = 1;
        byArray4[46] = 1;
        byArray4[47] = 1;
        byArray4[48] = 1;
        byArray4[49] = 1;
        byArray4[50] = 1;
        byArray4[51] = 1;
        byArray4[52] = 1;
        byArray4[53] = 1;
        byArray4[54] = 1;
        byArray4[55] = 1;
        byArray4[56] = 1;
        byArray4[57] = 1;
        byArray4[58] = 1;
        byArray4[59] = 1;
        byArray4[61] = 1;
        byArray4[63] = 1;
        byArray4[64] = 1;
        byArray4[65] = 1;
        byArray4[66] = 1;
        byArray4[67] = 1;
        byArray4[68] = 1;
        byArray4[69] = 1;
        byArray4[70] = 1;
        byArray4[71] = 1;
        byArray4[72] = 1;
        byArray4[73] = 1;
        byArray4[74] = 1;
        byArray4[75] = 1;
        byArray4[76] = 1;
        byArray4[77] = 1;
        byArray4[78] = 1;
        byArray4[79] = 1;
        byArray4[80] = 1;
        byArray4[81] = 1;
        byArray4[82] = 1;
        byArray4[83] = 1;
        byArray4[84] = 1;
        byArray4[85] = 1;
        byArray4[86] = 1;
        byArray4[87] = 1;
        byArray4[88] = 1;
        byArray4[89] = 1;
        byArray4[90] = 1;
        byArray4[95] = 1;
        byArray4[97] = 1;
        byArray4[98] = 1;
        byArray4[99] = 1;
        byArray4[100] = 1;
        byArray4[101] = 1;
        byArray4[102] = 1;
        byArray4[103] = 1;
        byArray4[104] = 1;
        byArray4[105] = 1;
        byArray4[106] = 1;
        byArray4[107] = 1;
        byArray4[108] = 1;
        byArray4[109] = 1;
        byArray4[110] = 1;
        byArray4[111] = 1;
        byArray4[112] = 1;
        byArray4[113] = 1;
        byArray4[114] = 1;
        byArray4[115] = 1;
        byArray4[116] = 1;
        byArray4[117] = 1;
        byArray4[118] = 1;
        byArray4[119] = 1;
        byArray4[120] = 1;
        byArray4[121] = 1;
        byArray4[122] = 1;
        fgAsciiPubidChar = byArray4;
        byte[] byArray5 = new byte[128];
        byArray5[58] = 1;
        byArray5[65] = 1;
        byArray5[66] = 1;
        byArray5[67] = 1;
        byArray5[68] = 1;
        byArray5[69] = 1;
        byArray5[70] = 1;
        byArray5[71] = 1;
        byArray5[72] = 1;
        byArray5[73] = 1;
        byArray5[74] = 1;
        byArray5[75] = 1;
        byArray5[76] = 1;
        byArray5[77] = 1;
        byArray5[78] = 1;
        byArray5[79] = 1;
        byArray5[80] = 1;
        byArray5[81] = 1;
        byArray5[82] = 1;
        byArray5[83] = 1;
        byArray5[84] = 1;
        byArray5[85] = 1;
        byArray5[86] = 1;
        byArray5[87] = 1;
        byArray5[88] = 1;
        byArray5[89] = 1;
        byArray5[90] = 1;
        byArray5[95] = 1;
        byArray5[97] = 1;
        byArray5[98] = 1;
        byArray5[99] = 1;
        byArray5[100] = 1;
        byArray5[101] = 1;
        byArray5[102] = 1;
        byArray5[103] = 1;
        byArray5[104] = 1;
        byArray5[105] = 1;
        byArray5[106] = 1;
        byArray5[107] = 1;
        byArray5[108] = 1;
        byArray5[109] = 1;
        byArray5[110] = 1;
        byArray5[111] = 1;
        byArray5[112] = 1;
        byArray5[113] = 1;
        byArray5[114] = 1;
        byArray5[115] = 1;
        byArray5[116] = 1;
        byArray5[117] = 1;
        byArray5[118] = 1;
        byArray5[119] = 1;
        byArray5[120] = 1;
        byArray5[121] = 1;
        byArray5[122] = 1;
        fgAsciiInitialNameChar = byArray5;
        byte[] byArray6 = new byte[128];
        byArray6[45] = 1;
        byArray6[46] = 1;
        byArray6[48] = 1;
        byArray6[49] = 1;
        byArray6[50] = 1;
        byArray6[51] = 1;
        byArray6[52] = 1;
        byArray6[53] = 1;
        byArray6[54] = 1;
        byArray6[55] = 1;
        byArray6[56] = 1;
        byArray6[57] = 1;
        byArray6[58] = 1;
        byArray6[65] = 1;
        byArray6[66] = 1;
        byArray6[67] = 1;
        byArray6[68] = 1;
        byArray6[69] = 1;
        byArray6[70] = 1;
        byArray6[71] = 1;
        byArray6[72] = 1;
        byArray6[73] = 1;
        byArray6[74] = 1;
        byArray6[75] = 1;
        byArray6[76] = 1;
        byArray6[77] = 1;
        byArray6[78] = 1;
        byArray6[79] = 1;
        byArray6[80] = 1;
        byArray6[81] = 1;
        byArray6[82] = 1;
        byArray6[83] = 1;
        byArray6[84] = 1;
        byArray6[85] = 1;
        byArray6[86] = 1;
        byArray6[87] = 1;
        byArray6[88] = 1;
        byArray6[89] = 1;
        byArray6[90] = 1;
        byArray6[95] = 1;
        byArray6[97] = 1;
        byArray6[98] = 1;
        byArray6[99] = 1;
        byArray6[100] = 1;
        byArray6[101] = 1;
        byArray6[102] = 1;
        byArray6[103] = 1;
        byArray6[104] = 1;
        byArray6[105] = 1;
        byArray6[106] = 1;
        byArray6[107] = 1;
        byArray6[108] = 1;
        byArray6[109] = 1;
        byArray6[110] = 1;
        byArray6[111] = 1;
        byArray6[112] = 1;
        byArray6[113] = 1;
        byArray6[114] = 1;
        byArray6[115] = 1;
        byArray6[116] = 1;
        byArray6[117] = 1;
        byArray6[118] = 1;
        byArray6[119] = 1;
        byArray6[120] = 1;
        byArray6[121] = 1;
        byArray6[122] = 1;
        fgAsciiNameChar = byArray6;
        byte[] byArray7 = new byte[128];
        byArray7[65] = 1;
        byArray7[66] = 1;
        byArray7[67] = 1;
        byArray7[68] = 1;
        byArray7[69] = 1;
        byArray7[70] = 1;
        byArray7[71] = 1;
        byArray7[72] = 1;
        byArray7[73] = 1;
        byArray7[74] = 1;
        byArray7[75] = 1;
        byArray7[76] = 1;
        byArray7[77] = 1;
        byArray7[78] = 1;
        byArray7[79] = 1;
        byArray7[80] = 1;
        byArray7[81] = 1;
        byArray7[82] = 1;
        byArray7[83] = 1;
        byArray7[84] = 1;
        byArray7[85] = 1;
        byArray7[86] = 1;
        byArray7[87] = 1;
        byArray7[88] = 1;
        byArray7[89] = 1;
        byArray7[90] = 1;
        byArray7[95] = 1;
        byArray7[97] = 1;
        byArray7[98] = 1;
        byArray7[99] = 1;
        byArray7[100] = 1;
        byArray7[101] = 1;
        byArray7[102] = 1;
        byArray7[103] = 1;
        byArray7[104] = 1;
        byArray7[105] = 1;
        byArray7[106] = 1;
        byArray7[107] = 1;
        byArray7[108] = 1;
        byArray7[109] = 1;
        byArray7[110] = 1;
        byArray7[111] = 1;
        byArray7[112] = 1;
        byArray7[113] = 1;
        byArray7[114] = 1;
        byArray7[115] = 1;
        byArray7[116] = 1;
        byArray7[117] = 1;
        byArray7[118] = 1;
        byArray7[119] = 1;
        byArray7[120] = 1;
        byArray7[121] = 1;
        byArray7[122] = 1;
        fgAsciiInitialNCNameChar = byArray7;
        byte[] byArray8 = new byte[128];
        byArray8[45] = 1;
        byArray8[46] = 1;
        byArray8[48] = 1;
        byArray8[49] = 1;
        byArray8[50] = 1;
        byArray8[51] = 1;
        byArray8[52] = 1;
        byArray8[53] = 1;
        byArray8[54] = 1;
        byArray8[55] = 1;
        byArray8[56] = 1;
        byArray8[57] = 1;
        byArray8[65] = 1;
        byArray8[66] = 1;
        byArray8[67] = 1;
        byArray8[68] = 1;
        byArray8[69] = 1;
        byArray8[70] = 1;
        byArray8[71] = 1;
        byArray8[72] = 1;
        byArray8[73] = 1;
        byArray8[74] = 1;
        byArray8[75] = 1;
        byArray8[76] = 1;
        byArray8[77] = 1;
        byArray8[78] = 1;
        byArray8[79] = 1;
        byArray8[80] = 1;
        byArray8[81] = 1;
        byArray8[82] = 1;
        byArray8[83] = 1;
        byArray8[84] = 1;
        byArray8[85] = 1;
        byArray8[86] = 1;
        byArray8[87] = 1;
        byArray8[88] = 1;
        byArray8[89] = 1;
        byArray8[90] = 1;
        byArray8[95] = 1;
        byArray8[97] = 1;
        byArray8[98] = 1;
        byArray8[99] = 1;
        byArray8[100] = 1;
        byArray8[101] = 1;
        byArray8[102] = 1;
        byArray8[103] = 1;
        byArray8[104] = 1;
        byArray8[105] = 1;
        byArray8[106] = 1;
        byArray8[107] = 1;
        byArray8[108] = 1;
        byArray8[109] = 1;
        byArray8[110] = 1;
        byArray8[111] = 1;
        byArray8[112] = 1;
        byArray8[113] = 1;
        byArray8[114] = 1;
        byArray8[115] = 1;
        byArray8[116] = 1;
        byArray8[117] = 1;
        byArray8[118] = 1;
        byArray8[119] = 1;
        byArray8[120] = 1;
        byArray8[121] = 1;
        byArray8[122] = 1;
        fgAsciiNCNameChar = byArray8;
        byte[] byArray9 = new byte[128];
        byArray9[0] = 4;
        byArray9[1] = 4;
        byArray9[2] = 4;
        byArray9[3] = 4;
        byArray9[4] = 4;
        byArray9[5] = 4;
        byArray9[6] = 4;
        byArray9[7] = 4;
        byArray9[8] = 4;
        byArray9[10] = 4;
        byArray9[11] = 4;
        byArray9[12] = 4;
        byArray9[13] = 4;
        byArray9[14] = 4;
        byArray9[15] = 4;
        byArray9[16] = 4;
        byArray9[17] = 4;
        byArray9[18] = 4;
        byArray9[19] = 4;
        byArray9[20] = 4;
        byArray9[21] = 4;
        byArray9[22] = 4;
        byArray9[23] = 4;
        byArray9[24] = 4;
        byArray9[25] = 4;
        byArray9[26] = 4;
        byArray9[27] = 4;
        byArray9[28] = 4;
        byArray9[29] = 4;
        byArray9[30] = 4;
        byArray9[31] = 4;
        byArray9[38] = 2;
        byArray9[60] = 1;
        byArray9[93] = 3;
        fgAsciiCharData = byArray9;
        byte[] byArray10 = new byte[128];
        byArray10[0] = 4;
        byArray10[1] = 4;
        byArray10[2] = 4;
        byArray10[3] = 4;
        byArray10[4] = 4;
        byArray10[5] = 4;
        byArray10[6] = 4;
        byArray10[7] = 4;
        byArray10[8] = 4;
        byArray10[9] = 5;
        byArray10[10] = 5;
        byArray10[11] = 4;
        byArray10[12] = 4;
        byArray10[13] = 5;
        byArray10[14] = 4;
        byArray10[15] = 4;
        byArray10[16] = 4;
        byArray10[17] = 4;
        byArray10[18] = 4;
        byArray10[19] = 4;
        byArray10[20] = 4;
        byArray10[21] = 4;
        byArray10[22] = 4;
        byArray10[23] = 4;
        byArray10[24] = 4;
        byArray10[25] = 4;
        byArray10[26] = 4;
        byArray10[27] = 4;
        byArray10[28] = 4;
        byArray10[29] = 4;
        byArray10[30] = 4;
        byArray10[31] = 4;
        byArray10[32] = 5;
        byArray10[38] = 2;
        byArray10[60] = 1;
        byArray10[93] = 3;
        fgAsciiWSCharData = byArray10;
        fgCharFlags = null;
        char[] cArray = new char[13];
        cArray[0] = 32;
        cArray[1] = 37;
        cArray[2] = 39;
        cArray[3] = 59;
        cArray[4] = 61;
        cArray[5] = 92;
        cArray[6] = 94;
        cArray[7] = 55295;
        cArray[8] = 57344;
        cArray[9] = 65533;
        cArray[11] = 9;
        fgCharDataRanges = cArray;
        char[] cArray2 = new char[359];
        cArray2[0] = 65;
        cArray2[1] = 90;
        cArray2[2] = 97;
        cArray2[3] = 122;
        cArray2[4] = 192;
        cArray2[5] = 214;
        cArray2[6] = 216;
        cArray2[7] = 246;
        cArray2[8] = 248;
        cArray2[9] = 305;
        cArray2[10] = 308;
        cArray2[11] = 318;
        cArray2[12] = 321;
        cArray2[13] = 328;
        cArray2[14] = 330;
        cArray2[15] = 382;
        cArray2[16] = 384;
        cArray2[17] = 451;
        cArray2[18] = 461;
        cArray2[19] = 496;
        cArray2[20] = 500;
        cArray2[21] = 501;
        cArray2[22] = 506;
        cArray2[23] = 535;
        cArray2[24] = 592;
        cArray2[25] = 680;
        cArray2[26] = 699;
        cArray2[27] = 705;
        cArray2[28] = 904;
        cArray2[29] = 906;
        cArray2[30] = 910;
        cArray2[31] = 929;
        cArray2[32] = 931;
        cArray2[33] = 974;
        cArray2[34] = 976;
        cArray2[35] = 982;
        cArray2[36] = 994;
        cArray2[37] = 1011;
        cArray2[38] = 1025;
        cArray2[39] = 1036;
        cArray2[40] = 1038;
        cArray2[41] = 1103;
        cArray2[42] = 1105;
        cArray2[43] = 1116;
        cArray2[44] = 1118;
        cArray2[45] = 1153;
        cArray2[46] = 1168;
        cArray2[47] = 1220;
        cArray2[48] = 1223;
        cArray2[49] = 1224;
        cArray2[50] = 1227;
        cArray2[51] = 1228;
        cArray2[52] = 1232;
        cArray2[53] = 1259;
        cArray2[54] = 1262;
        cArray2[55] = 1269;
        cArray2[56] = 1272;
        cArray2[57] = 1273;
        cArray2[58] = 1329;
        cArray2[59] = 1366;
        cArray2[60] = 1377;
        cArray2[61] = 1414;
        cArray2[62] = 1488;
        cArray2[63] = 1514;
        cArray2[64] = 1520;
        cArray2[65] = 1522;
        cArray2[66] = 1569;
        cArray2[67] = 1594;
        cArray2[68] = 1601;
        cArray2[69] = 1610;
        cArray2[70] = 1649;
        cArray2[71] = 1719;
        cArray2[72] = 1722;
        cArray2[73] = 1726;
        cArray2[74] = 1728;
        cArray2[75] = 1742;
        cArray2[76] = 1744;
        cArray2[77] = 1747;
        cArray2[78] = 1765;
        cArray2[79] = 1766;
        cArray2[80] = 2309;
        cArray2[81] = 2361;
        cArray2[82] = 2392;
        cArray2[83] = 2401;
        cArray2[84] = 2437;
        cArray2[85] = 2444;
        cArray2[86] = 2447;
        cArray2[87] = 2448;
        cArray2[88] = 2451;
        cArray2[89] = 2472;
        cArray2[90] = 2474;
        cArray2[91] = 2480;
        cArray2[92] = 2486;
        cArray2[93] = 2489;
        cArray2[94] = 2524;
        cArray2[95] = 2525;
        cArray2[96] = 2527;
        cArray2[97] = 2529;
        cArray2[98] = 2544;
        cArray2[99] = 2545;
        cArray2[100] = 2565;
        cArray2[101] = 2570;
        cArray2[102] = 2575;
        cArray2[103] = 2576;
        cArray2[104] = 2579;
        cArray2[105] = 2600;
        cArray2[106] = 2602;
        cArray2[107] = 2608;
        cArray2[108] = 2610;
        cArray2[109] = 2611;
        cArray2[110] = 2613;
        cArray2[111] = 2614;
        cArray2[112] = 2616;
        cArray2[113] = 2617;
        cArray2[114] = 2649;
        cArray2[115] = 2652;
        cArray2[116] = 2674;
        cArray2[117] = 2676;
        cArray2[118] = 2693;
        cArray2[119] = 2699;
        cArray2[120] = 2703;
        cArray2[121] = 2705;
        cArray2[122] = 2707;
        cArray2[123] = 2728;
        cArray2[124] = 2730;
        cArray2[125] = 2736;
        cArray2[126] = 2738;
        cArray2[127] = 2739;
        cArray2[128] = 2741;
        cArray2[129] = 2745;
        cArray2[130] = 2821;
        cArray2[131] = 2828;
        cArray2[132] = 2831;
        cArray2[133] = 2832;
        cArray2[134] = 2835;
        cArray2[135] = 2856;
        cArray2[136] = 2858;
        cArray2[137] = 2864;
        cArray2[138] = 2866;
        cArray2[139] = 2867;
        cArray2[140] = 2870;
        cArray2[141] = 2873;
        cArray2[142] = 2908;
        cArray2[143] = 2909;
        cArray2[144] = 2911;
        cArray2[145] = 2913;
        cArray2[146] = 2949;
        cArray2[147] = 2954;
        cArray2[148] = 2958;
        cArray2[149] = 2960;
        cArray2[150] = 2962;
        cArray2[151] = 2965;
        cArray2[152] = 2969;
        cArray2[153] = 2970;
        cArray2[154] = 2974;
        cArray2[155] = 2975;
        cArray2[156] = 2979;
        cArray2[157] = 2980;
        cArray2[158] = 2984;
        cArray2[159] = 2986;
        cArray2[160] = 2990;
        cArray2[161] = 2997;
        cArray2[162] = 2999;
        cArray2[163] = 3001;
        cArray2[164] = 3077;
        cArray2[165] = 3084;
        cArray2[166] = 3086;
        cArray2[167] = 3088;
        cArray2[168] = 3090;
        cArray2[169] = 3112;
        cArray2[170] = 3114;
        cArray2[171] = 3123;
        cArray2[172] = 3125;
        cArray2[173] = 3129;
        cArray2[174] = 3168;
        cArray2[175] = 3169;
        cArray2[176] = 3205;
        cArray2[177] = 3212;
        cArray2[178] = 3214;
        cArray2[179] = 3216;
        cArray2[180] = 3218;
        cArray2[181] = 3240;
        cArray2[182] = 3242;
        cArray2[183] = 3251;
        cArray2[184] = 3253;
        cArray2[185] = 3257;
        cArray2[186] = 3296;
        cArray2[187] = 3297;
        cArray2[188] = 3333;
        cArray2[189] = 3340;
        cArray2[190] = 3342;
        cArray2[191] = 3344;
        cArray2[192] = 3346;
        cArray2[193] = 3368;
        cArray2[194] = 3370;
        cArray2[195] = 3385;
        cArray2[196] = 3424;
        cArray2[197] = 3425;
        cArray2[198] = 3585;
        cArray2[199] = 3630;
        cArray2[200] = 3634;
        cArray2[201] = 3635;
        cArray2[202] = 3648;
        cArray2[203] = 3653;
        cArray2[204] = 3713;
        cArray2[205] = 3714;
        cArray2[206] = 3719;
        cArray2[207] = 3720;
        cArray2[208] = 3732;
        cArray2[209] = 3735;
        cArray2[210] = 3737;
        cArray2[211] = 3743;
        cArray2[212] = 3745;
        cArray2[213] = 3747;
        cArray2[214] = 3754;
        cArray2[215] = 3755;
        cArray2[216] = 3757;
        cArray2[217] = 3758;
        cArray2[218] = 3762;
        cArray2[219] = 3763;
        cArray2[220] = 3776;
        cArray2[221] = 3780;
        cArray2[222] = 3904;
        cArray2[223] = 3911;
        cArray2[224] = 3913;
        cArray2[225] = 3945;
        cArray2[226] = 4256;
        cArray2[227] = 4293;
        cArray2[228] = 4304;
        cArray2[229] = 4342;
        cArray2[230] = 4354;
        cArray2[231] = 4355;
        cArray2[232] = 4357;
        cArray2[233] = 4359;
        cArray2[234] = 4363;
        cArray2[235] = 4364;
        cArray2[236] = 4366;
        cArray2[237] = 4370;
        cArray2[238] = 4436;
        cArray2[239] = 4437;
        cArray2[240] = 4447;
        cArray2[241] = 4449;
        cArray2[242] = 4461;
        cArray2[243] = 4462;
        cArray2[244] = 4466;
        cArray2[245] = 4467;
        cArray2[246] = 4526;
        cArray2[247] = 4527;
        cArray2[248] = 4535;
        cArray2[249] = 4536;
        cArray2[250] = 4540;
        cArray2[251] = 4546;
        cArray2[252] = 7680;
        cArray2[253] = 7835;
        cArray2[254] = 7840;
        cArray2[255] = 7929;
        cArray2[256] = 7936;
        cArray2[257] = 7957;
        cArray2[258] = 7960;
        cArray2[259] = 7965;
        cArray2[260] = 7968;
        cArray2[261] = 8005;
        cArray2[262] = 8008;
        cArray2[263] = 8013;
        cArray2[264] = 8016;
        cArray2[265] = 8023;
        cArray2[266] = 8031;
        cArray2[267] = 8061;
        cArray2[268] = 8064;
        cArray2[269] = 8116;
        cArray2[270] = 8118;
        cArray2[271] = 8124;
        cArray2[272] = 8130;
        cArray2[273] = 8132;
        cArray2[274] = 8134;
        cArray2[275] = 8140;
        cArray2[276] = 8144;
        cArray2[277] = 8147;
        cArray2[278] = 8150;
        cArray2[279] = 8155;
        cArray2[280] = 8160;
        cArray2[281] = 8172;
        cArray2[282] = 8178;
        cArray2[283] = 8180;
        cArray2[284] = 8182;
        cArray2[285] = 8188;
        cArray2[286] = 8490;
        cArray2[287] = 8491;
        cArray2[288] = 8576;
        cArray2[289] = 8578;
        cArray2[290] = 12353;
        cArray2[291] = 12436;
        cArray2[292] = 12449;
        cArray2[293] = 12538;
        cArray2[294] = 12549;
        cArray2[295] = 12588;
        cArray2[296] = 44032;
        cArray2[297] = 55203;
        cArray2[298] = 12321;
        cArray2[299] = 12329;
        cArray2[300] = 19968;
        cArray2[301] = 40869;
        cArray2[303] = 58;
        cArray2[304] = 95;
        cArray2[305] = 902;
        cArray2[306] = 908;
        cArray2[307] = 986;
        cArray2[308] = 988;
        cArray2[309] = 990;
        cArray2[310] = 992;
        cArray2[311] = 1369;
        cArray2[312] = 1749;
        cArray2[313] = 2365;
        cArray2[314] = 2482;
        cArray2[315] = 2654;
        cArray2[316] = 2701;
        cArray2[317] = 2749;
        cArray2[318] = 2784;
        cArray2[319] = 2877;
        cArray2[320] = 2972;
        cArray2[321] = 3294;
        cArray2[322] = 3632;
        cArray2[323] = 3716;
        cArray2[324] = 3722;
        cArray2[325] = 3725;
        cArray2[326] = 3749;
        cArray2[327] = 3751;
        cArray2[328] = 3760;
        cArray2[329] = 3773;
        cArray2[330] = 4352;
        cArray2[331] = 4361;
        cArray2[332] = 4412;
        cArray2[333] = 4414;
        cArray2[334] = 4416;
        cArray2[335] = 4428;
        cArray2[336] = 4430;
        cArray2[337] = 4432;
        cArray2[338] = 4441;
        cArray2[339] = 4451;
        cArray2[340] = 4453;
        cArray2[341] = 4455;
        cArray2[342] = 4457;
        cArray2[343] = 4469;
        cArray2[344] = 4510;
        cArray2[345] = 4520;
        cArray2[346] = 4523;
        cArray2[347] = 4538;
        cArray2[348] = 4587;
        cArray2[349] = 4592;
        cArray2[350] = 4601;
        cArray2[351] = 8025;
        cArray2[352] = 8027;
        cArray2[353] = 8029;
        cArray2[354] = 8126;
        cArray2[355] = 8486;
        cArray2[356] = 8494;
        cArray2[357] = 12295;
        fgInitialNameCharRanges = cArray2;
        char[] cArray3 = new char[209];
        cArray3[0] = 45;
        cArray3[1] = 46;
        cArray3[2] = 768;
        cArray3[3] = 837;
        cArray3[4] = 864;
        cArray3[5] = 865;
        cArray3[6] = 1155;
        cArray3[7] = 1158;
        cArray3[8] = 1425;
        cArray3[9] = 1441;
        cArray3[10] = 1443;
        cArray3[11] = 1465;
        cArray3[12] = 1467;
        cArray3[13] = 1469;
        cArray3[14] = 1473;
        cArray3[15] = 1474;
        cArray3[16] = 1611;
        cArray3[17] = 1618;
        cArray3[18] = 1750;
        cArray3[19] = 1756;
        cArray3[20] = 1757;
        cArray3[21] = 1759;
        cArray3[22] = 1760;
        cArray3[23] = 1764;
        cArray3[24] = 1767;
        cArray3[25] = 1768;
        cArray3[26] = 1770;
        cArray3[27] = 1773;
        cArray3[28] = 2305;
        cArray3[29] = 2307;
        cArray3[30] = 2366;
        cArray3[31] = 2380;
        cArray3[32] = 2385;
        cArray3[33] = 2388;
        cArray3[34] = 2402;
        cArray3[35] = 2403;
        cArray3[36] = 2433;
        cArray3[37] = 2435;
        cArray3[38] = 2496;
        cArray3[39] = 2500;
        cArray3[40] = 2503;
        cArray3[41] = 2504;
        cArray3[42] = 2507;
        cArray3[43] = 2509;
        cArray3[44] = 2530;
        cArray3[45] = 2531;
        cArray3[46] = 2624;
        cArray3[47] = 2626;
        cArray3[48] = 2631;
        cArray3[49] = 2632;
        cArray3[50] = 2635;
        cArray3[51] = 2637;
        cArray3[52] = 2672;
        cArray3[53] = 2673;
        cArray3[54] = 2689;
        cArray3[55] = 2691;
        cArray3[56] = 2750;
        cArray3[57] = 2757;
        cArray3[58] = 2759;
        cArray3[59] = 2761;
        cArray3[60] = 2763;
        cArray3[61] = 2765;
        cArray3[62] = 2817;
        cArray3[63] = 2819;
        cArray3[64] = 2878;
        cArray3[65] = 2883;
        cArray3[66] = 2887;
        cArray3[67] = 2888;
        cArray3[68] = 2891;
        cArray3[69] = 2893;
        cArray3[70] = 2902;
        cArray3[71] = 2903;
        cArray3[72] = 2946;
        cArray3[73] = 2947;
        cArray3[74] = 3006;
        cArray3[75] = 3010;
        cArray3[76] = 3014;
        cArray3[77] = 3016;
        cArray3[78] = 3018;
        cArray3[79] = 3021;
        cArray3[80] = 3073;
        cArray3[81] = 3075;
        cArray3[82] = 3134;
        cArray3[83] = 3140;
        cArray3[84] = 3142;
        cArray3[85] = 3144;
        cArray3[86] = 3146;
        cArray3[87] = 3149;
        cArray3[88] = 3157;
        cArray3[89] = 3158;
        cArray3[90] = 3202;
        cArray3[91] = 3203;
        cArray3[92] = 3262;
        cArray3[93] = 3268;
        cArray3[94] = 3270;
        cArray3[95] = 3272;
        cArray3[96] = 3274;
        cArray3[97] = 3277;
        cArray3[98] = 3285;
        cArray3[99] = 3286;
        cArray3[100] = 3330;
        cArray3[101] = 3331;
        cArray3[102] = 3390;
        cArray3[103] = 3395;
        cArray3[104] = 3398;
        cArray3[105] = 3400;
        cArray3[106] = 3402;
        cArray3[107] = 3405;
        cArray3[108] = 3636;
        cArray3[109] = 3642;
        cArray3[110] = 3655;
        cArray3[111] = 3662;
        cArray3[112] = 3764;
        cArray3[113] = 3769;
        cArray3[114] = 3771;
        cArray3[115] = 3772;
        cArray3[116] = 3784;
        cArray3[117] = 3789;
        cArray3[118] = 3864;
        cArray3[119] = 3865;
        cArray3[120] = 3953;
        cArray3[121] = 3972;
        cArray3[122] = 3974;
        cArray3[123] = 3979;
        cArray3[124] = 3984;
        cArray3[125] = 3989;
        cArray3[126] = 3993;
        cArray3[127] = 4013;
        cArray3[128] = 4017;
        cArray3[129] = 4023;
        cArray3[130] = 8400;
        cArray3[131] = 8412;
        cArray3[132] = 12330;
        cArray3[133] = 12335;
        cArray3[134] = 48;
        cArray3[135] = 57;
        cArray3[136] = 1632;
        cArray3[137] = 1641;
        cArray3[138] = 1776;
        cArray3[139] = 1785;
        cArray3[140] = 2406;
        cArray3[141] = 2415;
        cArray3[142] = 2534;
        cArray3[143] = 2543;
        cArray3[144] = 2662;
        cArray3[145] = 2671;
        cArray3[146] = 2790;
        cArray3[147] = 2799;
        cArray3[148] = 2918;
        cArray3[149] = 2927;
        cArray3[150] = 3047;
        cArray3[151] = 3055;
        cArray3[152] = 3174;
        cArray3[153] = 3183;
        cArray3[154] = 3302;
        cArray3[155] = 3311;
        cArray3[156] = 3430;
        cArray3[157] = 3439;
        cArray3[158] = 3664;
        cArray3[159] = 3673;
        cArray3[160] = 3792;
        cArray3[161] = 3801;
        cArray3[162] = 3872;
        cArray3[163] = 3881;
        cArray3[164] = 12337;
        cArray3[165] = 12341;
        cArray3[166] = 12445;
        cArray3[167] = 12446;
        cArray3[168] = 12540;
        cArray3[169] = 12542;
        cArray3[171] = 1471;
        cArray3[172] = 1476;
        cArray3[173] = 1648;
        cArray3[174] = 2364;
        cArray3[175] = 2381;
        cArray3[176] = 2492;
        cArray3[177] = 2494;
        cArray3[178] = 2495;
        cArray3[179] = 2519;
        cArray3[180] = 2562;
        cArray3[181] = 2620;
        cArray3[182] = 2622;
        cArray3[183] = 2623;
        cArray3[184] = 2748;
        cArray3[185] = 2876;
        cArray3[186] = 3031;
        cArray3[187] = 3415;
        cArray3[188] = 3633;
        cArray3[189] = 3761;
        cArray3[190] = 3893;
        cArray3[191] = 3895;
        cArray3[192] = 3897;
        cArray3[193] = 3902;
        cArray3[194] = 3903;
        cArray3[195] = 3991;
        cArray3[196] = 4025;
        cArray3[197] = 8417;
        cArray3[198] = 12441;
        cArray3[199] = 12442;
        cArray3[200] = 183;
        cArray3[201] = 720;
        cArray3[202] = 721;
        cArray3[203] = 903;
        cArray3[204] = 1600;
        cArray3[205] = 3654;
        cArray3[206] = 3782;
        cArray3[207] = 12293;
        fgNameCharRanges = cArray3;
    }
}

