/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeContainer;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.range.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends NodeContainer
implements Document,
DocumentTraversal,
DocumentEvent {
    static final long serialVersionUID = 515687835542616694L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected Hashtable identifiers;
    protected Vector iterators;
    protected Vector treeWalkers;
    protected Vector ranges;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;

    public DocumentImpl() {
        this(false);
    }

    public DocumentImpl(boolean bl) {
        super(null, null, null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
    }

    public DocumentImpl(DocumentType documentType) {
        this(documentType, false);
    }

    public DocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        this.docType = (DocumentTypeImpl)documentType;
        if (this.docType != null) {
            this.docType.ownerDocument = this;
            this.docType.entities.ownerDocument = this;
            this.docType.notations.ownerDocument = this;
            this.docType.elements.ownerDocument = this;
        }
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() {
        return null;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        if (bl) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            while (nodeImpl != null) {
                documentImpl.appendChild(documentImpl.importNode(nodeImpl, true));
                nodeImpl = nodeImpl.nextSibling;
            }
        }
        return documentImpl;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
    }

    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new ElementImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new EntityReferenceImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public DocumentType getDoctype() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new DocumentTypeImpl(this, string, string2, string3);
    }

    public Entity createEntity(String string) throws DOMException {
        return new EntityImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        return new NotationImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        return new ElementDefinitionImpl(this, string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2;
        Object object = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                node2 = this.createElement(node.getNodeName());
                Object object2 = node.getAttributes();
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.getLength()) {
                        node2.setAttributeNode((AttrImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object = (NodeImpl)node2;
                break;
            }
            case 2: {
                object = (NodeImpl)((Object)this.createAttribute(node.getNodeName()));
                break;
            }
            case 3: {
                object = (NodeImpl)((Object)this.createTextNode(node.getNodeValue()));
                break;
            }
            case 4: {
                object = (NodeImpl)((Object)this.createCDATASection(node.getNodeValue()));
                break;
            }
            case 5: {
                object = (NodeImpl)((Object)this.createEntityReference(node.getNodeName()));
                bl = false;
                break;
            }
            case 6: {
                node2 = (Entity)node;
                Object object2 = (EntityImpl)this.createEntity(node.getNodeName());
                ((EntityImpl)object2).setPublicId(node2.getPublicId());
                ((EntityImpl)object2).setSystemId(node2.getSystemId());
                ((EntityImpl)object2).setNotationName(node2.getNotationName());
                object = object2;
                break;
            }
            case 7: {
                object = (ProcessingInstructionImpl)this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                object = (NodeImpl)((Object)this.createComment(node.getNodeValue()));
                break;
            }
            case 10: {
                int n;
                node2 = (DocumentTypeImpl)node;
                Object object2 = (DocumentTypeImpl)this.createDocumentType(((NodeImpl)node2).getNodeName(), ((DocumentTypeImpl)node2).getPublicId(), ((DocumentTypeImpl)node2).getSystemId());
                NamedNodeMap namedNodeMap = ((DocumentType)node).getEntities();
                NamedNodeMap namedNodeMap2 = ((DocumentTypeImpl)object2).getEntities();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        namedNodeMap2.setNamedItem((EntityImpl)this.importNode(namedNodeMap.item(n), true));
                        ++n;
                    }
                }
                namedNodeMap = ((DocumentType)node).getNotations();
                namedNodeMap2 = ((DocumentTypeImpl)object2).getNotations();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        namedNodeMap2.setNamedItem((NotationImpl)this.importNode(namedNodeMap.item(n), true));
                        ++n;
                    }
                }
                object = object2;
                break;
            }
            case 11: {
                object = (NodeImpl)((Object)this.createDocumentFragment());
                break;
            }
            case 12: {
                node2 = (Notation)node;
                Object object2 = (NotationImpl)this.createNotation(node.getNodeName());
                ((NotationImpl)object2).setPublicId(node2.getPublicId());
                ((NotationImpl)object2).setSystemId(node2.getSystemId());
                object = object2;
                break;
            }
            default: {
                throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                ((NodeImpl)object).appendChild(this.importNode(node2, true));
                node2 = node2.getNextSibling();
            }
        }
        return object;
    }

    public Element getElementById(String string) {
        return this.getIdentifier(string);
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Element getIdentifier(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public void removeIdentifier(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    public Enumeration getIdentifiers() {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        return new ElementNSImpl(this, string, string2);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return new AttrNSImpl(this, string, string2);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public NodeIterator createNodeIterator(Node node, short s, NodeFilter nodeFilter) {
        return this.createNodeIterator(node, s, nodeFilter, true);
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        NodeIteratorImpl nodeIteratorImpl = new NodeIteratorImpl(this, node, n, nodeFilter, bl);
        if (this.iterators == null) {
            this.iterators = new Vector();
        }
        this.iterators.addElement(nodeIteratorImpl);
        return nodeIteratorImpl;
    }

    public TreeWalker createTreeWalker(Node node, short s, NodeFilter nodeFilter) {
        return this.createTreeWalker(node, s, nodeFilter, true);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (node == null) {
            throw new DOMExceptionImpl(9, "DOM007 Not supported");
        }
        TreeWalkerImpl treeWalkerImpl = new TreeWalkerImpl(node, n, nodeFilter, bl);
        if (this.treeWalkers == null) {
            this.treeWalkers = new Vector();
        }
        this.treeWalkers.addElement(treeWalkerImpl);
        return treeWalkerImpl;
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        if (this.iterators == null) {
            return;
        }
        this.iterators.removeElement(nodeIterator);
    }

    public void removeTreeWalker(TreeWalker treeWalker) {
        if (treeWalker == null) {
            return;
        }
        if (this.treeWalkers == null) {
            return;
        }
        this.treeWalkers.removeElement(treeWalker);
    }

    public Enumeration getNodeIterators() {
        if (this.iterators == null) {
            return null;
        }
        return this.iterators.elements();
    }

    public Enumeration getTreeWalkers() {
        if (this.treeWalkers == null) {
            return null;
        }
        return this.treeWalkers.elements();
    }

    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new Vector();
        }
        RangeImpl rangeImpl = new RangeImpl(this);
        this.ranges.addElement(rangeImpl);
        return rangeImpl;
    }

    public Enumeration getRanges() {
        if (this.ranges == null) {
            return null;
        }
        return this.ranges.elements();
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        this.ranges.removeElement(range);
    }

    public Event createEvent(String string) throws DOMException {
        if ("Event".equals(string)) {
            return new EventImpl();
        }
        if ("MutationEvent".equals(string)) {
            return new MutationEventImpl();
        }
        throw new DOMExceptionImpl(101, "DOM007 Not supported");
    }

    public static boolean isXMLName(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        if (!Character.isLetter(cArray[0]) && "_:".indexOf(cArray[0]) == -1) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = cArray[n];
            int n2 = Character.getType(c);
            if (!Character.isLetterOrDigit(c) && ".-_:".indexOf(c) == -1 && (n2 < 6 || n2 > 8 || c >= '\u06dd' && c <= '\u06de' || c >= '\u20dd' && c <= '\u20e0' || c >= '\u309b') && (n2 != 4 || c >= '\u02d0' && c <= '\u0559' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u309b' && c <= '\u309c') && c != '\u00b7' && c != '\u0387') {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean isKidOK(Node node, Node node2) {
        if (this.allowGrammarAccess && node.getNodeType() == 10) {
            return node2.getNodeType() == 1;
        }
        return (NodeContainer.kidOK[node.getNodeType()] & 1 << node2.getNodeType()) != 0;
    }
}

