/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;

public class DeferredEntityReferenceImpl
extends EntityReferenceImpl
implements DeferredNode {
    static final long serialVersionUID = 390319091370032223L;
    protected transient int fNodeIndex;

    DeferredEntityReferenceImpl(DeferredDocumentImpl deferredDocumentImpl, int n) {
        super(deferredDocumentImpl, null);
        this.fNodeIndex = n;
        this.syncData = true;
        this.syncChildren = true;
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        this.syncData = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        this.name = deferredDocumentImpl.getNodeNameString(this.fNodeIndex);
    }

    protected void synchronizeChildren() {
        Node node;
        Entity entity;
        Object object;
        this.syncChildren = false;
        DocumentType documentType = this.ownerDocument.getDoctype();
        boolean bl = false;
        if (documentType != null && (object = documentType.getEntities()) != null && (entity = (Entity)object.getNamedItem(this.getNodeName())) != null) {
            bl = true;
            this.readOnly = false;
            node = entity.getFirstChild();
            while (node != null) {
                this.appendChild(node.cloneNode(true));
                node = node.getNextSibling();
            }
            this.readOnly = true;
        }
        if (!bl) {
            object = (DeferredDocumentImpl)this.ownerDocument;
            int n = ((DeferredDocumentImpl)object).getFirstChild(this.fNodeIndex);
            this.readOnly = false;
            while (n != -1) {
                node = ((DeferredDocumentImpl)object).getNodeObject(n);
                this.appendChild(node);
                n = ((DeferredDocumentImpl)object).getNextSibling(n);
            }
            this.readOnly = true;
        }
    }
}

