/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.RangeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    static final long serialVersionUID = 7931170150428474230L;
    private static transient NodeList singletonNodeList = new 1();

    protected CharacterDataImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, null, string);
    }

    public abstract String getNodeName();

    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    public String getData() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public int getLength() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value.length();
    }

    public void appendData(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        this.setNodeValue(String.valueOf(this.value) + string);
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (n2 < 0) {
            throw new DOMExceptionImpl(1, "DOM004 Index out of bounds");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        int n3 = Math.max(this.value.length() - n2 - n, 0);
        try {
            this.setNodeValueInternal(String.valueOf(this.value.substring(0, n)) + (n3 > 0 ? this.value.substring(n + n2, n + n2 + n3) : ""));
            Enumeration enumeration = this.ownerDocument.getRanges();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    RangeImpl rangeImpl = (RangeImpl)enumeration.nextElement();
                    rangeImpl.receiveDeletedText(this, n, n2);
                }
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "DOM004 Index out of bounds");
        }
    }

    public void insertData(int n, String string) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        try {
            this.setNodeValueInternal(new StringBuffer(this.value).insert(n, string).toString());
            Enumeration enumeration = this.ownerDocument.getRanges();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    RangeImpl rangeImpl = (RangeImpl)enumeration.nextElement();
                    rangeImpl.receiveInsertedText(this, n, string.length());
                }
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "DOM004 Index out of bounds");
        }
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.deleteData(n, n2);
        this.insertData(n, string);
    }

    public void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.syncData) {
            this.synchronizeData();
        }
        int n3 = this.value.length();
        if (n2 < 0 || n < 0 || n > n3 - 1) {
            throw new DOMExceptionImpl(1, "DOM004 Index out of bounds");
        }
        int n4 = Math.min(n + n2, n3);
        return this.value.substring(n, n4);
    }

    private final class 1
    implements NodeList {
        public Node item(int n) {
            return null;
        }

        public int getLength() {
            return 0;
        }

        /* synthetic */ 1() {
        }
    }
}

