/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;

abstract class XMLEntityReader
implements XMLEntityHandler.EntityReader {
    protected XMLEntityHandler fEntityHandler;
    protected XMLErrorReporter fErrorReporter;
    protected boolean fSendCharDataAsCharArray;
    protected boolean fInCDSect = false;
    private boolean fStillActive = true;
    protected int fCarriageReturnCounter = 1;
    protected int fLinefeedCounter = 1;
    protected int fCharacterCounter = 1;
    protected int fCurrentOffset;

    protected XMLEntityReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl) {
        this.fEntityHandler = xMLEntityHandler;
        this.fErrorReporter = xMLErrorReporter;
        this.fSendCharDataAsCharArray = bl;
    }

    protected XMLEntityReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, int n, int n2) {
        this.fEntityHandler = xMLEntityHandler;
        this.fErrorReporter = xMLErrorReporter;
        this.fSendCharDataAsCharArray = bl;
        this.fLinefeedCounter = n;
        this.fCharacterCounter = n2;
    }

    protected void init(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, int n, int n2) {
        this.fEntityHandler = xMLEntityHandler;
        this.fErrorReporter = xMLErrorReporter;
        this.fSendCharDataAsCharArray = bl;
        this.fLinefeedCounter = n;
        this.fCharacterCounter = n2;
        this.fStillActive = true;
        this.fInCDSect = false;
        this.fCarriageReturnCounter = 1;
        this.fCurrentOffset = 0;
    }

    public int currentOffset() {
        return this.fCurrentOffset;
    }

    public int getLineNumber() {
        if (this.fLinefeedCounter > 1) {
            return this.fLinefeedCounter;
        }
        return this.fCarriageReturnCounter;
    }

    public int getColumnNumber() {
        return this.fCharacterCounter;
    }

    public void setInCDSect(boolean bl) {
        this.fInCDSect = bl;
    }

    public boolean getInCDSect() {
        return this.fInCDSect;
    }

    protected XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader entityReader = null;
        if (this.fStillActive) {
            entityReader = this.fEntityHandler.changeReaders();
            this.fStillActive = false;
        }
        return entityReader;
    }

    public abstract void append(XMLEntityHandler.CharBuffer var1, int var2, int var3);

    public abstract int addString(int var1, int var2);

    public abstract int addSymbol(int var1, int var2);

    public abstract boolean lookingAtChar(char var1, boolean var2) throws Exception;

    public abstract boolean lookingAtValidChar(boolean var1) throws Exception;

    public abstract boolean lookingAtSpace(boolean var1) throws Exception;

    public abstract void skipToChar(char var1) throws Exception;

    public abstract void skipPastSpaces() throws Exception;

    public abstract void skipPastName(char var1) throws Exception;

    public abstract void skipPastNmtoken(char var1) throws Exception;

    public abstract boolean skippedString(char[] var1) throws Exception;

    public abstract int scanInvalidChar() throws Exception;

    public abstract int scanCharRef(boolean var1) throws Exception;

    public abstract int scanStringLiteral() throws Exception;

    public abstract int scanAttValue(char var1, boolean var2) throws Exception;

    public abstract int scanEntityValue(int var1, boolean var2) throws Exception;

    public abstract int scanName(char var1) throws Exception;

    public abstract boolean scanExpectedName(char var1, StringPool.CharArrayRange var2) throws Exception;

    public abstract int scanQName(char var1) throws Exception;

    public abstract int scanContent(int var1) throws Exception;
}

