/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

final class UCSReader
extends XMLEntityReader
implements StringPool.StringProducer {
    private static final boolean DEBUG_UTF16_BIG = false;
    static final int E_UCS4B = 0;
    static final int E_UCS4L = 1;
    static final int E_UCS2B = 2;
    static final int E_UCS2L = 3;
    static final int E_UCS2B_NOBOM = 4;
    static final int E_UCS2L_NOBOM = 5;
    private ChunkyByteArray fData;
    private int fEncoding = -1;
    private StringPool fStringPool;
    private int fBytesPerChar = -1;
    private boolean fBigEndian = true;
    private ChunkyCharArray fStringCharArray;
    private static char[] fCharacters = new char[256];
    private int fCharDataLength;
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};

    UCSReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, ChunkyByteArray chunkyByteArray, int n, StringPool stringPool) throws Exception {
        super(xMLEntityHandler, xMLErrorReporter, bl);
        this.fCurrentOffset = n == 2 || n == 3 ? 2 : 0;
        this.fData = chunkyByteArray;
        this.fEncoding = n;
        this.fStringPool = stringPool;
        this.fBytesPerChar = this.fEncoding == 0 || this.fEncoding == 1 ? 4 : 2;
        this.fBigEndian = this.fEncoding == 0 || this.fEncoding == 2 || this.fEncoding == 4;
    }

    private int getChar(int n) throws IOException {
        int n2;
        if ((n2 = this.fData.byteAt(n++) & 0xFF) == 255 && this.fData.atEOF(n)) {
            return -1;
        }
        int n3 = this.fData.byteAt(n++) & 0xFF;
        if (this.fBytesPerChar == 4) {
            int n4 = this.fData.byteAt(n++) & 0xFF;
            int n5 = this.fData.byteAt(n++) & 0xFF;
            if (this.fBigEndian) {
                return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
            }
            return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
        }
        if (this.fBigEndian) {
            return (n2 << 8) + n3;
        }
        return (n3 << 8) + n2;
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addString(this, n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this, n, n2, this.getHashcode(n, n2));
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4;
            try {
                n4 = this.getChar(n);
            }
            catch (IOException iOException) {
                n4 = 0;
            }
            charBuffer.append((char)n4);
            n += this.fBytesPerChar;
        }
    }

    public void releaseString(int n, int n2) {
    }

    public String toString(int n, int n2) {
        if (this.fStringCharArray == null) {
            this.fStringCharArray = new ChunkyCharArray(this.fStringPool);
        }
        int n3 = this.fStringCharArray.length();
        this.append(this.fStringCharArray, n, n2);
        int n4 = this.fStringCharArray.length() - n3;
        int n5 = this.fStringCharArray.addString(n3, n4);
        return this.fStringPool.toString(n5);
    }

    private int getHashcode(int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        while (n < n3) {
            int n5;
            try {
                n5 = this.getChar(n);
            }
            catch (IOException iOException) {
                n5 = 0;
            }
            n4 = StringHasher.hashChar(n4, n5);
            n += this.fBytesPerChar;
        }
        return StringHasher.finishHash(n4);
    }

    public boolean equalsString(int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = n + n2;
        int n6 = n4;
        while (n < n5) {
            int n7;
            if (n6-- == 0) {
                return false;
            }
            try {
                n7 = this.getChar(n);
            }
            catch (IOException iOException) {
                n7 = 0;
            }
            if (n7 != cArray[n3++]) {
                return false;
            }
            n += this.fBytesPerChar;
        }
        return n6 == 0;
    }

    private void appendCharData(int n) {
        if (fCharacters.length == this.fCharDataLength) {
            char[] cArray = new char[fCharacters.length * 2];
            System.arraycopy(fCharacters, 0, cArray, 0, fCharacters.length);
            fCharacters = cArray;
        }
        UCSReader.fCharacters[this.fCharDataLength++] = (char)n;
    }

    public void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3;
        int n4 = n + n2;
        boolean bl2 = false;
        while (n < n4) {
            n3 = this.getChar(n);
            if (bl2) {
                bl2 = false;
                if (n3 == 10) {
                    n += this.fBytesPerChar;
                    continue;
                }
            }
            if (n3 == 13) {
                bl2 = true;
                n3 = 10;
            }
            this.appendCharData(n3);
            n += this.fBytesPerChar;
        }
        if (this.fSendCharDataAsCharArray) {
            if (bl) {
                this.fEntityHandler.processWhitespace(fCharacters, 0, this.fCharDataLength);
            } else {
                this.fEntityHandler.processCharacters(fCharacters, 0, this.fCharDataLength);
            }
        } else {
            n3 = this.fStringPool.addString(new String(fCharacters, 0, this.fCharDataLength));
            if (bl) {
                this.fEntityHandler.processWhitespace(n3);
            } else {
                this.fEntityHandler.processCharacters(n3);
            }
        }
        this.fCharDataLength = 0;
    }

    public boolean lookingAtChar(char c, boolean bl) throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if (n == c) {
            if (bl) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        return false;
    }

    public boolean lookingAtValidChar(boolean bl) throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if (n < 32) {
            if (n == 9) {
                if (!bl) {
                    return true;
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                if (!bl) {
                    return true;
                }
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                if (!bl) {
                    return true;
                }
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                if (n == -1) {
                    return this.changeReaders().lookingAtValidChar(bl);
                }
                return false;
            }
            this.fCurrentOffset += this.fBytesPerChar;
            return true;
        }
        if (n <= 55295) {
            if (bl) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        if (n <= 57343) {
            if (bl) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        if (n <= 65533) {
            if (bl) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        return false;
    }

    public boolean lookingAtSpace(boolean bl) throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            if (!bl) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (n == 10) {
            if (!bl) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n == 13) {
            if (!bl) {
                return true;
            }
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
        } else {
            if (n == -1) {
                return this.changeReaders().lookingAtSpace(bl);
            }
            return false;
        }
        this.fCurrentOffset += this.fBytesPerChar;
        return true;
    }

    public void skipToChar(char c) throws Exception {
        int n;
        while ((n = this.getChar(this.fCurrentOffset)) != c) {
            if (n == -1) {
                this.changeReaders().skipToChar(c);
                return;
            }
            if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                n = this.getChar(this.fCurrentOffset);
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int n;
        while ((n = this.getChar(this.fCurrentOffset)) <= 32) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                if (n == -1) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return;
    }

    public void skipPastName(char c) throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
            return;
        }
        do {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            n = this.getChar(this.fCurrentOffset);
            if (c != n) continue;
            return;
        } while ((XMLCharacterProperties.fgCharFlags[n] & 4) != 0);
    }

    public void skipPastNmtoken(char c) throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        while (c != n) {
            if ((XMLCharacterProperties.fgCharFlags[n] & 4) == 0) {
                return;
            }
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            n = this.getChar(this.fCurrentOffset);
        }
        return;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = this.fCurrentOffset;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (this.getChar(n) != cArray[n2]) {
                return false;
            }
            n += this.fBytesPerChar;
            ++n2;
        }
        this.fCurrentOffset = n;
        this.fCharacterCounter += cArray.length;
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if (n == -1) {
            return this.changeReaders().scanInvalidChar();
        }
        this.fCurrentOffset += this.fBytesPerChar;
        if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n == 13) {
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
        } else {
            int n2;
            ++this.fCharacterCounter;
            if (n >= 55296 && n < 56320 && (n2 = this.getChar(this.fCurrentOffset)) >= 56320 && n2 < 57344) {
                n = (n - 55296 << 10) + (n2 - 56320) + 65536;
                this.fCurrentOffset += this.fBytesPerChar;
            }
        }
        return n;
    }

    public int scanCharRef(boolean bl) throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if (n == -1) {
            return this.changeReaders().scanCharRef(bl);
        }
        int n2 = 0;
        if (bl) {
            if (n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) {
                return -2;
            }
            n2 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
        } else {
            if (n < 48 || n > 57) {
                return -2;
            }
            n2 = n - 48;
        }
        ++this.fCharacterCounter;
        this.fCurrentOffset += this.fBytesPerChar;
        boolean bl2 = false;
        while ((n = this.getChar(this.fCurrentOffset)) != -1 && !(bl ? n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0 : n < 48 || n > 57)) {
            int n3;
            ++this.fCharacterCounter;
            this.fCurrentOffset += this.fBytesPerChar;
            if (bl) {
                n3 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
                n2 = (n2 << 4) + n3;
            } else {
                n3 = n - 48;
                n2 = n2 * 10 + n3;
            }
            if (n2 <= 0x10FFFF) continue;
            bl2 = true;
            n2 = 0;
        }
        if (n != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.fCurrentOffset += this.fBytesPerChar;
        if (bl2) {
            return -3;
        }
        return n2;
    }

    public int scanStringLiteral() throws Exception {
        boolean bl = this.lookingAtChar('\'', true);
        if (!bl && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int n = this.fCurrentOffset;
        char c = bl ? (char)'\'' : '\"';
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int n2 = this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanAttValue(char c, boolean bl) throws Exception {
        int n = this.fCurrentOffset;
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int n2 = bl ? this.addSymbol(n, this.fCurrentOffset - n) : this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanEntityValue(int n, boolean bl) throws Exception {
        int n2;
        block4: {
            n2 = this.fCurrentOffset;
            do {
                if (n != -1 && this.lookingAtChar((char)n, false)) {
                    if (!bl) {
                        return -1;
                    }
                    break block4;
                }
                if (this.lookingAtChar('&', false)) {
                    return -2;
                }
                if (!this.lookingAtChar('%', false)) continue;
                return -3;
            } while (this.lookingAtValidChar(true));
            return -4;
        }
        int n3 = this.addString(n2, this.fCurrentOffset - n2);
        this.lookingAtChar((char)n, true);
        return n3;
    }

    public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws Exception {
        int n = this.fCurrentOffset;
        this.skipPastName(c);
        int n2 = this.fCurrentOffset - n;
        if (n2 == 0) {
            return false;
        }
        this.addSymbol(n, n2);
        return true;
    }

    public int scanQName(char c) throws Exception {
        int n = this.fCurrentOffset;
        this.skipPastName(c);
        int n2 = this.fCurrentOffset - n;
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.addSymbol(n, n2);
        return n3;
    }

    public int scanName(char c) throws Exception {
        int n = this.fCurrentOffset;
        this.skipPastName(c);
        int n2 = this.fCurrentOffset - n;
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.addSymbol(n, n2);
        return n3;
    }

    private int recognizeMarkup() throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        switch (n) {
            case -1: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                n = this.getChar(this.fCurrentOffset);
                if (n == -1) {
                    --this.fCharacterCounter;
                    this.fCurrentOffset -= this.fBytesPerChar;
                    return 11;
                }
                if (n == 45) {
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                    n = this.getChar(this.fCurrentOffset);
                    if (n == -1) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (n != 45) break;
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                    return 1;
                }
                if (n != 91) break;
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                int n2 = 0;
                while (n2 < 6) {
                    n = this.getChar(this.fCurrentOffset);
                    if (n == -1) {
                        this.fCharacterCounter -= 2 + n2;
                        this.fCurrentOffset -= (2 + n2) * this.fBytesPerChar;
                        return 11;
                    }
                    if (n != cdata_string[n2]) {
                        return 10;
                    }
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                    ++n2;
                }
                return 2;
            }
            case 47: {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference() throws Exception {
        int n = this.getChar(this.fCurrentOffset);
        if (n == -1) {
            return 12;
        }
        if (n == 35) {
            ++this.fCharacterCounter;
            this.fCurrentOffset += this.fBytesPerChar;
            return 7;
        }
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanContent(int n) throws Exception {
        byte by;
        int n2;
        int n3;
        block46: {
            block51: {
                block50: {
                    block48: {
                        block49: {
                            n3 = this.fCurrentOffset;
                            n2 = this.getChar(this.fCurrentOffset);
                            this.fCurrentOffset += this.fBytesPerChar;
                            if (n2 >= 128) break block48;
                            if (n2 == -1) {
                                this.fCurrentOffset -= this.fBytesPerChar;
                                return this.changeReaders().scanContent(n);
                            }
                            by = XMLCharacterProperties.fgCharFlags[n2];
                            if ((by & 1) != 0 || n2 == 10 || n2 == 13) break block49;
                            if (n2 == 60) {
                                ++this.fCharacterCounter;
                                if (!this.fInCDSect) {
                                    return this.recognizeMarkup();
                                }
                                break block46;
                            } else if (n2 == 38) {
                                ++this.fCharacterCounter;
                                if (!this.fInCDSect) {
                                    return this.recognizeReference();
                                }
                                break block46;
                            } else {
                                if (n2 != 93) {
                                    this.fCurrentOffset -= this.fBytesPerChar;
                                    return 9;
                                }
                                if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                                    this.fCharacterCounter += 3;
                                    this.fCurrentOffset += 2 * this.fBytesPerChar;
                                    return 3;
                                }
                            }
                            break block46;
                        }
                        if (n2 != 32 && n2 != 9 && n2 != 10 && n2 != 13) break block46;
                        break block50;
                    }
                    if (n2 >= 55296 && n2 <= 57343) {
                        this.fCurrentOffset += this.fBytesPerChar;
                        break block46;
                    } else if (n2 == 65534 || n2 == 65535) {
                        this.fCurrentOffset -= this.fBytesPerChar;
                        return 9;
                    }
                    break block46;
                }
                do {
                    if (n2 == 10) {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                    } else if (n2 == 13) {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                    } else {
                        ++this.fCharacterCounter;
                    }
                    n2 = this.getChar(this.fCurrentOffset);
                    this.fCurrentOffset += this.fBytesPerChar;
                } while (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13);
                if (n2 >= 128) break block51;
                if (n2 == -1) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    this.callCharDataHandler(n3, this.fCurrentOffset - n3, true);
                    return this.changeReaders().scanContent(n);
                }
                by = XMLCharacterProperties.fgCharFlags[n2];
                if ((by & 1) == 0) {
                    if (n2 == 60) {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(n3, this.fCurrentOffset - this.fBytesPerChar - n3, true);
                            ++this.fCharacterCounter;
                            return this.recognizeMarkup();
                        }
                        ++this.fCharacterCounter;
                        break block46;
                    } else if (n2 == 38) {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(n3, this.fCurrentOffset - this.fBytesPerChar - n3, true);
                            ++this.fCharacterCounter;
                            return this.recognizeReference();
                        }
                        ++this.fCharacterCounter;
                        break block46;
                    } else {
                        if (n2 != 93) {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            this.callCharDataHandler(n3, this.fCurrentOffset - n3, true);
                            return 9;
                        }
                        if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                            this.callCharDataHandler(n3, this.fCurrentOffset - this.fBytesPerChar - n3, true);
                            this.fCharacterCounter += 3;
                            this.fCurrentOffset += 2 * this.fBytesPerChar;
                            return 3;
                        }
                    }
                }
                break block46;
            }
            if (n2 >= 55296 && n2 <= 57343) {
                this.fCurrentOffset += this.fBytesPerChar;
            } else if (n2 == 65534 || n2 == 65535) {
                this.fCurrentOffset -= this.fBytesPerChar;
                this.callCharDataHandler(n3, this.fCurrentOffset - n3, true);
                return 9;
            }
        }
        ++this.fCharacterCounter;
        while (true) {
            n2 = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
            if (n2 >= 128 || n2 < 0) break;
            by = XMLCharacterProperties.fgCharFlags[n2];
            if ((by & 1) == 0) {
                if (n2 == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    continue;
                }
                if (n2 != 13) break;
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                continue;
            }
            ++this.fCharacterCounter;
        }
        while (true) {
            block47: {
                block52: {
                    block53: {
                        block55: {
                            block54: {
                                if (n2 >= 128) break block52;
                                if (n2 == -1) {
                                    this.fCurrentOffset -= this.fBytesPerChar;
                                    this.callCharDataHandler(n3, this.fCurrentOffset - n3, false);
                                    return this.changeReaders().scanContent(n);
                                }
                                by = XMLCharacterProperties.fgCharFlags[n2];
                                if ((by & 1) != 0) break block53;
                                if (n2 != 60) break block54;
                                if (!this.fInCDSect) {
                                    this.callCharDataHandler(n3, this.fCurrentOffset - this.fBytesPerChar - n3, false);
                                    ++this.fCharacterCounter;
                                    return this.recognizeMarkup();
                                }
                                ++this.fCharacterCounter;
                                break block47;
                            }
                            if (n2 != 38) break block55;
                            if (!this.fInCDSect) {
                                this.callCharDataHandler(n3, this.fCurrentOffset - this.fBytesPerChar - n3, false);
                                ++this.fCharacterCounter;
                                return this.recognizeReference();
                            }
                            ++this.fCharacterCounter;
                            break block47;
                        }
                        if (n2 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            break block47;
                        } else if (n2 == 13) {
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            break block47;
                        } else {
                            if (n2 != 93) {
                                this.fCurrentOffset -= this.fBytesPerChar;
                                this.callCharDataHandler(n3, this.fCurrentOffset - n3, false);
                                return 9;
                            }
                            if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                                this.callCharDataHandler(n3, this.fCurrentOffset - this.fBytesPerChar - n3, false);
                                this.fCharacterCounter += 3;
                                this.fCurrentOffset += 2 * this.fBytesPerChar;
                                return 3;
                            }
                            ++this.fCharacterCounter;
                        }
                        break block47;
                    }
                    ++this.fCharacterCounter;
                    break block47;
                }
                if (n2 >= 55296 && n2 <= 57343) {
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                } else if (n2 == 65534 || n2 == 65535) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    this.callCharDataHandler(n3, this.fCurrentOffset - n3, false);
                    return 9;
                }
                ++this.fCharacterCounter;
            }
            n2 = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
        }
    }
}

