/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xalan.xpath.xml.BoolStack;
import org.apache.xalan.xpath.xml.ElemDesc;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.apache.xalan.xpath.xml.Trie;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xml.serialize.OutputFormat;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class FormatterToHTML
extends FormatterToXML {
    BoolStack m_isRawStack = new BoolStack();
    boolean m_inBlockElem = false;
    static String[] s_HTMLlat1 = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    static String[] HTMLsymbol1 = new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron", "Pi", "Rho", "", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega"};
    static String[] HTMLsymbol2 = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv"};
    static Trie m_elementFlags = new Trie();
    private static ElemDesc m_dummy;
    String m_currentElementName;
    static final int MASK1 = 65280;
    static final int MASK2 = 255;

    ElemDesc getElemDesc(String string) {
        Object object;
        if (string != null && (object = m_elementFlags.get(string)) != null) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public FormatterToHTML() {
    }

    public FormatterToHTML(Writer writer) {
        super(writer);
        FormatterToXML.initEncodings();
    }

    public FormatterToHTML(OutputStream outputStream) throws UnsupportedEncodingException {
        FormatterToXML.initEncodings();
        this.init(outputStream, new OutputFormat("html", "UTF-8", false));
    }

    public FormatterToHTML(FormatterToXML formatterToXML) {
        super(formatterToXML);
        this.m_doIndent = true;
    }

    protected void initAttrCharsMap() {
        super.initAttrCharsMap();
        this.m_attrCharsMap[10] = 83;
        this.m_attrCharsMap[60] = '\u0000';
        this.m_attrCharsMap[62] = '\u0000';
        this.m_charsMap[10] = 83;
        this.m_charsMap[13] = 83;
    }

    protected void initCharsMap() {
        this.initAttrCharsMap();
        int n = this.m_maxCharacter > '\u0100' ? 256 : (int)this.m_maxCharacter;
        int n2 = 0;
        while (n2 < n) {
            this.m_charsMap[n2] = '\u0000';
            ++n2;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[60] = 83;
        this.m_charsMap[62] = 83;
        this.m_charsMap[38] = 83;
        int n3 = 0;
        while (n3 < 10) {
            this.m_charsMap[n3] = 83;
            ++n3;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[13] = 83;
        n = 256;
        int n4 = 160;
        while (n4 < n) {
            this.m_charsMap[n4] = 83;
            ++n4;
        }
        int n5 = this.m_maxCharacter;
        while (n5 < 256) {
            this.m_charsMap[n5] = 83;
            ++n5;
        }
    }

    public void startDocument() throws SAXException {
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.m_shouldNotWriteXMLHeader = true;
        if (this.m_needToOutputDocTypeDecl && (this.m_doctypeSystem != null || this.m_doctypePublic != null)) {
            this.accum("<!DOCTYPE HTML");
            if (this.m_doctypePublic != null) {
                this.accum(" PUBLIC \"");
                this.accum(this.m_doctypePublic);
                this.accum("\"");
            }
            if (this.m_doctypeSystem != null) {
                if (this.m_doctypePublic == null) {
                    this.accum(" SYSTEM \"");
                } else {
                    this.accum(" \"");
                }
                this.accum(this.m_doctypeSystem);
                this.accum("\"");
            }
            this.accum(">");
            this.accum(this.m_lineSep);
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        boolean bl = this.m_doIndent;
        this.writeParentTagEnd();
        String string2 = string.toUpperCase();
        ElemDesc elemDesc = this.getElemDesc(string2);
        boolean bl2 = elemDesc.is(8);
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && this.m_currentElementName != null && (!this.m_inBlockElem || bl2)) {
            this.m_startNewLine = true;
            this.indent(this.m_currentIndent);
        }
        this.m_inBlockElem = !bl2;
        this.m_isRawStack.push(elemDesc.is(256));
        this.m_currentElementName = string2;
        this.accum('<');
        this.accum(string);
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.processAttribute(attributeList.getName(n2), elemDesc, attributeList.getValue(n2));
            ++n2;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.indent;
        this.m_isprevtext = false;
        this.m_doIndent = bl;
    }

    public void endElement(String string) throws SAXException {
        this.m_currentIndent -= this.indent;
        boolean bl = this.childNodesWereAdded();
        this.m_isRawStack.pop();
        String string2 = string.toUpperCase();
        ElemDesc elemDesc = this.getElemDesc(string2);
        boolean bl2 = elemDesc.is(8);
        boolean bl3 = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || bl2)) {
            this.m_startNewLine = true;
            bl3 = true;
        }
        boolean bl4 = this.m_inBlockElem = !bl2;
        if (bl) {
            if (bl3) {
                this.indent(this.m_currentIndent);
            }
            this.accum("</");
            this.accum(string);
            this.accum('>');
            this.m_currentElementName = string;
        } else if (!elemDesc.is(2)) {
            this.accum('>');
            if (bl3) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('/');
            this.accum(string);
            this.accum('>');
        } else {
            this.accum('>');
        }
        if (elemDesc.is(0x200000)) {
            this.m_ispreserve = true;
        }
        if (bl && !this.m_preserves.isEmpty()) {
            this.m_preserves.pop();
        }
        this.m_isprevtext = false;
    }

    protected void processAttribute(String string, ElemDesc elemDesc, String string2) throws SAXException {
        String string3 = string.toUpperCase();
        this.accum(' ');
        if (elemDesc.isAttrFlagSet(string3, 4) && (string2.length() == 0 || string2.equalsIgnoreCase(string))) {
            this.accum(string);
            return;
        }
        this.accum(string);
        this.accum('=');
        this.accum('\"');
        if (elemDesc.isAttrFlagSet(string3, 2)) {
            this.writeAttrURI(string2, this.m_encoding);
        } else {
            this.writeAttrString(string2, this.m_encoding);
        }
        this.accum('\"');
    }

    public void writeAttrURI(String string, String string2) throws SAXException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '\t' || c > '\u007f' || c == '\"' || c == ' ') {
                int n3 = (c & 0xFF00) >> 8;
                int n4 = c & 0xFF;
                if (n3 != 0) {
                    this.accum("%");
                    this.accum(Integer.toHexString(n3));
                }
                this.accum("%");
                this.accum(Integer.toHexString(n4));
            } else {
                this.accum(c);
            }
            ++n2;
        }
    }

    public void writeAttrString(String string, String string2) throws SAXException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '\u0100' && this.m_attrCharsMap[c] != 'S') {
                this.accum(c);
            } else if (c == '&' && n2 + 1 < n && cArray[n2 + 1] == '{') {
                this.accum(c);
            } else if (!this.accumDefaultEntity(c, n2, cArray, n, false)) {
                if (c >= '\ud800' && c < '\udc00') {
                    int n3;
                    if (n2 + 1 >= n) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c)}));
                    }
                    if ((n3 = cArray[++n2]) < 56320 || n3 >= 57344) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c)) + " " + Integer.toHexString(n3)}));
                    }
                    n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
                    this.accum("&#x");
                    this.accum(Integer.toHexString(n3));
                    this.accum(';');
                } else if (c >= '\u00a0' && c <= '\u00ff') {
                    this.accum('&');
                    this.accum(s_HTMLlat1[c - 160]);
                    this.accum(';');
                } else if (c >= '\u0391' && c <= '\u03a9' && c != '\u03a2') {
                    this.accum('&');
                    this.accum(HTMLsymbol1[c - 913]);
                    this.accum(';');
                } else if (c >= '\u03b1' && c <= '\u03c9') {
                    this.accum('&');
                    this.accum(HTMLsymbol2[c - 945]);
                    this.accum(';');
                } else if (c >= '\u03d1' && c <= '\u03d2') {
                    this.accum('&');
                    this.accum(HTMLsymbol2[c - 945 - 7]);
                    this.accum(';');
                } else if (c == '\u03d6') {
                    this.accum('&');
                    this.accum(HTMLsymbol2[c - 945 - 10]);
                    this.accum(';');
                } else if (c == '\u0192') {
                    this.accum("&fnof;");
                } else {
                    this.accum("&#x");
                    this.accum(Integer.toHexString(c));
                    this.accum(';');
                }
            }
            ++n2;
        }
    }

    private int copyEntityIntoBuf(String string, int n) throws SAXException {
        int n2 = string.length();
        this.accum('&');
        int n3 = 0;
        while (n3 < n2) {
            this.accum(string.charAt(n3));
            ++n3;
        }
        this.accum(';');
        return n;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_nextIsRaw) {
            this.m_nextIsRaw = false;
            this.charactersRaw(cArray, n, n2);
            return;
        }
        if (!this.m_isRawStack.isEmpty() && this.m_isRawStack.peek()) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(cArray, n, n2, false);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XSLMessages.createXPATHMessage(66, null), iOException);
            }
        }
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            char c = cArray[n5];
            if (c < '\u0100' && this.m_charsMap[c] != 'S') {
                this.accum(c);
            } else {
                int n6;
                if (c == '\n' && n5 + 1 < n4 && cArray[n5 + 1] == '\r') {
                    this.outputLineSep();
                    ++n5;
                }
                if (c == '\r' && n5 + 1 < n4 && cArray[n5 + 1] == '\n') {
                    this.outputLineSep();
                    ++n5;
                } else if (c == '\r') {
                    this.outputLineSep();
                    ++n5;
                } else if (c == '\n') {
                    this.outputLineSep();
                } else if (c == '<') {
                    n3 = this.copyEntityIntoBuf("lt", n3);
                } else if (c == '>') {
                    n3 = this.copyEntityIntoBuf("gt", n3);
                } else if (c == '&') {
                    n3 = this.copyEntityIntoBuf("amp", n3);
                } else if (c >= '\t' && c <= '~') {
                    this.accum(c);
                } else if (c >= '\u00a0' && c <= '\u00ff') {
                    n3 = this.copyEntityIntoBuf(s_HTMLlat1[c - 160], n3);
                } else if (c >= '\u0391' && c <= '\u03a9' && c != '\u03a2') {
                    n3 = this.copyEntityIntoBuf(HTMLsymbol1[c - 913], n3);
                } else if (c >= '\u03b1' && c <= '\u03c9') {
                    n3 = this.copyEntityIntoBuf(HTMLsymbol2[c - 945], n3);
                } else if (c >= '\u03d1' && c <= '\u03d2') {
                    n3 = this.copyEntityIntoBuf(HTMLsymbol2[c - 945 - 7], n3);
                } else if (c == '\u03d6') {
                    n3 = this.copyEntityIntoBuf(HTMLsymbol2[c - 945 - 10], n3);
                } else if (c == '\u0192') {
                    n3 = this.copyEntityIntoBuf("fnof", n3);
                } else if (this.m_isUTF8 && c >= '\ud800' && c < '\udc00') {
                    int n7;
                    if (n5 + 1 >= n2) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c)}));
                    }
                    if ((n7 = cArray[++n5]) < 56320 || n7 >= 57344) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c)) + " " + Integer.toHexString(n7)}));
                    }
                    n7 = (c - 55296 << 10) + n7 - 56320 + 65536;
                    this.accum('&');
                    this.accum('#');
                    String string = Integer.toString(n7);
                    n6 = string.length();
                    int n8 = 0;
                    while (n8 < n6) {
                        this.accum(string.charAt(n8));
                        ++n8;
                    }
                    this.accum(';');
                } else if (c >= '\u007f' && c <= this.m_maxCharacter) {
                    this.accum(c);
                } else {
                    this.accum('&');
                    this.accum('#');
                    String string = Integer.toString(c);
                    int n9 = string.length();
                    n6 = 0;
                    while (n6 < n9) {
                        this.accum(string.charAt(n6));
                        ++n6;
                    }
                    this.accum(';');
                }
            }
            ++n5;
        }
        this.m_isprevtext = true;
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_currentElementName != null && (this.m_currentElementName.equalsIgnoreCase("SCRIPT") || this.m_currentElementName.equalsIgnoreCase("STYLE"))) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(cArray, n, n2, true);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XSLMessages.createXPATHMessage(66, null), iOException);
            }
        }
        super.cdata(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equals("xslt-next-is-raw") && string2.equals("formatter-to-dom")) {
            this.m_nextIsRaw = true;
            return;
        }
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("<?" + string);
        if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
            this.accum(" ");
        }
        this.accum(String.valueOf(string2) + ">");
        this.m_startNewLine = true;
    }

    public void entityReference(String string) throws SAXException {
        this.accum("&");
        this.accum(string);
        this.accum(";");
    }

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(8));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("READONLY", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        m_dummy = new ElemDesc(8);
    }
}

