/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xalan.xpath.ExtensionFunctionHandler;
import org.apache.xalan.xpath.NodeCallback;
import org.apache.xalan.xpath.SimpleNodeLocator;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.IntStack;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XPathSupportDefault
implements XPathSupport {
    private IntStack m_contextCounts = new IntStack();
    private Stack m_contextNodeLists = new Stack();
    private Stack m_xpathContextStates = new Stack();
    private XPathContext m_dummyXPathContext = new XPathContext(null, null, null, null);
    private boolean m_throwFoundIndex = false;
    private Node m_currentNode;
    private PrefixResolver m_currentPrefixResolver;
    boolean m_processNamespaces;
    private NodeCallback m_callback;
    private Object m_callbackInfo;

    public void pushXPathContext(XPath xPath, XPathSupport xPathSupport, Node node, PrefixResolver prefixResolver) {
        XPathContext xPathContext = new XPathContext(xPath, xPathSupport, node, prefixResolver);
        this.m_xpathContextStates.push(xPathContext);
    }

    public void popXPathContext() {
        this.m_xpathContextStates.pop();
    }

    public void pushDummyXPathContext() {
        this.m_xpathContextStates.push(this.m_dummyXPathContext);
    }

    public XObject reExecuteXPathContext(XPath xPath, XPathSupport xPathSupport, Node node) throws SAXException {
        int n = this.m_xpathContextStates.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            XPathContext xPathContext = (XPathContext)this.m_xpathContextStates.elementAt(n2);
            if (xPathContext.xpath == null) {
                return null;
            }
            if (xPathContext.contextNode != node || xPathContext.xpath != xPath || xPathContext.execContext != node) {
                return xPathContext.execute();
            }
            --n2;
        }
        return null;
    }

    public int getContextNodePosition() {
        if (!this.m_contextCounts.empty()) {
            return this.m_contextCounts.peek();
        }
        return -200;
    }

    public void setContextNodePosition(int n) {
        this.m_contextCounts.setTop(n);
    }

    public void incrementContextNodePosition(Node node) {
        int n = this.getContextNodePosition() + 1;
        this.m_contextCounts.setTop(n);
    }

    public void decrementContextNodePosition() {
        this.m_contextCounts.setTop(this.getContextNodePosition() - 1);
    }

    public void pushContextNodePosition() {
        this.m_contextNodeLists.push(null);
        this.m_contextCounts.push(0);
    }

    public void popContextNodePosition() {
        this.m_contextNodeLists.pop();
        this.m_contextCounts.pop();
    }

    public NodeList getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (NodeList)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public void pushContextNodeList(NodeList nodeList) {
        this.m_contextCounts.push(-200);
        this.m_contextNodeLists.push(nodeList);
    }

    public void popContextNodeList() {
        this.m_contextCounts.pop();
        this.m_contextNodeLists.pop();
    }

    public boolean getThrowFoundIndex() {
        return this.m_throwFoundIndex;
    }

    public void setThrowFoundIndex(boolean bl) {
        this.m_throwFoundIndex = bl;
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public void setCurrentNode(Node node) {
        this.m_currentNode = node;
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }

    public String getNamespaceForPrefix(String string, Element element) {
        if (this.m_currentPrefixResolver != null) {
            return this.m_currentPrefixResolver.getNamespaceForPrefix(string, element);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNamespaceOfNode(Node node) {
        String string;
        String string2 = node.getNodeName();
        int n = string2.indexOf(58);
        short s = node.getNodeType();
        if (s == 2) {
            if (n <= 0) return null;
            string = string2.substring(0, n);
        } else {
            String string3 = string = n >= 0 ? string2.substring(0, n) : "";
        }
        if (this.m_currentPrefixResolver == null) return string;
        return this.m_currentPrefixResolver.getNamespaceForPrefix(string, node);
    }

    public String getLocalNameOfNode(Node node) {
        String string = node.getNodeName();
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public Node getParentOfNode(Node node) {
        return node.getParentNode();
    }

    public XObject getVariable(QName qName) throws SAXException {
        return new XString("Unknown variable: name");
    }

    public boolean isIgnorableWhitespace(Text text) {
        return false;
    }

    public NodeList getNodeSetByKey(Node node, String string, String string2, PrefixResolver prefixResolver) throws SAXException {
        return null;
    }

    public Hashtable getSourceDocsTable() {
        return null;
    }

    public String findURIFromDoc(Document document) {
        return "unknown";
    }

    public Document parseXML(String string, String string2) {
        return null;
    }

    public Element getElementByID(String string, Document document) {
        return null;
    }

    public String getUnparsedEntityURI(String string, Document document) {
        return "";
    }

    public void setDOMFactory(Document document) {
        throw new RuntimeException(XSLMessages.createXPATHMessage(51, null));
    }

    public Document getDOMFactory() {
        return null;
    }

    public boolean problem(short s, short s2, Node node, Node node2, String string, int n, int n2) {
        System.out.println(string);
        return true;
    }

    public boolean functionAvailable(String string, String string2) {
        return false;
    }

    public boolean elementAvailable(String string, String string2) {
        return false;
    }

    public Object extFunction(String string, String string2, Vector vector, Object object) throws SAXException {
        return null;
    }

    public Node getRoot(Node node) {
        Node node2 = null;
        while (node != null) {
            node2 = node;
            node = this.getParentOfNode(node);
        }
        return node2;
    }

    public void associateXLocatorToNode(Node node, XLocator xLocator) {
    }

    public XLocator getXLocatorFromNode(Node node) {
        return SimpleNodeLocator.getDefaultLocator();
    }

    public void setProcessNamespaces(boolean bl) {
        this.m_processNamespaces = bl;
    }

    public boolean getProcessNamespaces() {
        return this.m_processNamespaces;
    }

    public boolean shouldStripSourceNode(Node node) throws SAXException {
        return false;
    }

    public Document parseXML(URL uRL, DocumentHandler documentHandler, Document document) throws SAXException {
        return null;
    }

    public URL getURLFromString(String string, String string2) throws SAXException {
        return null;
    }

    public void addExtensionNamespace(String string, ExtensionFunctionHandler extensionFunctionHandler) {
    }

    public void setCallback(NodeCallback nodeCallback, Object object) {
        this.m_callback = nodeCallback;
        this.m_callbackInfo = object;
    }

    public NodeCallback getCallback() {
        return this.m_callback;
    }

    public Object getCallbackInfo() {
        return this.m_callbackInfo;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public XLocator createXLocatorHandler() {
        return new SimpleNodeLocator();
    }

    class XPathContext {
        XPath xpath;
        XPathSupport execContext;
        Node contextNode;
        PrefixResolver namespaceContext;
        int contextNodePosition;
        NodeList contextNodeList;
        XObject result;

        XPathContext(XPath xPath, XPathSupport xPathSupport, Node node, PrefixResolver prefixResolver) {
            XPathSupportDefault.this = XPathSupportDefault.this;
            this.xpath = xPath;
            this.execContext = xPathSupport;
            this.namespaceContext = prefixResolver;
            this.contextNode = node;
            if (XPathSupportDefault.this.m_contextCounts.empty()) {
                this.contextNodePosition = -200;
                this.contextNodeList = null;
                return;
            }
            this.contextNodePosition = XPathSupportDefault.this.getContextNodePosition();
            this.contextNodeList = XPathSupportDefault.this.getContextNodeList();
        }

        XObject execute() throws SAXException {
            if (this.result != null) {
                return this.result;
            }
            XPathSupportDefault.this.m_contextNodeLists.push(this.contextNodeList);
            XPathSupportDefault.this.m_contextCounts.push(this.contextNodePosition);
            try {
                this.result = this.xpath.execute(this.execContext, this.contextNode, this.namespaceContext);
            }
            finally {
                Object var2_1 = null;
                XPathSupportDefault.this.m_contextNodeLists.pop();
                XPathSupportDefault.this.m_contextCounts.pop();
            }
            return this.result;
        }
    }
}

