/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import org.apache.xerces.validators.dtd.CMException;

class CMStateSet {
    int fBitCount;
    int fByteCount;
    int fBits1;
    int fBits2;
    byte[] fByteArray;

    CMStateSet(int n) throws CMException {
        this.fBitCount = n;
        if (this.fBitCount < 0) {
            throw new CMException(7);
        }
        if (this.fBitCount > 64) {
            this.fByteCount = this.fBitCount / 8;
            if (this.fBitCount % 8 != 0) {
                ++this.fByteCount;
            }
            this.fByteArray = new byte[this.fByteCount];
        }
        this.zeroBits();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("{");
            int n = 0;
            while (n < this.fBitCount) {
                if (this.getBit(n)) {
                    stringBuffer.append(" " + n);
                }
                ++n;
            }
            stringBuffer.append(" }");
        }
        catch (CMException cMException) {}
        return stringBuffer.toString();
    }

    final void intersection(CMStateSet cMStateSet) {
        if (this.fBitCount < 65) {
            this.fBits1 &= cMStateSet.fBits1;
            this.fBits2 &= cMStateSet.fBits2;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            int n2 = n;
            this.fByteArray[n2] = (byte)(this.fByteArray[n2] & cMStateSet.fByteArray[n]);
            --n;
        }
    }

    final boolean getBit(int n) throws CMException {
        if (n >= this.fBitCount) {
            throw new CMException(7);
        }
        if (this.fBitCount < 65) {
            int n2 = 1 << n % 32;
            if (n < 32) {
                return (this.fBits1 & n2) != 0;
            }
            return (this.fBits2 & n2) != 0;
        }
        int n3 = n >> 3;
        byte by = (byte)(1 << n % 8);
        return (this.fByteArray[n3] & by) != 0;
    }

    final boolean isEmpty() {
        if (this.fBitCount < 65) {
            return this.fBits1 == 0 && this.fBits2 == 0;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            if (this.fByteArray[n] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    final boolean isSameSet(CMStateSet cMStateSet) {
        if (this.fBitCount != cMStateSet.fBitCount) {
            return false;
        }
        if (this.fBitCount < 65) {
            return this.fBits1 == cMStateSet.fBits1 && this.fBits2 == cMStateSet.fBits2;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            if (this.fByteArray[n] != cMStateSet.fByteArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    final void union(CMStateSet cMStateSet) {
        if (this.fBitCount < 65) {
            this.fBits1 |= cMStateSet.fBits1;
            this.fBits2 |= cMStateSet.fBits2;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            int n2 = n;
            this.fByteArray[n2] = (byte)(this.fByteArray[n2] | cMStateSet.fByteArray[n]);
            --n;
        }
    }

    final void setBit(int n) throws CMException {
        int n2;
        if (n >= this.fBitCount) {
            throw new CMException(7);
        }
        if (this.fBitCount < 65) {
            int n3 = 1 << n % 32;
            if (n < 32) {
                this.fBits1 &= ~n3;
                this.fBits1 |= n3;
                return;
            }
            this.fBits2 &= ~n3;
            this.fBits2 |= n3;
            return;
        }
        byte by = (byte)(1 << n % 8);
        int n4 = n2 = n >> 3;
        this.fByteArray[n4] = (byte)(this.fByteArray[n4] & ~by);
        int n5 = n2;
        this.fByteArray[n5] = (byte)(this.fByteArray[n5] | by);
    }

    final void setTo(CMStateSet cMStateSet) throws CMException {
        if (this.fBitCount != cMStateSet.fBitCount) {
            throw new CMException(7);
        }
        if (this.fBitCount < 65) {
            this.fBits1 = cMStateSet.fBits1;
            this.fBits2 = cMStateSet.fBits2;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            this.fByteArray[n] = cMStateSet.fByteArray[n];
            --n;
        }
    }

    final void zeroBits() {
        if (this.fBitCount < 65) {
            this.fBits1 = 0;
            this.fBits2 = 0;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            this.fByteArray[n] = 0;
            --n;
        }
    }
}

