/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.HtmlFileListParser;

public class LightweightHttpWagon
extends StreamWagon {
    private String previousProxyExclusions;
    private String previousHttpProxyHost;
    private String previousHttpsProxyHost;
    private String previousHttpProxyPort;
    private String previousHttpsProxyPort;
    private HttpURLConnection putConnection;
    private boolean useCache;

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        Resource resource = inputData.getResource();
        try {
            boolean isGZipped;
            URL url = this.resolveResourceURL(resource);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Accept-Encoding", "gzip");
            if (!this.useCache) {
                urlConnection.setRequestProperty("Pragma", "no-cache");
            }
            InputStream is = urlConnection.getInputStream();
            String contentEncoding = urlConnection.getHeaderField("Content-Encoding");
            boolean bl = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding);
            if (isGZipped) {
                is = new GZIPInputStream(is);
            }
            inputData.setInputStream(is);
            resource.setLastModified(urlConnection.getLastModified());
            resource.setContentLength(urlConnection.getContentLength());
        }
        catch (MalformedURLException e) {
            throw new ResourceDoesNotExistException("Invalid repository URL", e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Unable to locate resource in repository", e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        try {
            URL url = this.resolveResourceURL(resource);
            this.putConnection = (HttpURLConnection)url.openConnection();
            this.putConnection.setRequestMethod("PUT");
            this.putConnection.setDoOutput(true);
            outputData.setOutputStream(this.putConnection.getOutputStream());
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
    }

    private URL resolveResourceURL(Resource resource) throws MalformedURLException {
        String repositoryUrl = this.getRepository().getUrl();
        URL url = repositoryUrl.endsWith("/") ? new URL(repositoryUrl + resource.getName()) : new URL(repositoryUrl + "/" + resource.getName());
        return url;
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        super.put(source, resourceName);
        try {
            String url = this.getRepository().getUrl() + "/" + resourceName;
            int statusCode = this.putConnection.getResponseCode();
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                }
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        boolean hasAuthentication;
        this.previousHttpProxyHost = System.getProperty("http.proxyHost");
        this.previousHttpProxyPort = System.getProperty("http.proxyPort");
        this.previousHttpsProxyHost = System.getProperty("https.proxyHost");
        this.previousHttpsProxyPort = System.getProperty("https.proxyPort");
        this.previousProxyExclusions = System.getProperty("http.nonProxyHosts");
        final ProxyInfo proxyInfo = this.proxyInfo;
        if (proxyInfo != null) {
            System.setProperty("http.proxyHost", proxyInfo.getHost());
            System.setProperty("https.proxyHost", proxyInfo.getHost());
            System.setProperty("http.proxyPort", String.valueOf(proxyInfo.getPort()));
            System.setProperty("https.proxyPort", String.valueOf(proxyInfo.getPort()));
            if (proxyInfo.getNonProxyHosts() != null) {
                System.setProperty("http.nonProxyHosts", proxyInfo.getNonProxyHosts());
            }
        }
        final boolean hasProxy = proxyInfo != null && proxyInfo.getUserName() != null;
        boolean bl = hasAuthentication = this.authenticationInfo != null && this.authenticationInfo.getUserName() != null;
        if (hasProxy || hasAuthentication) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyInfo.getHost()) && this.getRequestingPort() == proxyInfo.getPort()) {
                        String password = "";
                        if (proxyInfo.getPassword() != null) {
                            password = proxyInfo.getPassword();
                        }
                        return new PasswordAuthentication(proxyInfo.getUserName(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        String password = "";
                        if (LightweightHttpWagon.this.authenticationInfo.getPassword() != null) {
                            password = LightweightHttpWagon.this.authenticationInfo.getPassword();
                        }
                        return new PasswordAuthentication(LightweightHttpWagon.this.authenticationInfo.getUserName(), password.toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        }
    }

    public void closeConnection() throws ConnectionException {
        if (this.putConnection != null) {
            this.putConnection.disconnect();
        }
        if (this.previousHttpProxyHost != null) {
            System.setProperty("http.proxyHost", this.previousHttpProxyHost);
        }
        if (this.previousHttpsProxyHost != null) {
            System.setProperty("https.proxyHost", this.previousHttpsProxyHost);
        }
        if (this.previousHttpProxyPort != null) {
            System.setProperty("http.proxyPort", this.previousHttpProxyPort);
        }
        if (this.previousHttpsProxyPort != null) {
            System.setProperty("https.proxyPort", this.previousHttpsProxyPort);
        }
        if (this.previousProxyExclusions != null) {
            System.setProperty("http.nonProxyHosts", this.previousProxyExclusions);
        }
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputData inputData = new InputData();
        if (!destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        Resource resource = new Resource(destinationDirectory);
        inputData.setResource(resource);
        this.fillInputData(inputData);
        InputStream is = inputData.getInputStream();
        if (is == null) {
            throw new TransferFailedException(url + " - Could not open input stream for resource: '" + resource + "'");
        }
        return HtmlFileListParser.parseFileList(url, is);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            URL url = this.resolveResourceURL(new Resource(resourceName));
            HttpURLConnection headConnection = (HttpURLConnection)url.openConnection();
            headConnection.setRequestMethod("HEAD");
            headConnection.setDoOutput(true);
            int statusCode = headConnection.getResponseCode();
            switch (statusCode) {
                case 200: {
                    return true;
                }
                case 403: {
                    throw new AuthorizationException("Access denided to: " + url);
                }
                case 404: {
                    return false;
                }
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
        return false;
    }
}

