/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.BaseResourceLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryResourceLoader
extends BaseResourceLoader {
    private ConcurrentMap<String, String> items = new ConcurrentHashMap<String, String>();

    @Override
    public Reader open(String name) throws IOException {
        String content = (String)this.items.get(name);
        return content == null ? null : new StringReader(content);
    }

    @Override
    public Reader openOrFail(String name) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(name);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException(name);
        }
        return reader;
    }

    public void store(String name, String contents) {
        this.items.put(name, contents);
    }

    public void remove(String name) {
        this.items.remove(name);
    }

    public ConcurrentMap<String, String> getItems() {
        return this.items;
    }
}

