/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver;

import com.google.clearsilver.jsilver.DataLoader;
import com.google.clearsilver.jsilver.JSilverOptions;
import com.google.clearsilver.jsilver.TemplateRenderer;
import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.compiler.TemplateCompiler;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataFactory;
import com.google.clearsilver.jsilver.data.HDFDataFactory;
import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import com.google.clearsilver.jsilver.exceptions.JSilverException;
import com.google.clearsilver.jsilver.functions.Function;
import com.google.clearsilver.jsilver.functions.FunctionRegistry;
import com.google.clearsilver.jsilver.functions.TextFilter;
import com.google.clearsilver.jsilver.functions.bundles.ClearSilverCompatibleFunctions;
import com.google.clearsilver.jsilver.interpreter.InterpretedTemplateLoader;
import com.google.clearsilver.jsilver.interpreter.LoadingTemplateFactory;
import com.google.clearsilver.jsilver.interpreter.OptimizerProvider;
import com.google.clearsilver.jsilver.interpreter.OptimizingTemplateFactory;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.output.InstanceOutputBufferProvider;
import com.google.clearsilver.jsilver.output.OutputBufferProvider;
import com.google.clearsilver.jsilver.output.ThreadLocalOutputBufferProvider;
import com.google.clearsilver.jsilver.precompiler.PrecompiledTemplateLoader;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.DataCommandConsolidator;
import com.google.clearsilver.jsilver.syntax.StructuralWhitespaceStripper;
import com.google.clearsilver.jsilver.syntax.SyntaxTreeOptimizer;
import com.google.clearsilver.jsilver.syntax.node.Switch;
import com.google.clearsilver.jsilver.template.DelegatingTemplateLoader;
import com.google.clearsilver.jsilver.template.HtmlWhiteSpaceStripper;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import java.io.IOException;
import java.util.LinkedList;

public final class JSilver
implements TemplateRenderer,
DataLoader {
    private final JSilverOptions options;
    private final TemplateLoader templateLoader;
    private final FunctionRegistry globalFunctions = new ClearSilverCompatibleFunctions();
    private final ResourceLoader defaultResourceLoader;
    private final DataFactory dataFactory;
    private final OutputBufferProvider outputBufferProvider;
    public static final String VAR_ESCAPE_MODE_KEY = "Config.VarEscapeMode";
    public static final String AUTO_ESCAPE_KEY = "Config.AutoEscape";

    public JSilver(ResourceLoader defaultResourceLoader, JSilverOptions options) {
        DelegatingTemplateLoader templateLoader;
        options = options.clone();
        this.defaultResourceLoader = defaultResourceLoader;
        this.dataFactory = new HDFDataFactory(options.getIgnoreAttributes(), options.getStringInternStrategy());
        this.options = options;
        int bufferSize = options.getInitialBufferSize();
        this.outputBufferProvider = options.getUseOutputBufferPool() ? new ThreadLocalOutputBufferProvider(bufferSize) : new InstanceOutputBufferProvider(bufferSize);
        TemplateFactory templateFactory = new LoadingTemplateFactory();
        templateFactory = this.setupOptimizerFactory(templateFactory);
        LinkedList<DelegatingTemplateLoader> delegatingTemplateLoaders = new LinkedList<DelegatingTemplateLoader>();
        AutoEscapeOptions autoEscapeOptions = new AutoEscapeOptions();
        autoEscapeOptions.setPropagateEscapeStatus(options.getPropagateEscapeStatus());
        autoEscapeOptions.setLogEscapedVariables(options.getLogEscapedVariables());
        if (options.getCompileTemplates()) {
            TemplateCompiler compiler = new TemplateCompiler(templateFactory, this.globalFunctions, autoEscapeOptions);
            delegatingTemplateLoaders.add(compiler);
            templateLoader = compiler;
        } else {
            InterpretedTemplateLoader interpreter = new InterpretedTemplateLoader(templateFactory, this.globalFunctions, autoEscapeOptions);
            delegatingTemplateLoaders.add(interpreter);
            templateLoader = interpreter;
        }
        if (options.getPrecompiledTemplateMap() != null) {
            PrecompiledTemplateLoader ptl = new PrecompiledTemplateLoader(templateLoader, options.getPrecompiledTemplateMap(), this.globalFunctions, autoEscapeOptions);
            delegatingTemplateLoaders.add(ptl);
            templateLoader = ptl;
        }
        for (DelegatingTemplateLoader loader : delegatingTemplateLoaders) {
            loader.setTemplateLoaderDelegate(templateLoader);
        }
        this.templateLoader = templateLoader;
    }

    private TemplateFactory setupOptimizerFactory(TemplateFactory templateFactory) {
        OptimizerProvider dataCommandConsolidatorProvider = new OptimizerProvider(){

            public Switch getOptimizer() {
                return new DataCommandConsolidator();
            }
        };
        OptimizerProvider syntaxTreeOptimizerProvider = new OptimizerProvider(){

            public Switch getOptimizer() {
                return new SyntaxTreeOptimizer();
            }
        };
        OptimizerProvider stripStructuralWhitespaceProvider = null;
        if (this.options.getStripStructuralWhiteSpace()) {
            stripStructuralWhitespaceProvider = new OptimizerProvider(){

                public Switch getOptimizer() {
                    return new StructuralWhitespaceStripper();
                }
            };
        }
        return new OptimizingTemplateFactory(templateFactory, dataCommandConsolidatorProvider, syntaxTreeOptimizerProvider, stripStructuralWhitespaceProvider);
    }

    @Deprecated
    public JSilver(ResourceLoader defaultResourceLoader, boolean cacheTemplates) {
        this(defaultResourceLoader, new JSilverOptions().setCacheTemplates(cacheTemplates));
    }

    public JSilver(ResourceLoader defaultResourceLoader) {
        this(defaultResourceLoader, new JSilverOptions());
    }

    public void render(String templateName, Data data, Appendable output, ResourceLoader resourceLoader) throws IOException, JSilverException {
        EscapeMode escapeMode = this.getEscapeMode(data);
        this.render(this.templateLoader.load(templateName, resourceLoader, escapeMode), data, output, resourceLoader);
    }

    public void render(String templateName, Data data, Appendable output) throws IOException, JSilverException {
        this.render(templateName, data, output, this.defaultResourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(String templateName, Data data) throws IOException, JSilverException {
        Appendable output = this.createAppendableBuffer();
        try {
            this.render(templateName, data, output);
            String string = output.toString();
            return string;
        }
        finally {
            this.releaseAppendableBuffer(output);
        }
    }

    public void render(Template template, Data data, Appendable output, ResourceLoader resourceLoader) throws IOException, JSilverException {
        if (this.options.getStripHtmlWhiteSpace() && !(output instanceof HtmlWhiteSpaceStripper)) {
            output = new HtmlWhiteSpaceStripper(output);
        }
        template.render(data, output, resourceLoader);
    }

    public void render(Template template, Data data, Appendable output) throws IOException, JSilverException {
        this.render(template, data, output, this.defaultResourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(Template template, Data data) throws IOException, JSilverException {
        Appendable output = this.createAppendableBuffer();
        try {
            this.render(template, data, output);
            String string = output.toString();
            return string;
        }
        finally {
            this.releaseAppendableBuffer(output);
        }
    }

    public void renderFromContent(String content, Data data, Appendable output) throws IOException, JSilverException {
        EscapeMode escapeMode = this.getEscapeMode(data);
        this.render(this.templateLoader.createTemp("[renderFromContent]", content, escapeMode), data, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderFromContent(String content, Data data) throws IOException, JSilverException {
        Appendable output = this.createAppendableBuffer();
        try {
            this.renderFromContent(content, data, output);
            String string = output.toString();
            return string;
        }
        finally {
            this.releaseAppendableBuffer(output);
        }
    }

    public EscapeMode getEscapeMode(Data data) {
        EscapeMode escapeMode = EscapeMode.computeEscapeMode(data.getValue(VAR_ESCAPE_MODE_KEY), data.getBooleanValue(AUTO_ESCAPE_KEY));
        if (escapeMode.equals((Object)EscapeMode.ESCAPE_NONE)) {
            escapeMode = this.options.getEscapeMode();
        }
        return escapeMode;
    }

    public Appendable createAppendableBuffer() {
        return this.outputBufferProvider.get();
    }

    public void releaseAppendableBuffer(Appendable buffer) {
        this.outputBufferProvider.release(buffer);
    }

    public void registerGlobalFunction(String name, Function function) {
        this.globalFunctions.registerFunction(name, function);
    }

    public void registerGlobalFunction(String name, TextFilter textFilter) {
        this.globalFunctions.registerFunction(name, textFilter);
    }

    public void registerGlobalEscaper(String name, TextFilter escaper) {
        this.globalFunctions.registerFunction(name + "_escape", escaper, true);
        this.globalFunctions.registerEscapeMode(name, escaper);
    }

    public Data createData() {
        return this.dataFactory.createData();
    }

    public void loadData(String dataFileName, Data output) throws JSilverBadSyntaxException, IOException {
        this.dataFactory.loadData(dataFileName, this.defaultResourceLoader, output);
    }

    public Data loadData(String dataFileName) throws IOException {
        return this.dataFactory.loadData(dataFileName, this.defaultResourceLoader);
    }

    public ResourceLoader getResourceLoader() {
        return this.defaultResourceLoader;
    }

    public void clearCache() {
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public JSilverOptions getOptions() {
        return this.options.clone();
    }
}

