/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver.jni;

import java.io.File;
import java.util.regex.Pattern;

public final class JNI {
    public static Runnable EXIT_JVM = new Runnable(){

        public void run() {
            System.err.println("Could not load '" + libraryName + "'. Searched:");
            String platformLibraryName = System.mapLibraryName(libraryName);
            for (String path : librarySearchPaths) {
                System.err.println("  " + new File(path, platformLibraryName).getAbsolutePath());
            }
            System.err.println("Try specifying -Djava.library.path=[directory] or calling " + JNI.class.getName() + ".setLibrarySearchPaths(String...)");
            System.exit(1);
        }
    };
    public static Runnable THROW_ERROR = new Runnable(){

        public void run() {
            throw new UnsatisfiedLinkError("Could not load '" + libraryName + "'");
        }
    };
    private static Runnable failureCallback = EXIT_JVM;
    private static Object callbackLock = new Object();
    private static String libraryName = "clearsilver-jni";
    private static String[] librarySearchPaths = System.getProperty("java.library.path", ".").split(Pattern.quote(File.pathSeparator));
    private static volatile boolean successfullyLoadedLibrary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary() {
        if (successfullyLoadedLibrary) {
            return;
        }
        Object object = callbackLock;
        synchronized (object) {
            String platformLibraryName = System.mapLibraryName(libraryName);
            for (String path : librarySearchPaths) {
                try {
                    System.load(new File(path, platformLibraryName).getAbsolutePath());
                    successfullyLoadedLibrary = true;
                    return;
                }
                catch (UnsatisfiedLinkError e) {
                }
            }
            if (failureCallback != null) {
                failureCallback.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFailureCallback(Runnable failureCallback) {
        Object object = callbackLock;
        synchronized (object) {
            JNI.failureCallback = failureCallback;
        }
    }

    public static void setLibraryName(String libraryName) {
        JNI.libraryName = libraryName;
    }

    public static void setLibrarySearchPaths(String ... paths) {
        librarySearchPaths = paths;
    }
}

