/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Errors;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SampleTagInfo
extends TagInfo {
    static final int STATE_BEGIN = 0;
    static final int STATE_MATCHING = 1;
    static final Pattern TEXT = Pattern.compile("[\r\n \t]*([^\r\n \t]*)[\r\n \t]*([0-9A-Za-z_]*)[\r\n \t]*", 32);
    private static final String BEGIN_INCLUDE = "BEGIN_INCLUDE";
    private static final String END_INCLUDE = "END_INCLUDE";
    private ContainerInfo mBase;
    private String mIncluded;

    public static String escapeHtml(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static boolean isIncludeLine(String str) {
        return str.indexOf(BEGIN_INCLUDE) >= 0 || str.indexOf(END_INCLUDE) >= 0;
    }

    SampleTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo position) {
        super(name, kind, text, position);
        this.mBase = base;
        Matcher m = TEXT.matcher(text);
        if (!m.matches()) {
            Errors.error(Errors.BAD_INCLUDE_TAG, position, "Bad @include tag: " + text);
            return;
        }
        String filename = m.group(1);
        String id = m.group(2);
        boolean trim = "@sample".equals(name);
        this.mIncluded = id == null || "".equals(id) ? SampleTagInfo.readFile(position, filename, id, trim, true, false) : SampleTagInfo.loadInclude(position, filename, id, trim);
        if (this.mIncluded == null) {
            Errors.error(Errors.BAD_INCLUDE_TAG, position, "include tag '" + id + "' not found in file: " + filename);
        }
    }

    static String getTrimString(String line) {
        char c;
        int i;
        int len = line.length();
        for (i = 0; i < len && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
        }
        if (i == len) {
            return null;
        }
        return line.substring(0, i);
    }

    /*
     * Exception decompiling
     */
    static String loadInclude(SourcePositionInfo pos, String filename, String id, boolean trim) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFile(SourcePositionInfo pos, String filename, String id, boolean trim, boolean escape, boolean errorOk) {
        FileReader input = null;
        StringBuilder result = new StringBuilder();
        int trailing = 0;
        boolean started = false;
        try {
            String line;
            input = new FileReader(filename);
            LineNumberReader lines = new LineNumberReader(input);
            while ((line = lines.readLine()) != null) {
                if (trim) {
                    if (SampleTagInfo.isIncludeLine(line)) continue;
                    if (!"".equals(line.trim())) {
                        if (started) {
                            for (int i = 0; i < trailing; ++i) {
                                result.append('\n');
                            }
                        }
                        if (escape) {
                            line = SampleTagInfo.escapeHtml(line);
                        }
                        result.append(line);
                        trailing = 1;
                        started = true;
                        continue;
                    }
                    if (!started) continue;
                    ++trailing;
                    continue;
                }
                result.append(line);
                result.append('\n');
            }
        }
        catch (IOException e) {
            if (errorOk) {
                String string = null;
                return string;
            }
            Errors.error(Errors.BAD_INCLUDE_TAG, pos, "Error reading file for include \"" + id + "\" " + filename);
        }
        finally {
            if (input != null) {
                try {
                    ((Reader)input).close();
                }
                catch (IOException ex) {}
            }
        }
        return result.substring(0);
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".kind", this.kind());
        if (this.mIncluded != null) {
            data.setValue(base + ".text", this.mIncluded);
        } else {
            data.setValue(base + ".text", "INCLUDE_ERROR");
        }
    }
}

