/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultipleCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.Node;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.syntax.node.TString;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarOptimizer
extends DepthFirstAdapter {
    private final Collection<String> escaperNames;
    private static final String ESCAPE_SUFFIX = "_escape";

    public VarOptimizer(Collection<String> escaperNames) {
        this.escaperNames = escaperNames;
    }

    @Override
    public void caseAMultipleCommand(AMultipleCommand multiCommand) {
        super.caseAMultipleCommand(multiCommand);
        multiCommand.replaceBy(VarOptimizer.optimizeEscapeSequences(multiCommand));
    }

    @Override
    public void caseAVarCommand(AVarCommand varCommand) {
        super.caseAVarCommand(varCommand);
        varCommand.replaceBy(this.optimizeVarCommands(varCommand));
    }

    private PCommand optimizeVarCommands(AVarCommand varCommand) {
        LinkedList<PExpression> args;
        AFunctionExpression functionExpression;
        String name;
        PExpression expression = varCommand.getExpression();
        PPosition position = varCommand.getPosition();
        if (expression instanceof AAddExpression) {
            AAddExpression addExpression = (AAddExpression)expression;
            AMultipleCommand multiCommand = new AMultipleCommand();
            VarOptimizer.addToContents(multiCommand, this.optimizedVarCommandOf(position, addExpression.getLeft()));
            VarOptimizer.addToContents(multiCommand, this.optimizedVarCommandOf(position, addExpression.getRight()));
            return VarOptimizer.optimizeEscapeSequences(multiCommand);
        }
        if (expression instanceof AFunctionExpression && this.escaperNames.contains(name = VarOptimizer.escapeNameOf(functionExpression = (AFunctionExpression)expression)) && (args = functionExpression.getArgs()).size() == 1) {
            return new AEscapeCommand(position, VarOptimizer.quotedStringExpressionOf(name), this.optimizedVarCommandOf(position, args.getFirst()));
        }
        return varCommand;
    }

    private PCommand optimizedVarCommandOf(PPosition position, PExpression expression) {
        return this.optimizeVarCommands(new AVarCommand(VarOptimizer.cloneOf(position), VarOptimizer.cloneOf(expression)));
    }

    private static <T extends Node> T cloneOf(T t) {
        return (T)((Node)t.clone());
    }

    private static void addToContents(AMultipleCommand multi, PCommand command) {
        if (command instanceof AMultipleCommand) {
            multi.getCommand().addAll(((AMultipleCommand)command).getCommand());
        } else {
            multi.getCommand().add(command);
        }
    }

    private static String escapeNameOf(AFunctionExpression function) {
        PVariable nvar = function.getName();
        if (!(nvar instanceof ANameVariable)) {
            return null;
        }
        String name = ((ANameVariable)nvar).getWord().getText();
        if (!name.endsWith(ESCAPE_SUFFIX)) {
            return null;
        }
        return name.substring(0, name.length() - ESCAPE_SUFFIX.length());
    }

    private static AStringExpression quotedStringExpressionOf(String text) {
        assert (text.indexOf(34) == -1);
        return new AStringExpression(new TString('\"' + text + '\"'));
    }

    private static PCommand optimizeEscapeSequences(AMultipleCommand multiCommand) {
        AEscapeCommand lastEscapeCommand = null;
        LinkedList<PCommand> commands = new LinkedList<PCommand>();
        for (PCommand command : multiCommand.getCommand()) {
            AEscapeCommand escapeCommand = VarOptimizer.asSimpleEscapeCommand(command);
            if (VarOptimizer.isSameEscaper(escapeCommand, lastEscapeCommand)) {
                VarOptimizer.addToContents(VarOptimizer.contentsOf(lastEscapeCommand), escapeCommand.getCommand());
                continue;
            }
            commands.add(command);
            lastEscapeCommand = escapeCommand;
        }
        assert (!commands.isEmpty());
        return commands.size() > 1 ? new AMultipleCommand(commands) : (PCommand)commands.getFirst();
    }

    private static AMultipleCommand contentsOf(AEscapeCommand escapeCommand) {
        PCommand escapedCommand = escapeCommand.getCommand();
        if (escapedCommand instanceof AMultipleCommand) {
            return (AMultipleCommand)escapedCommand;
        }
        AMultipleCommand multiCommand = new AMultipleCommand();
        multiCommand.getCommand().add(escapedCommand);
        escapeCommand.setCommand(multiCommand);
        return multiCommand;
    }

    private static AEscapeCommand asSimpleEscapeCommand(PCommand command) {
        if (!(command instanceof AEscapeCommand)) {
            return null;
        }
        AEscapeCommand escapeCommand = (AEscapeCommand)command;
        if (!(escapeCommand.getExpression() instanceof AStringExpression)) {
            return null;
        }
        return escapeCommand;
    }

    private static boolean isSameEscaper(AEscapeCommand newCommand, AEscapeCommand oldCommand) {
        if (newCommand == null || oldCommand == null) {
            return false;
        }
        return VarOptimizer.simpleNameOf(newCommand).equals(VarOptimizer.simpleNameOf(oldCommand));
    }

    private static String simpleNameOf(AEscapeCommand escapeCommand) {
        return ((AStringExpression)escapeCommand.getExpression()).getValue().getText();
    }
}

