/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.testng.guice.Binder;
import org.testng.guice.ConfigurationException;
import org.testng.guice.Key;
import org.testng.guice.Provider;
import org.testng.guice.TypeLiteral;
import org.testng.guice.binder.AnnotatedBindingBuilder;
import org.testng.guice.internal.AbstractBindingBuilder;
import org.testng.guice.internal.BindingImpl;
import org.testng.guice.internal.ImmutableSet;
import org.testng.guice.internal.InstanceBindingImpl;
import org.testng.guice.internal.LinkedBindingImpl;
import org.testng.guice.internal.LinkedProviderBindingImpl;
import org.testng.guice.internal.Preconditions;
import org.testng.guice.internal.ProviderInstanceBindingImpl;
import org.testng.guice.spi.Element;
import org.testng.guice.spi.InjectionPoint;
import org.testng.guice.spi.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public BindingBuilder<T> annotatedWith(Annotation annotation) {
        this.annotatedWithInternal(annotation);
        return this;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(TypeLiteral<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> linkedKey) {
        Preconditions.checkNotNull(linkedKey, "linkedKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Set injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethodsAndFields(instance.getClass());
            }
            catch (ConfigurationException e) {
                for (Message message : e.getErrorMessages()) {
                    this.binder.addError(message);
                }
                injectionPoints = (Set)e.getPartialValue();
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = ImmutableSet.of();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider) {
        Set injectionPoints;
        Preconditions.checkNotNull(provider, "provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        }
        catch (ConfigurationException e) {
            for (Message message : e.getErrorMessages()) {
                this.binder.addError(message);
            }
            injectionPoints = (Set)e.getPartialValue();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, provider));
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(Key<? extends Provider<? extends T>> providerKey) {
        Preconditions.checkNotNull(providerKey, "providerKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedProviderBindingImpl(base.getSource(), base.getKey(), base.getScoping(), providerKey));
        return this;
    }

    public String toString() {
        return "BindingBuilder<" + this.getBinding().getKey().getTypeLiteral() + ">";
    }
}

