/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.Catchtable;
import jas.ClassEnv;
import jas.GenericAttr;
import jas.Insn;
import jas.Label;
import jas.LineTableAttr;
import jas.LocalVarTableAttr;
import jas.LocalVarTypeTableAttr;
import jas.StackMap;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CodeAttr {
    static CP attr = new AsciiCP("Code");
    short stack_size = 1;
    short num_locals = 1;
    int code_size;
    Vector insns = new Vector();
    Hashtable insn_pc;
    Catchtable ctb = null;
    LineTableAttr ltab;
    LocalVarTableAttr lvar;
    LocalVarTypeTableAttr lvtyp;
    StackMap stackmap;
    Vector generic = new Vector();

    public void setCatchtable(Catchtable ctb) {
        this.ctb = ctb;
    }

    public void setLineTable(LineTableAttr ltab) {
        this.ltab = ltab;
    }

    public void setLocalVarTable(LocalVarTableAttr lvar) {
        this.lvar = lvar;
    }

    public void setLocalVarTypeTable(LocalVarTypeTableAttr lvtyp) {
        this.lvtyp = lvtyp;
    }

    public void setStackMap(StackMap s) {
        this.stackmap = s;
    }

    public void addGenericAttr(GenericAttr g) {
        this.generic.addElement(g);
    }

    public void addInsn(Insn insn) {
        this.insns.addElement(insn);
    }

    public void setStackSize(short stack_size) {
        this.stack_size = stack_size;
    }

    public void setVarSize(short num_vars) {
        this.num_locals = num_vars;
    }

    void resolve(ClassEnv e) {
        e.addCPItem(attr);
        Enumeration en = this.insns.elements();
        while (en.hasMoreElements()) {
            Insn i = (Insn)en.nextElement();
            i.resolve(e);
        }
        if (this.ctb != null) {
            this.ctb.resolve(e);
        }
        if (this.ltab != null) {
            this.ltab.resolve(e);
        }
        if (this.lvar != null) {
            this.lvar.resolve(e);
        }
        if (this.lvtyp != null) {
            this.lvtyp.resolve(e);
        }
        if (this.stackmap != null) {
            this.stackmap.resolve(e);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.resolve(e);
        }
    }

    int getPc(Insn i) throws jasError {
        if (this.insn_pc == null) {
            throw new jasError("Internal error, insn_pc has not been initialized");
        }
        Integer tmp = i instanceof Label ? (Integer)this.insn_pc.get(((Label)i).id) : (Integer)this.insn_pc.get(i);
        if (tmp == null) {
            throw new jasError(i + " has not been added to the code");
        }
        return tmp;
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        int code_size = 0;
        this.insn_pc = new Hashtable();
        Enumeration en = this.insns.elements();
        while (en.hasMoreElements()) {
            Insn now = (Insn)en.nextElement();
            if (now instanceof Label) {
                this.insn_pc.put(((Label)now).id, new Integer(code_size));
            } else {
                this.insn_pc.put(now, new Integer(code_size));
            }
            code_size += now.size(e, this);
        }
        int total_size = code_size;
        if (this.ctb != null) {
            total_size += this.ctb.size();
        }
        if (this.ltab != null) {
            total_size += this.ltab.size();
        }
        if (this.lvar != null) {
            total_size += this.lvar.size();
        }
        if (this.lvtyp != null) {
            total_size += this.lvtyp.size();
        }
        if (this.stackmap != null) {
            total_size += this.stackmap.size(e, this);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            total_size += gattr.size();
        }
        out.writeShort(e.getCPIndex(attr));
        out.writeInt(total_size += 12);
        out.writeShort(this.stack_size);
        out.writeShort(this.num_locals);
        out.writeInt(code_size);
        Enumeration en2 = this.insns.elements();
        while (en2.hasMoreElements()) {
            Insn now = (Insn)en2.nextElement();
            now.write(e, this, out);
        }
        if (this.ctb != null) {
            this.ctb.write(e, this, out);
        } else {
            out.writeShort(0);
        }
        int extra = 0;
        if (this.ltab != null) {
            extra = (short)(extra + 1);
        }
        if (this.lvar != null) {
            extra = (short)(extra + 1);
        }
        if (this.lvtyp != null) {
            extra = (short)(extra + 1);
        }
        if (this.stackmap != null) {
            extra = (short)(extra + 1);
        }
        extra = (short)(extra + this.generic.size());
        out.writeShort(extra);
        if (this.ltab != null) {
            this.ltab.write(e, this, out);
        }
        if (this.lvar != null) {
            this.lvar.write(e, this, out);
        }
        if (this.lvtyp != null) {
            this.lvtyp.write(e, this, out);
        }
        if (this.stackmap != null) {
            this.stackmap.write(e, this, out);
        }
        Enumeration gen2 = this.generic.elements();
        while (gen2.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen2.nextElement();
            gattr.write(e, out);
        }
    }

    public String toString() {
        return "<#code-attr>";
    }
}

