/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import hidden.org.codehaus.plexus.util.FileUtils;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.InterpolationFilterReader;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.DuplicateChildContainerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.composition.ComponentComposerManager;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.UndefinedComponentComposerException;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.discovery.DiscoveryListenerDescriptor;
import org.codehaus.plexus.component.discovery.PlexusXmlComponentDiscoverer;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.factory.UndefinedComponentFactoryException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerManager;
import org.codehaus.plexus.component.manager.UndefinedComponentManagerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.configuration.PlexusConfigurationResourceException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessor;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.configuration.processor.DirectoryConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.FileConfigurationResourceHandler;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements PlexusContainer {
    private PlexusContainer parentContainer;
    private LoggerManager loggerManager;
    private DefaultContext context;
    protected PlexusConfiguration configuration;
    private Reader configurationReader;
    private ClassWorld classWorld;
    private ClassRealm coreRealm;
    private ClassRealm plexusRealm;
    private String name;
    private ComponentRepository componentRepository;
    private ComponentManagerManager componentManagerManager;
    private LifecycleHandlerManager lifecycleHandlerManager;
    private ComponentDiscovererManager componentDiscovererManager;
    private ComponentFactoryManager componentFactoryManager;
    private ComponentComposerManager componentComposerManager;
    private Map childContainers = new WeakHashMap();
    public static final String BOOTSTRAP_CONFIGURATION = "org/codehaus/plexus/plexus-bootstrap.xml";
    private boolean started = false;
    private boolean initialized = false;
    private final Date creationDate = new Date();
    static /* synthetic */ Class class$org$codehaus$plexus$PlexusContainer;

    public DefaultPlexusContainer() {
        this.context = new DefaultContext();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean hasChildContainer(String name) {
        return this.childContainers.get(name) != null;
    }

    public void removeChildContainer(String name) {
        this.childContainers.remove(name);
    }

    public PlexusContainer getChildContainer(String name) {
        return (PlexusContainer)this.childContainers.get(name);
    }

    public PlexusContainer createChildContainer(String name, List classpathJars, Map context) throws PlexusContainerException {
        return this.createChildContainer(name, classpathJars, context, Collections.EMPTY_LIST);
    }

    public PlexusContainer createChildContainer(String name, List classpathJars, Map context, List discoveryListeners) throws PlexusContainerException {
        if (this.hasChildContainer(name)) {
            throw new DuplicateChildContainerException(this.getName(), name);
        }
        DefaultPlexusContainer child = new DefaultPlexusContainer();
        child.classWorld = this.classWorld;
        ClassRealm childRealm = null;
        String childRealmId = this.getName() + ".child-container[" + name + "]";
        try {
            childRealm = this.classWorld.getRealm(childRealmId);
        }
        catch (NoSuchRealmException e) {
            try {
                childRealm = this.classWorld.newRealm(childRealmId);
            }
            catch (DuplicateRealmException impossibleError) {
                this.getLogger().error("An impossible error has occurred. After getRealm() failed, newRealm() produced duplication error on same id!", impossibleError);
            }
        }
        childRealm.setParent(this.plexusRealm);
        child.coreRealm = childRealm;
        child.plexusRealm = childRealm;
        child.setName(name);
        child.setParentPlexusContainer(this);
        child.setLoggerManager(this.loggerManager);
        Iterator it = context.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            child.addContextValue(entry.getKey(), entry.getValue());
        }
        child.initialize();
        it = classpathJars.iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            File jar = (File)((Object)next);
            child.addJarResource(jar);
        }
        it = discoveryListeners.iterator();
        while (it.hasNext()) {
            ComponentDiscoveryListener listener = (ComponentDiscoveryListener)((Object)it.next());
            child.registerComponentDiscoveryListener(listener);
        }
        child.start();
        this.childContainers.put(name, child);
        return child;
    }

    public Object lookup(String componentKey) throws ComponentLookupException {
        Object component = null;
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentKey(componentKey);
        if (componentManager == null) {
            ComponentDescriptor descriptor = this.componentRepository.getComponentDescriptor(componentKey);
            if (descriptor == null) {
                if (this.parentContainer != null) {
                    return this.parentContainer.lookup(componentKey);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Nonexistent component: " + componentKey);
                }
                String message = "Component descriptor cannot be found in the component repository: " + componentKey + ".";
                throw new ComponentLookupException(message);
            }
            componentManager = this.createComponentManager(descriptor);
        }
        try {
            component = componentManager.getComponent();
        }
        catch (ComponentInstantiationException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentKey + "', it could not be created", e);
        }
        catch (ComponentLifecycleException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentKey + "', it could not be started", e);
        }
        this.componentManagerManager.associateComponentWithComponentManager(component, componentManager);
        return component;
    }

    private ComponentManager createComponentManager(ComponentDescriptor descriptor) throws ComponentLookupException {
        ComponentManager componentManager;
        try {
            componentManager = this.componentManagerManager.createComponentManager(descriptor, this);
        }
        catch (UndefinedComponentManagerException e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            throw new ComponentLookupException(message, e);
        }
        catch (UndefinedLifecycleHandlerException e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            throw new ComponentLookupException(message, e);
        }
        return componentManager;
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        HashMap<String, Object> components = new HashMap<String, Object>();
        Map componentDescriptors = this.getComponentDescriptorMap(role);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.keySet().iterator();
            while (i.hasNext()) {
                String roleHint = (String)i.next();
                Object component = this.lookup(role, roleHint);
                components.put(roleHint, component);
            }
        }
        return components;
    }

    public List lookupList(String role) throws ComponentLookupException {
        ArrayList<Object> components = new ArrayList<Object>();
        List componentDescriptors = this.getComponentDescriptorList(role);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.iterator();
            while (i.hasNext()) {
                ComponentDescriptor descriptor = (ComponentDescriptor)i.next();
                String roleHint = descriptor.getRoleHint();
                Object component = roleHint != null ? this.lookup(role, roleHint) : this.lookup(role);
                components.add(component);
            }
        }
        return components;
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.lookup(role + roleHint);
    }

    public ComponentDescriptor getComponentDescriptor(String componentKey) {
        ComponentDescriptor result = this.componentRepository.getComponentDescriptor(componentKey);
        if (result == null && this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptor(componentKey);
        }
        return result;
    }

    public Map getComponentDescriptorMap(String role) {
        Map componentDescriptors;
        Map result = null;
        if (this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptorMap(role);
        }
        if ((componentDescriptors = this.componentRepository.getComponentDescriptorMap(role)) != null) {
            if (result != null) {
                result.putAll(componentDescriptors);
            } else {
                result = componentDescriptors;
            }
        }
        return result;
    }

    public List getComponentDescriptorList(String role) {
        ComponentDescriptor unhintedDescriptor;
        List<Object> result = null;
        Map componentDescriptorsByHint = this.getComponentDescriptorMap(role);
        result = componentDescriptorsByHint != null ? new ArrayList(componentDescriptorsByHint.values()) : ((unhintedDescriptor = this.getComponentDescriptor(role)) != null ? Collections.singletonList(unhintedDescriptor) : Collections.EMPTY_LIST);
        return result;
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        this.componentRepository.addComponentDescriptor(componentDescriptor);
    }

    public void release(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        if (componentManager == null) {
            if (this.parentContainer != null) {
                this.parentContainer.release(component);
            } else {
                this.getLogger().warn("Component manager not found for returned component. Ignored. component=" + component);
            }
        } else {
            componentManager.release(component);
            if (componentManager.getConnections() <= 0) {
                this.componentManagerManager.unassociateComponentWithComponentManager(component);
            }
        }
    }

    public void releaseAll(Map components) throws ComponentLifecycleException {
        Iterator i = components.values().iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public void releaseAll(List components) throws ComponentLifecycleException {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public boolean hasComponent(String componentKey) {
        return this.componentRepository.hasComponent(componentKey);
    }

    public boolean hasComponent(String role, String roleHint) {
        return this.componentRepository.hasComponent(role, roleHint);
    }

    public void suspend(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.suspend(component);
    }

    public void resume(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.resume(component);
    }

    public ClassRealm getComponentRealm(String id) {
        return this.plexusRealm;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() throws PlexusContainerException {
        try {
            this.initializeClassWorlds();
            this.initializeConfiguration();
            this.initializeResources();
            this.initializeCoreComponents();
            this.initializeLoggerManager();
            this.initializeContext();
            this.initializeSystemProperties();
            this.initialized = true;
        }
        catch (DuplicateRealmException e) {
            throw new PlexusContainerException("Error initializing classworlds", e);
        }
        catch (ConfigurationProcessingException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (ConfigurationResourceNotFoundException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (ComponentConfigurationException e) {
            throw new PlexusContainerException("Error configuring components", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Error configuring components", e);
        }
        catch (ComponentRepositoryException e) {
            throw new PlexusContainerException("Error initializing components", e);
        }
        catch (ContextException e) {
            throw new PlexusContainerException("Error contextualizing components", e);
        }
    }

    public void registerComponentDiscoveryListeners() throws ComponentLookupException {
        List listeners = this.componentDiscovererManager.getListenerDescriptors();
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                DiscoveryListenerDescriptor listenerDescriptor = (DiscoveryListenerDescriptor)i.next();
                String role = listenerDescriptor.getRole();
                ComponentDiscoveryListener l = (ComponentDiscoveryListener)this.lookup(role);
                this.componentDiscovererManager.registerComponentDiscoveryListener(l);
            }
        }
    }

    public List discoverComponents(ClassRealm classRealm) throws PlexusConfigurationException, ComponentRepositoryException {
        ArrayList<ComponentDescriptor> discoveredComponentDescriptors = new ArrayList<ComponentDescriptor>();
        Iterator i = this.componentDiscovererManager.getComponentDiscoverers().iterator();
        while (i.hasNext()) {
            ComponentDiscoverer componentDiscoverer = (ComponentDiscoverer)i.next();
            List componentSetDescriptors = componentDiscoverer.findComponents(this.getContext(), classRealm);
            Iterator j = componentSetDescriptors.iterator();
            while (j.hasNext()) {
                ComponentSetDescriptor componentSet = (ComponentSetDescriptor)j.next();
                List componentDescriptors = componentSet.getComponents();
                if (componentDescriptors == null) continue;
                Iterator k = componentDescriptors.iterator();
                while (k.hasNext()) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)k.next();
                    componentDescriptor.setComponentSetDescriptor(componentSet);
                    if (this.getComponentDescriptor(componentDescriptor.getComponentKey()) != null) continue;
                    this.addComponentDescriptor(componentDescriptor);
                    discoveredComponentDescriptors.add(componentDescriptor);
                }
            }
        }
        return discoveredComponentDescriptors;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws PlexusContainerException {
        try {
            this.registerComponentDiscoveryListeners();
            this.discoverComponents(this.plexusRealm);
            this.loadComponentsOnStart();
            this.started = true;
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Error starting container", e);
        }
        catch (ComponentLookupException e) {
            throw new PlexusContainerException("Error starting container", e);
        }
        catch (ComponentRepositoryException e) {
            throw new PlexusContainerException("Error starting container", e);
        }
        this.configuration = null;
    }

    public void dispose() {
        this.disposeAllComponents();
        if (this.parentContainer != null) {
            this.parentContainer.removeChildContainer(this.getName());
            this.parentContainer = null;
        }
        try {
            this.plexusRealm.setParent(null);
            this.classWorld.disposeRealm(this.plexusRealm.getId());
        }
        catch (NoSuchRealmException e) {
            this.getLogger().debug("Failed to dispose realm for exiting container: " + this.getName(), e);
        }
        this.started = false;
        this.initialized = true;
    }

    protected void disposeAllComponents() {
        ArrayList collection = new ArrayList(this.componentManagerManager.getComponentManagers().values());
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            try {
                ((ComponentManager)iter.next()).dispose();
            }
            catch (Exception e) {
                this.getLogger().error("Error while disposing component manager. Continuing with the rest", e);
            }
        }
        this.componentManagerManager.getComponentManagers().clear();
    }

    public void setParentPlexusContainer(PlexusContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    public void addContextValue(Object key, Object value) {
        this.context.put(key, value);
    }

    public void setConfigurationResource(Reader configuration) throws PlexusConfigurationResourceException {
        this.configurationReader = configuration;
    }

    protected void loadComponentsOnStart() throws PlexusConfigurationException, ComponentLookupException {
        PlexusConfiguration[] loadOnStartComponents = this.configuration.getChild("load-on-start").getChildren("component");
        this.getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
        for (int i = 0; i < loadOnStartComponents.length; ++i) {
            String role = loadOnStartComponents[i].getChild("role").getValue(null);
            String roleHint = loadOnStartComponents[i].getChild("role-hint").getValue();
            if (role == null) {
                throw new PlexusConfigurationException("Missing 'role' element from load-on-start.");
            }
            if (roleHint == null) {
                this.getLogger().info("Loading on start [role]: [" + role + "]");
                this.lookup(role);
                continue;
            }
            if (roleHint.equals("*")) {
                this.getLogger().info("Loading on start all components with [role]: [" + role + "]");
                this.lookupList(role);
                continue;
            }
            this.getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
            this.lookup(role, roleHint);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public ClassRealm getCoreRealm() {
        return this.coreRealm;
    }

    public void setCoreRealm(ClassRealm coreRealm) {
        this.coreRealm = coreRealm;
    }

    private void initializeClassWorlds() throws DuplicateRealmException {
        if (this.classWorld == null) {
            this.classWorld = new ClassWorld();
        }
        this.initializeName();
        if (this.coreRealm == null) {
            try {
                this.coreRealm = this.classWorld.getRealm("plexus.core");
            }
            catch (NoSuchRealmException e) {
                this.coreRealm = this.classWorld.newRealm("plexus.core", Thread.currentThread().getContextClassLoader());
            }
        }
        if (this.plexusRealm == null) {
            try {
                this.plexusRealm = this.coreRealm.getWorld().getRealm("plexus.core.maven");
            }
            catch (NoSuchRealmException e) {
                this.plexusRealm = this.coreRealm;
            }
            this.addContextValue("common.classloader", this.plexusRealm.getClassLoader());
            Thread.currentThread().setContextClassLoader(this.plexusRealm.getClassLoader());
        }
    }

    public ClassRealm getContainerRealm() {
        return this.plexusRealm;
    }

    protected void initializeName() {
        if (this.name == null) {
            int i = 0;
            try {
                while (true) {
                    this.classWorld.getRealm("plexus.app" + i);
                    ++i;
                }
            }
            catch (NoSuchRealmException e) {
                this.setName("app" + i);
                return;
            }
        }
    }

    public Context getContext() {
        return this.context;
    }

    private void initializeContext() {
        this.addContextValue("plexus", this);
        this.addContextValue("coreRealm", this.plexusRealm);
    }

    protected void initializeConfiguration() throws ConfigurationProcessingException, ConfigurationResourceNotFoundException, PlexusConfigurationException {
        PlexusConfiguration systemConfiguration;
        InputStream is = this.coreRealm.getResourceAsStream(BOOTSTRAP_CONFIGURATION);
        if (is == null) {
            throw new IllegalStateException("The internal default plexus-bootstrap.xml is missing. This is highly irregular, your plexus JAR is most likely corrupt.");
        }
        this.configuration = systemConfiguration = PlexusTools.buildConfiguration(BOOTSTRAP_CONFIGURATION, new InputStreamReader(is));
        PlexusXmlComponentDiscoverer discoverer = new PlexusXmlComponentDiscoverer();
        PlexusConfiguration plexusConfiguration = discoverer.discoverConfiguration(this.getContext(), this.plexusRealm);
        if (plexusConfiguration != null) {
            this.configuration = PlexusConfigurationMerger.merge(plexusConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        if (this.configurationReader != null) {
            PlexusConfiguration userConfiguration = PlexusTools.buildConfiguration("<User Specified Configuration Reader>", this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge(userConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        ConfigurationProcessor p = new ConfigurationProcessor();
        p.addConfigurationResourceHandler(new FileConfigurationResourceHandler());
        p.addConfigurationResourceHandler(new DirectoryConfigurationResourceHandler());
        this.configuration = p.process(this.configuration, Collections.EMPTY_MAP);
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, new ContextMapAdapter(this.context));
        return interpolationFilterReader;
    }

    private void processConfigurationsDirectory() throws PlexusConfigurationException {
        String s = this.configuration.getChild("configurations-directory").getValue(null);
        if (s != null) {
            PlexusConfiguration componentsConfiguration = this.configuration.getChild("components");
            File configurationsDirectory = new File(s);
            if (configurationsDirectory.exists() && configurationsDirectory.isDirectory()) {
                List componentConfigurationFiles = null;
                try {
                    componentConfigurationFiles = FileUtils.getFiles(configurationsDirectory, "**/*.conf", "**/*.xml");
                }
                catch (IOException e) {
                    throw new PlexusConfigurationException("Unable to locate configuration files", e);
                }
                Iterator i = componentConfigurationFiles.iterator();
                while (i.hasNext()) {
                    File componentConfigurationFile = (File)i.next();
                    FileReader reader = null;
                    try {
                        reader = new FileReader(componentConfigurationFile);
                        PlexusConfiguration componentConfiguration = PlexusTools.buildConfiguration(componentConfigurationFile.getAbsolutePath(), this.getInterpolationConfigurationReader(reader));
                        componentsConfiguration.addChild(componentConfiguration.getChild("components"));
                    }
                    catch (FileNotFoundException e) {
                        try {
                            throw new PlexusConfigurationException("File " + componentConfigurationFile + " disappeared before processing", e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close(reader);
                }
            }
        }
    }

    private void initializeLoggerManager() throws PlexusContainerException {
        if (this.loggerManager == null) {
            try {
                this.loggerManager = (LoggerManager)this.lookup(LoggerManager.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new PlexusContainerException("Unable to locate logger manager", e);
            }
        }
        this.enableLogging(this.loggerManager.getLoggerForComponent((class$org$codehaus$plexus$PlexusContainer == null ? (class$org$codehaus$plexus$PlexusContainer = DefaultPlexusContainer.class$("org.codehaus.plexus.PlexusContainer")) : class$org$codehaus$plexus$PlexusContainer).getName()));
    }

    private void initializeCoreComponents() throws ComponentConfigurationException, ComponentRepositoryException, ContextException {
        BasicComponentConfigurator configurator = new BasicComponentConfigurator();
        PlexusConfiguration c = this.configuration.getChild("component-repository");
        this.processCoreComponentConfiguration("component-repository", configurator, c);
        this.componentRepository.configure(this.configuration);
        this.componentRepository.setClassRealm(this.plexusRealm);
        this.componentRepository.initialize();
        c = this.configuration.getChild("lifecycle-handler-manager");
        this.processCoreComponentConfiguration("lifecycle-handler-manager", configurator, c);
        this.lifecycleHandlerManager.initialize();
        c = this.configuration.getChild("component-manager-manager");
        this.processCoreComponentConfiguration("component-manager-manager", configurator, c);
        this.componentManagerManager.setLifecycleHandlerManager(this.lifecycleHandlerManager);
        c = this.configuration.getChild("component-discoverer-manager");
        this.processCoreComponentConfiguration("component-discoverer-manager", configurator, c);
        this.componentDiscovererManager.initialize();
        c = this.configuration.getChild("component-factory-manager");
        this.processCoreComponentConfiguration("component-factory-manager", configurator, c);
        if (this.componentFactoryManager instanceof Contextualizable) {
            Context context = this.getContext();
            context.put("plexus", this);
            ((Contextualizable)((Object)this.componentFactoryManager)).contextualize(this.getContext());
        }
        c = this.configuration.getChild("component-composer-manager");
        this.processCoreComponentConfiguration("component-composer-manager", configurator, c);
    }

    private void processCoreComponentConfiguration(String role, BasicComponentConfigurator configurator, PlexusConfiguration c) throws ComponentConfigurationException {
        String implementation = c.getAttribute("implementation", null);
        if (implementation == null) {
            String msg = "Core component: '" + role + "' + which is needed by plexus to function properly cannot " + "be instantiated. Implementation attribute was not specified in plexus.conf." + "This is highly irregular, your plexus JAR is most likely corrupt.";
            throw new ComponentConfigurationException(msg);
        }
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRole(role);
        componentDescriptor.setImplementation(implementation);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration("configuration");
        configuration.addChild(c);
        try {
            configurator.configureComponent(this, configuration, this.plexusRealm);
        }
        catch (ComponentConfigurationException e) {
            String message = "Error configuring component: " + componentDescriptor.getHumanReadableKey();
            throw new ComponentConfigurationException(message, (Throwable)e);
        }
    }

    private void initializeSystemProperties() throws PlexusConfigurationException {
        PlexusConfiguration[] systemProperties = this.configuration.getChild("system-properties").getChildren("property");
        for (int i = 0; i < systemProperties.length; ++i) {
            String name = systemProperties[i].getAttribute("name");
            String value = systemProperties[i].getAttribute("value");
            if (name == null) {
                throw new PlexusConfigurationException("Missing 'name' attribute in 'property' tag. ");
            }
            if (value == null) {
                throw new PlexusConfigurationException("Missing 'value' attribute in 'property' tag. ");
            }
            System.getProperties().setProperty(name, value);
            this.getLogger().info("Setting system property: [ " + name + ", " + value + " ]");
        }
    }

    public void initializeResources() throws PlexusConfigurationException {
        PlexusConfiguration[] resourceConfigs = this.configuration.getChild("resources").getChildren();
        for (int i = 0; i < resourceConfigs.length; ++i) {
            try {
                String name = resourceConfigs[i].getName();
                if (name.equals("jar-repository")) {
                    this.addJarRepository(new File(resourceConfigs[i].getValue()));
                    continue;
                }
                if (name.equals("directory")) {
                    File directory = new File(resourceConfigs[i].getValue());
                    if (!directory.exists() || !directory.isDirectory()) continue;
                    this.plexusRealm.addConstituent(directory.toURL());
                    continue;
                }
                this.getLogger().warn("Unknown resource type: " + name);
                continue;
            }
            catch (MalformedURLException e) {
                this.getLogger().error("Error configuring resource: " + resourceConfigs[i].getName() + "=" + resourceConfigs[i].getValue(), e);
            }
        }
    }

    public void addJarResource(File jar) throws PlexusContainerException {
        try {
            this.plexusRealm.addConstituent(jar.toURL());
            if (this.isStarted()) {
                this.discoverComponents(this.plexusRealm);
            }
        }
        catch (MalformedURLException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (bad URL)", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (error discovering new components)", e);
        }
        catch (ComponentRepositoryException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (error discovering new components)", e);
        }
    }

    public void addJarRepository(File repository) {
        if (repository.exists() && repository.isDirectory()) {
            File[] jars = repository.listFiles();
            for (int j = 0; j < jars.length; ++j) {
                if (!jars[j].getAbsolutePath().endsWith(".jar")) continue;
                try {
                    this.addJarResource(jars[j]);
                    continue;
                }
                catch (PlexusContainerException e) {
                    this.getLogger().warn("Unable to add JAR: " + jars[j], e);
                }
            }
        } else {
            this.getLogger().warn("The specified JAR repository doesn't exist or is not a directory: '" + repository.getAbsolutePath() + "'.");
        }
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createComponentInstance(ComponentDescriptor componentDescriptor) throws ComponentInstantiationException, ComponentLifecycleException {
        String componentFactoryId = componentDescriptor.getComponentFactory();
        ComponentFactory componentFactory = null;
        Object component = null;
        try {
            try {
                componentFactory = componentFactoryId != null ? this.componentFactoryManager.findComponentFactory(componentFactoryId) : this.componentFactoryManager.getDefaultComponentFactory();
                component = componentFactory.newInstance(componentDescriptor, this.plexusRealm, this);
            }
            catch (UndefinedComponentFactoryException e) {
                throw new ComponentInstantiationException("Unable to create component as factory '" + componentFactoryId + "' could not be found", e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!StringUtils.isNotEmpty(componentFactoryId)) throw throwable;
            if ("java".equals(componentFactoryId)) throw throwable;
            this.release(componentFactory);
            throw throwable;
        }
        if (!StringUtils.isNotEmpty(componentFactoryId)) return component;
        if ("java".equals(componentFactoryId)) return component;
        this.release(componentFactory);
        return component;
    }

    public void composeComponent(Object component, ComponentDescriptor componentDescriptor) throws CompositionException, UndefinedComponentComposerException {
        this.componentComposerManager.assembleComponent(component, componentDescriptor, this);
    }

    public void registerComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(listener);
    }

    public void removeComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(listener);
    }

    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    public LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

