/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.merge;

import java.io.File;
import java.util.ArrayList;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;

public class Main {
    public Main(String[] args) {
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        File baseDir = null;
        ArrayList<File> filesToMerge = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--datafile")) {
                dataFile = new File(args[++i]);
                continue;
            }
            if (args[i].equals("--basedir")) {
                baseDir = new File(args[++i]);
                continue;
            }
            filesToMerge.add(new File(baseDir, args[i]));
        }
        ProjectData projectData = null;
        if (dataFile.isFile()) {
            projectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        }
        if (projectData == null) {
            projectData = new ProjectData();
        }
        if (filesToMerge.isEmpty()) {
            System.err.println("Error: No files were specified for merging.");
            System.exit(1);
        }
        for (File newDataFile : filesToMerge) {
            ProjectData projectDataNew = CoverageDataFileHandler.loadCoverageData(newDataFile);
            if (projectDataNew == null) continue;
            projectData.merge(projectDataNew);
        }
        CoverageDataFileHandler.saveCoverageData(projectData, dataFile);
    }

    public static void main(String[] args) {
        Header.print(System.out);
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            System.exit(1);
        }
        new Main(args);
    }
}

