/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.SourceHistory;
import net.sf.antcontrib.cpptasks.TargetHistory;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import org.apache.tools.ant.BuildException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TargetHistoryTable {
    private boolean dirty;
    private final Hashtable history = new Hashtable();
    private File historyFile;
    private File outputDir;
    private String outputDirPath;

    public TargetHistoryTable(CCTask task, File outputDir) throws BuildException {
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
        if (!outputDir.isDirectory()) {
            throw new BuildException("Output directory is not a directory");
        }
        if (!outputDir.exists()) {
            throw new BuildException("Output directory does not exist");
        }
        this.outputDir = outputDir;
        try {
            this.outputDirPath = outputDir.getCanonicalPath();
        }
        catch (IOException ex) {
            this.outputDirPath = outputDir.toString();
        }
        this.historyFile = new File(outputDir, "history.xml");
        if (this.historyFile.exists()) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            try {
                SAXParser parser = factory.newSAXParser();
                parser.parse(this.historyFile, (DefaultHandler)new TargetHistoryTableHandler(this.history, outputDir));
            }
            catch (Exception ex) {
                task.log("Error reading history.xml: " + ex.toString());
            }
        } else {
            try {
                FileOutputStream outputStream = new FileOutputStream(this.historyFile);
                byte[] historyElement = new byte[]{60, 104, 105, 115, 116, 111, 114, 121, 47, 62};
                outputStream.write(historyElement);
                outputStream.close();
            }
            catch (IOException ex) {
                throw new BuildException("Can't create history file", (Throwable)ex);
            }
        }
    }

    public void commit() throws IOException {
        if (this.dirty) {
            OutputStreamWriter outWriter;
            Hashtable<String, String> configs = new Hashtable<String, String>(20);
            Enumeration elements = this.history.elements();
            while (elements.hasMoreElements()) {
                TargetHistory targetHistory = (TargetHistory)elements.nextElement();
                String configId = targetHistory.getProcessorConfiguration();
                if (configs.get(configId) != null) continue;
                configs.put(configId, configId);
            }
            FileOutputStream outStream = new FileOutputStream(this.historyFile);
            String encodingName = "UTF-8";
            try {
                outWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                outWriter = new OutputStreamWriter(outStream);
                encodingName = outWriter.getEncoding();
            }
            BufferedWriter writer = new BufferedWriter(outWriter);
            writer.write("<?xml version='1.0' encoding='");
            writer.write(encodingName);
            writer.write("'?>\n");
            writer.write("<history>\n");
            StringBuffer buf = new StringBuffer(200);
            Enumeration configEnum = configs.elements();
            while (configEnum.hasMoreElements()) {
                String configId = (String)configEnum.nextElement();
                buf.setLength(0);
                buf.append("   <processor signature=\"");
                buf.append(CUtil.xmlAttribEncode(configId));
                buf.append("\">\n");
                writer.write(buf.toString());
                elements = this.history.elements();
                while (elements.hasMoreElements()) {
                    TargetHistory targetHistory = (TargetHistory)elements.nextElement();
                    if (!targetHistory.getProcessorConfiguration().equals(configId)) continue;
                    buf.setLength(0);
                    buf.append("      <target file=\"");
                    buf.append(CUtil.xmlAttribEncode(targetHistory.getOutput()));
                    buf.append("\" lastModified=\"");
                    buf.append(Long.toHexString(targetHistory.getOutputLastModified()));
                    buf.append("\">\n");
                    writer.write(buf.toString());
                    SourceHistory[] sourceHistories = targetHistory.getSources();
                    int i = 0;
                    while (i < sourceHistories.length) {
                        buf.setLength(0);
                        buf.append("         <source file=\"");
                        buf.append(CUtil.xmlAttribEncode(sourceHistories[i].getRelativePath()));
                        buf.append("\" lastModified=\"");
                        buf.append(Long.toHexString(sourceHistories[i].getLastModified()));
                        buf.append("\"/>\n");
                        writer.write(buf.toString());
                        ++i;
                    }
                    writer.write("      </target>\n");
                }
                writer.write("   </processor>\n");
            }
            writer.write("</history>\n");
            writer.close();
            this.dirty = false;
        }
    }

    public TargetHistory get(String configId, String outputName) {
        TargetHistory targetHistory = (TargetHistory)this.history.get(outputName);
        if (targetHistory != null && !targetHistory.getProcessorConfiguration().equals(configId)) {
            targetHistory = null;
        }
        return targetHistory;
    }

    public void markForRebuild(Hashtable targetInfos) {
        Enumeration targetInfoEnum = targetInfos.elements();
        while (targetInfoEnum.hasMoreElements()) {
            this.markForRebuild((TargetInfo)targetInfoEnum.nextElement());
        }
    }

    public void markForRebuild(TargetInfo targetInfo) {
        if (!targetInfo.getRebuild()) {
            TargetHistory history = this.get(targetInfo.getConfiguration().toString(), targetInfo.getOutput().getName());
            if (history == null) {
                targetInfo.mustRebuild();
            } else {
                File[] sources;
                SourceHistory[] sourceHistories = history.getSources();
                if (sourceHistories.length != (sources = targetInfo.getSources()).length) {
                    targetInfo.mustRebuild();
                } else {
                    Hashtable<String, File> sourceMap = new Hashtable<String, File>(sources.length);
                    int i = 0;
                    while (i < sources.length) {
                        try {
                            sourceMap.put(sources[i].getCanonicalPath(), sources[i]);
                        }
                        catch (IOException ex) {
                            sourceMap.put(sources[i].getAbsolutePath(), sources[i]);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < sourceHistories.length) {
                        String absPath = sourceHistories[i].getAbsolutePath(this.outputDir);
                        File match = (File)sourceMap.get(absPath);
                        if (match != null) {
                            try {
                                match = (File)sourceMap.get(new File(absPath).getCanonicalPath());
                            }
                            catch (IOException ex) {
                                targetInfo.mustRebuild();
                                break;
                            }
                        }
                        if (match == null || match.lastModified() != sourceHistories[i].getLastModified()) {
                            targetInfo.mustRebuild();
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void update(ProcessorConfiguration config, String[] sources, VersionInfo versionInfo) {
        String configId = config.getIdentifier();
        String[] onesource = new String[1];
        int i = 0;
        while (i < sources.length) {
            onesource[0] = sources[i];
            String[] outputNames = config.getOutputFileNames(sources[i], versionInfo);
            int j = 0;
            while (j < outputNames.length) {
                this.update(configId, outputNames[j], onesource);
                ++j;
            }
            ++i;
        }
    }

    private void update(String configId, String outputName, String[] sources) {
        File outputFile = new File(this.outputDir, outputName);
        if (outputFile.exists() && !CUtil.isSignificantlyBefore(outputFile.lastModified(), this.historyFile.lastModified())) {
            this.dirty = true;
            this.history.remove(outputName);
            SourceHistory[] sourceHistories = new SourceHistory[sources.length];
            int i = 0;
            while (i < sources.length) {
                File sourceFile = new File(sources[i]);
                long lastModified = sourceFile.lastModified();
                String relativePath = CUtil.getRelativePath(this.outputDirPath, sourceFile);
                sourceHistories[i] = new SourceHistory(relativePath, lastModified);
                ++i;
            }
            TargetHistory newHistory = new TargetHistory(configId, outputName, outputFile.lastModified(), sourceHistories);
            this.history.put(outputName, newHistory);
        }
    }

    public void update(TargetInfo linkTarget) {
        File outputFile = linkTarget.getOutput();
        String outputName = outputFile.getName();
        if (outputFile.exists() && !CUtil.isSignificantlyBefore(outputFile.lastModified(), this.historyFile.lastModified())) {
            this.dirty = true;
            this.history.remove(outputName);
            SourceHistory[] sourceHistories = linkTarget.getSourceHistories(this.outputDirPath);
            TargetHistory newHistory = new TargetHistory(linkTarget.getConfiguration().getIdentifier(), outputName, outputFile.lastModified(), sourceHistories);
            this.history.put(outputName, newHistory);
        }
    }

    private class TargetHistoryTableHandler
    extends DefaultHandler {
        private final File baseDir;
        private String config;
        private final Hashtable history;
        private String output;
        private long outputLastModified;
        private final Vector sources = new Vector();

        private TargetHistoryTableHandler(Hashtable history, File baseDir) {
            this.history = history;
            this.config = null;
            this.output = null;
            this.baseDir = baseDir;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("target")) {
                long existingLastModified;
                File existingFile;
                if (this.config != null && this.output != null && (existingFile = new File(this.baseDir, this.output)).exists() && !CUtil.isSignificantlyBefore(existingLastModified = existingFile.lastModified(), this.outputLastModified) && !CUtil.isSignificantlyAfter(existingLastModified, this.outputLastModified)) {
                    Object[] sourcesArray = new SourceHistory[this.sources.size()];
                    this.sources.copyInto(sourcesArray);
                    TargetHistory targetHistory = new TargetHistory(this.config, this.output, this.outputLastModified, (SourceHistory[])sourcesArray);
                    this.history.put(this.output, targetHistory);
                }
                this.output = null;
                this.sources.setSize(0);
            } else if (qName.equals("processor")) {
                this.config = null;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("source")) {
                String sourceFile = atts.getValue("file");
                long sourceLastModified = Long.parseLong(atts.getValue("lastModified"), 16);
                this.sources.addElement(new SourceHistory(sourceFile, sourceLastModified));
            } else if (qName.equals("target")) {
                this.sources.setSize(0);
                this.output = atts.getValue("file");
                this.outputLastModified = Long.parseLong(atts.getValue("lastModified"), 16);
            } else if (qName.equals("processor")) {
                this.config = atts.getValue("signature");
            }
        }
    }
}

